/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import org.eurocarbdb.application.glycoworkbench.plugin.peakpicker.DefaultParamHandler;

public class PeakPicker
extends DefaultParamHandler {
    protected double peak_bound_;
    protected double peak_bound_ms2_level_;
    protected double signal_to_noise_;
    protected double fwhm_bound_;

    public PeakPicker() {
        super("PeakPicker");
        this.setDefaults_();
        this.defaultsToParam_();
    }

    protected void setDefaults_() {
        this.defaults_.setValue("thresholds:signal_to_noise", 3.0, "Minimal signal to noise ratio for a peak to be picked.");
        this.defaults_.setValue("thresholds:peak_bound", 200.0, "Minimal peak intensity.");
        this.defaults_.setValue("thresholds:peak_bound_ms2_level", 50.0, "Minimal peak intensity for MSMS peaks.");
        this.defaults_.setValue("thresholds:fwhm_bound", 0.2, "Minimal peak width");
    }

    @Override
    protected void updateMembers_() {
        this.signal_to_noise_ = (Double)this.param_.getValue("thresholds:signal_to_noise");
        this.peak_bound_ = (Double)this.param_.getValue("thresholds:peak_bound");
        this.peak_bound_ms2_level_ = (Double)this.param_.getValue("thresholds:peak_bound_ms2_level");
        this.fwhm_bound_ = (Double)this.param_.getValue("thresholds:fwhm_bound");
    }

    public double getPeakBound() {
        return this.peak_bound_;
    }

    public void setPeakBound(double peak_bound) {
        this.peak_bound_ = peak_bound;
        this.param_.setValue("thresholds:peak_bound", peak_bound);
    }

    public double getPeakBoundMs2Level() {
        return this.peak_bound_ms2_level_;
    }

    public void setPeakBoundMs2Level(double peak_bound_ms2_level) {
        this.peak_bound_ms2_level_ = peak_bound_ms2_level;
        this.param_.setValue("thresholds:peak_bound_ms2_level", peak_bound_ms2_level);
    }

    public double getSignalToNoiseLevel() {
        return this.signal_to_noise_;
    }

    public void setSignalToNoiseLevel(double signal_to_noise) {
        this.signal_to_noise_ = signal_to_noise;
        this.param_.setValue("thresholds:signal_to_noise", signal_to_noise);
    }

    public double getFwhmBound() {
        return this.fwhm_bound_;
    }

    public void setFwhmBound(double fwhm) {
        this.fwhm_bound_ = fwhm;
        this.param_.setValue("thresholds:fwhm_bound", fwhm);
    }
}

