/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.extquantfiles.process;

import org.grits.toolbox.entry.ms.extquantfiles.process.CorrectedQuantColumnInfo;
import org.grits.toolbox.ms.om.data.CustomExtraData;

public class ExternalQuantColumnInfo {
    public static String TOTAL_INTENSITY_KEY_POSTFIX = "_quant_total_intensity";
    public static String TOTAL_INTENSITY_LABEL_POSTFIX = " Total Intensity";
    public static String INTENSITY_KEY_POSTFIX = "_quant_intensity";
    public static String INTENSITY_LABEL_POSTFIX = " Intensity";
    public static String MZ_KEY_POSTFIX = "_quant_mz";
    public static String MZ_LABEL_POSTFIX = " m/z";
    public static String CHARGE_KEY_POSTFIX = "_quant_charge";
    public static String CHARGE_LABEL_POSTFIX = " Charge";
    public static String QUANT_PREFIX = "external";

    public static CustomExtraData getDefaultExternalQuantCEDFromKey(String sDefaultKey, String sDefaultLabel, String _sPrevFullKey) {
        int iInx = _sPrevFullKey.indexOf("_quant");
        String sEnding = _sPrevFullKey.substring(iInx);
        if (sEnding.equals(TOTAL_INTENSITY_KEY_POSTFIX)) {
            return ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sDefaultKey, sDefaultLabel);
        }
        if (sEnding.equals(INTENSITY_KEY_POSTFIX)) {
            return ExternalQuantColumnInfo.getExternalQuantIntensity(sDefaultKey, sDefaultLabel);
        }
        if (sEnding.equals(MZ_KEY_POSTFIX)) {
            return ExternalQuantColumnInfo.getExternalQuantIntensityMz(sDefaultKey, sDefaultLabel);
        }
        if (sEnding.equals(CHARGE_KEY_POSTFIX)) {
            return ExternalQuantColumnInfo.getExternalQuantCharge(sDefaultKey, sDefaultLabel);
        }
        return null;
    }

    public static CustomExtraData getExternalQuantDeconvolutedIntensity(String _sKeyPrefix, String _sLabelPrefix) {
        CustomExtraData ced = new CustomExtraData(String.valueOf(_sKeyPrefix) + TOTAL_INTENSITY_KEY_POSTFIX, String.valueOf(_sLabelPrefix) + TOTAL_INTENSITY_LABEL_POSTFIX, "Generic Method", CustomExtraData.Type.Double, "0.0");
        ced.setDoubleFormat("0.0");
        return ced;
    }

    public static CustomExtraData getExternalQuantIntensity(String _sKeyPrefix, String _sLabelPrefix) {
        CustomExtraData ced = new CustomExtraData(String.valueOf(_sKeyPrefix) + INTENSITY_KEY_POSTFIX, String.valueOf(_sLabelPrefix) + INTENSITY_LABEL_POSTFIX, "Generic Method", CustomExtraData.Type.Double, "0.0");
        ced.setDoubleFormat("0.0");
        return ced;
    }

    public static CustomExtraData getExternalQuantCorrectedIntensity(String _sKeyPrefix, String _sLabelPrefix) {
        return CorrectedQuantColumnInfo.getCorrectedQuantIntensity(String.valueOf(_sKeyPrefix) + INTENSITY_KEY_POSTFIX, String.valueOf(_sLabelPrefix) + INTENSITY_LABEL_POSTFIX);
    }

    public static CustomExtraData getExternalQuantIntensityMz(String _sKeyPrefix, String _sLabelPrefix) {
        CustomExtraData ced = new CustomExtraData(String.valueOf(_sKeyPrefix) + MZ_KEY_POSTFIX, String.valueOf(_sLabelPrefix) + MZ_LABEL_POSTFIX, "Generic Method", CustomExtraData.Type.Double, "0.0000");
        ced.setDoubleFormat("0.000");
        return ced;
    }

    public static CustomExtraData getExternalQuantCharge(String _sKeyPrefix, String _sLabelPrefix) {
        return new CustomExtraData(String.valueOf(_sKeyPrefix) + CHARGE_KEY_POSTFIX, String.valueOf(_sLabelPrefix) + CHARGE_LABEL_POSTFIX, "Generic Method", CustomExtraData.Type.Integer);
    }
}

