/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.ms.command.ViewMassSpecOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.content.ScanHierarchyContentProvider;
import org.grits.toolbox.ms.file.scan.data.ScanView;

public class MassSpecScanHierarchyView {
    protected TreeViewer treeViewer;
    protected MassSpecEntityProperty property;
    protected MPart part;
    protected MassSpecMultiPageViewer parentView;
    @Inject
    EPartService partService;
    DecimalFormat df = new DecimalFormat("0.000");
    protected List<ScanView> scanList;

    @Inject
    public MassSpecScanHierarchyView() {
    }

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        this.part = part;
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.treeViewer = tree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ScanHierarchyContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ScanView) {
                    ScanView view = (ScanView)element;
                    if (view.getMsLevel() > 1) {
                        return "Scan " + view.getScanNo() + " - " + MassSpecScanHierarchyView.this.df.format(view.getPreCursorMz());
                    }
                    return "Scan " + view.getScanNo() + " - " + MassSpecScanHierarchyView.this.df.format(view.getRetentionTime() / 60.0) + " min";
                }
                return super.getText(element);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                ScanView selected = (ScanView)selection.getFirstElement();
                MassSpecScanHierarchyView.this.mouseDoubleClick(selected);
            }
        });
    }

    protected Integer getNumberOfAnnotations(ScanView scanView) {
        return null;
    }

    public void mouseDoubleClick(ScanView selected) {
        List<ScanView> path = this.findPath(selected);
        Entry newEntry = this.parentView.getEntry();
        int i = 0;
        for (ScanView scan : path) {
            newEntry = MassSpecEntityProperty.getTableCompatibleEntry(newEntry);
            MassSpecEntityProperty msEntityProp = (MassSpecEntityProperty)newEntry.getProperty();
            Integer iMSLevel = scan.getMsLevel();
            Integer iParentScanNum = scan.getParentScan();
            Integer iScanNum = scan.getScanNo();
            msEntityProp.setParentScanNum(iParentScanNum);
            msEntityProp.setScanNum(iScanNum);
            msEntityProp.setMz(scan.getPreCursorMz());
            msEntityProp.setParentMz(this.property.getMz());
            msEntityProp.setDataFile(this.property.getDataFile());
            msEntityProp.setMsLevel(iMSLevel + 1);
            StringBuilder sb = new StringBuilder(newEntry.getDisplayName());
            if (scan.getPreCursorMz() != null && scan.getPreCursorMz() == 0.0) {
                sb.append(": ");
            } else {
                sb.append("->");
            }
            sb.append("[Scan ");
            sb.append(iScanNum);
            sb.append(", MS");
            sb.append(iMSLevel);
            if (scan.getPreCursorMz() != null && scan.getPreCursorMz() > 0.0) {
                sb.append(", ");
                sb.append(this.df.format(scan.getPreCursorMz()));
            }
            sb.append("]");
            newEntry.setDisplayName(sb.toString());
            if (i == path.size() - 1) {
                this.showMSOverview(newEntry);
            }
            ++i;
        }
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMassSpecOverviewCommandExecutor.showMSOverview(this.parentView.getContext(), newEntry);
    }

    public void setProperty(MassSpecEntityProperty property) {
        this.property = property;
        if (property != null) {
            this.readData();
        }
    }

    protected void readData() {
    }

    public MassSpecEntityProperty getProperty() {
        return this.property;
    }

    @PreDestroy
    public void preDestroy() {
    }

    @Focus
    public void onFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void initializeView(List<ScanView> scans) {
        this.scanList = scans;
        this.treeViewer.setInput(scans);
        this.treeViewer.refresh();
    }

    public void setViewer(MassSpecMultiPageViewer massSpecMultiPageViewer) {
        this.parentView = massSpecMultiPageViewer;
    }

    protected List<ScanView> findPath(ScanView scan) {
        ArrayList<ScanView> path = new ArrayList<ScanView>();
        List allScans = (List)this.treeViewer.getInput();
        for (ScanView s : allScans) {
            if (this.search(s, scan, path)) break;
        }
        return path;
    }

    boolean search(ScanView node, ScanView selected, List<ScanView> track) {
        if (node == null) {
            return false;
        }
        if (node.equals(selected)) {
            track.add(node);
            return true;
        }
        for (ScanView child : node.getSubScans()) {
            if (!this.search(child, selected, track)) continue;
            track.add(0, node);
            return true;
        }
        return false;
    }

    public void expandAll() {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.expandAll();
        }
    }

    public void collapseAll() {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.collapseAll();
        }
    }

    public void filter(boolean filter) {
    }
}

