/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage;

import java.util.ArrayList;
import org.eurocarbdb.applications.ms.glycopeakfinder.calculation.storage.PeakAnnotation;

public class CalculationPeak {
    private double m_dMZ = 0.0;
    private double m_dMinMZ = 0.0;
    private double m_dMaxMZ = 0.0;
    private double m_dIntensity = 0.0;
    private ArrayList<PeakAnnotation> m_aAnnotation = new ArrayList();
    private Integer m_iChargeState = null;
    private int m_iAnnotationCount = 0;

    public CalculationPeak() {
    }

    public CalculationPeak(double d, double d2) {
        this.m_dMZ = d;
        this.m_dIntensity = d2;
    }

    public CalculationPeak(double d, double d2, int n) {
        this.m_dMZ = d;
        this.m_dIntensity = d2;
        this.m_iChargeState = n;
    }

    public void setAnnotationCount(int n) {
        this.m_iAnnotationCount = n;
    }

    public int getAnnotationCount() {
        return this.m_iAnnotationCount;
    }

    public void incrementAnnotationCount() {
        ++this.m_iAnnotationCount;
    }

    public void setMz(double d) {
        this.m_dMZ = d;
    }

    public double getMz() {
        return this.m_dMZ;
    }

    public void setIntensity(double d) {
        this.m_dIntensity = d;
    }

    public double getIntensity() {
        return this.m_dIntensity;
    }

    public void setAnnotation(ArrayList<PeakAnnotation> arrayList) {
        this.m_aAnnotation = arrayList;
    }

    public ArrayList<PeakAnnotation> getAnnotation() {
        return this.m_aAnnotation;
    }

    public double minMz() {
        return this.m_dMinMZ;
    }

    public double maxMz() {
        return this.m_dMaxMZ;
    }

    public void calculateDeviationU(double d) {
        this.m_dMaxMZ = this.m_dMZ + d;
        this.m_dMinMZ = this.m_dMZ - d;
    }

    public void calculateDeviationPpm(double d) {
        double d2 = d * this.m_dMZ / 1000000.0;
        this.m_dMinMZ = this.m_dMZ - d2;
        this.m_dMaxMZ = this.m_dMZ + d2;
    }

    public void addAnnotation(PeakAnnotation peakAnnotation) {
        this.m_aAnnotation.add(peakAnnotation);
    }

    public void setCharge(Integer n) {
        this.m_iChargeState = n;
    }

    public Integer getCharge() {
        return this.m_iChargeState;
    }
}

