/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Anomer {
    Alpha("alpha", "a"),
    Beta("beta", "b"),
    OpenChain("open-chain", "o"),
    Unknown("unknown", "x");

    private String m_strFullname;
    private String m_strSymbol;

    private Anomer(String fullname, String symbol) {
        this.m_strFullname = fullname;
        this.m_strSymbol = symbol;
    }

    public String getName() {
        return this.m_strFullname;
    }

    public String getSymbol() {
        return this.m_strSymbol;
    }

    public static Anomer forName(String anomer) throws GlycoconjugateException {
        for (Anomer a : Anomer.values()) {
            if (!anomer.equals(a.m_strFullname)) continue;
            return a;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }

    public static Anomer forSymbol(char anomer) throws GlycoconjugateException {
        for (Anomer a : Anomer.values()) {
            if (anomer != a.m_strSymbol.charAt(0)) continue;
            return a;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }

    public static Anomer forSymbol(String anomer) throws GlycoconjugateException {
        for (Anomer a : Anomer.values()) {
            if (!a.m_strSymbol.equals(anomer)) continue;
            return a;
        }
        throw new GlycoconjugateException("Invalid value for anomer");
    }
}

