/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.visitor;

import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Monosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharide;
import org.eurocarbdb.MolecularFramework.sugar.Substituent;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverser;
import org.eurocarbdb.MolecularFramework.util.traverser.GlycoTraverserNodes;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitor;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class GlycoVisitorReplaceName
implements GlycoVisitor {
    private String m_strPattern = "";
    private String m_strName = "";

    public GlycoVisitorReplaceName(String a_strPattern, String a_strName) {
        this.m_strPattern = a_strPattern;
        this.m_strName = a_strName;
    }

    public void visit(Monosaccharide arg0) throws GlycoVisitorException {
    }

    public void visit(UnvalidatedGlycoNode a_objNonMonosaccharide) throws GlycoVisitorException {
        String t_strName = a_objNonMonosaccharide.getName();
        int t_iPos = t_strName.indexOf(this.m_strPattern);
        if (t_iPos != -1) {
            String t_strNameOld = t_strName.substring(t_iPos, t_iPos + this.m_strPattern.length());
            try {
                a_objNonMonosaccharide.setName(t_strName.replaceAll(t_strNameOld, this.m_strName));
            }
            catch (GlycoconjugateException e) {
                throw new GlycoVisitorException(e.getMessage(), e);
            }
        }
    }

    public void visit(Sugar a_objSugar) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
    }

    public void visit(GlycoEdge arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitRepeat a_objRepeat) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objRepeat);
        for (UnderdeterminedSubTree t_oSubtree : a_objRepeat.getUndeterminedSubTrees()) {
            t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_oSubtree);
        }
    }

    public void start(Sugar a_objSugar) throws GlycoVisitorException {
        GlycoTraverser t_objTraverser = this.getTraverser(this);
        t_objTraverser.traverseGraph(a_objSugar);
        for (UnderdeterminedSubTree t_oSubtree : a_objSugar.getUndeterminedSubTrees()) {
            t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_oSubtree);
        }
    }

    public GlycoTraverser getTraverser(GlycoVisitor a_objVisitor) throws GlycoVisitorException {
        return new GlycoTraverserNodes(a_objVisitor);
    }

    public void clear() {
    }

    public void visit(NonMonosaccharide arg0) throws GlycoVisitorException {
    }

    public void visit(Substituent arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitCyclic arg0) throws GlycoVisitorException {
    }

    public void visit(SugarUnitAlternative a_objAlternative) throws GlycoVisitorException {
        for (GlycoGraphAlternative t_objGraph : a_objAlternative.getAlternatives()) {
            GlycoTraverser t_objTraverser = this.getTraverser(this);
            t_objTraverser.traverseGraph(t_objGraph);
        }
    }
}

