/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.excel;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.grits.toolbox.tools.databasebot.excel.om.CompositionInformation;
import org.grits.toolbox.tools.databasebot.excel.om.MassInformation;
import org.grits.toolbox.tools.databasebot.om.GlycanInformation;
import org.grits.toolbox.tools.databasebot.utils.ComperatorCompositionInformationMass;
import org.grits.toolbox.tools.databasebot.utils.ComperatorGlycanInformationMass;
import org.grits.toolbox.tools.databasebot.utils.ComperatorMassInformationMass;
import org.grits.toolbox.tools.databasebot.utils.InformationGenerator;
import org.grits.toolbox.utils.image.SimianImageConverter;
import org.grits.toolbox.utils.io.ExcelWriterHelper;

public class ReportGenerator {
    private static double NA_MASS = 22.98977;
    private Double m_imageScalingFactor = 0.5;
    private List<Picture> m_images = new ArrayList<Picture>();
    private GlycanWorkspace m_gwb = new GlycanWorkspace(null, false, (GlycanRenderer)new GlycanRendererAWT());
    private HSSFWorkbook m_workbook = null;
    private Integer m_currentRow = 0;
    private ExcelWriterHelper m_imageWriterHelper = new ExcelWriterHelper();

    private void clear() {
        this.m_images.clear();
        this.m_currentRow = 1;
    }

    public void write(String a_fileName, List<GlycanInformation> a_glycans) throws SugarImporterException, GlycoVisitorException, IOException {
        this.m_workbook = new HSSFWorkbook();
        this.addGlycanList("Structure List", a_glycans, Boolean.TRUE);
        this.resizeImages();
        List<CompositionInformation> t_compositions = this.createCompositionView(a_glycans);
        this.addCompositionList("Composition List", t_compositions);
        List<MassInformation> t_massList = this.findMasses(a_glycans, 100.0);
        this.addMassList("Mass List", t_massList, true, "normalinfo");
        this.resizeImages();
        this.addGlycanList("Filtered out", a_glycans, Boolean.FALSE);
        this.resizeImages();
        FileOutputStream t_fos = new FileOutputStream(a_fileName);
        this.m_workbook.write((OutputStream)t_fos);
        t_fos.flush();
        t_fos.close();
    }

    private void resizeImages() {
        for (Picture t_picture : this.m_images) {
            t_picture.resize();
        }
    }

    public void writeTopology(String a_fileName, List<GlycanInformation> a_glycans, List<GlycanInformation> a_glycansFilterData) throws IOException {
        this.m_workbook = new HSSFWorkbook();
        this.addGlycanList("Structure List", a_glycans, Boolean.TRUE);
        this.resizeImages();
        List<CompositionInformation> t_compositions = this.createCompositionView(a_glycans);
        this.addCompositionList("Composition List", t_compositions);
        List<MassInformation> t_massList = this.findMasses(a_glycans, 100.0);
        this.addMassList("Mass List", t_massList, true, "normalinfo");
        this.resizeImages();
        this.addGlycanList("Filtered out", a_glycansFilterData, Boolean.FALSE);
        this.resizeImages();
        this.addTopologyList("Topology List", a_glycans, "compact");
        this.resizeImages();
        FileOutputStream t_fos = new FileOutputStream(a_fileName);
        this.m_workbook.write((OutputStream)t_fos);
        t_fos.flush();
        t_fos.close();
    }

    private void addTopologyList(String a_name, List<GlycanInformation> a_glycans, String a_displayStyle) {
        this.clear();
        this.m_images = new ArrayList<Picture>();
        HSSFSheet t_sheetStructures = this.m_workbook.createSheet(a_name);
        this.initColumnsMassList(t_sheetStructures);
        Collections.sort(a_glycans, new ComperatorGlycanInformationMass());
        for (GlycanInformation t_info : a_glycans) {
            this.addTopologyRow(t_info, t_sheetStructures, a_displayStyle);
        }
    }

    private void addTopologyRow(GlycanInformation a_info, HSSFSheet a_sheet, String a_displayStyle) {
        HSSFRow t_rowStructure = a_sheet.createRow(this.m_currentRow.intValue());
        Cell t_cell = t_rowStructure.createCell(0);
        t_cell.setCellValue(a_info.getMass().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(1);
        t_cell.setCellValue(a_info.getMassPme().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(2);
        t_cell.setCellValue(a_info.getMassPme() + NA_MASS);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(3);
        t_cell.setCellValue((a_info.getMassPme() + NA_MASS + NA_MASS) / 2.0);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(4);
        t_cell.setCellValue((double)a_info.getTopologyOrigin().size());
        t_cell.setCellType(0);
        int t_column = 5;
        for (GlycanInformation t_glycanInfo : a_info.getTopologyOrigin()) {
            HSSFRow t_rowStructureImage = null;
            try {
                t_rowStructureImage = t_rowStructure;
                BufferedImage img = this.createImage(t_glycanInfo.getGwb(), a_displayStyle);
                this.m_imageWriterHelper.writeCellImage((Workbook)this.m_workbook, (Sheet)a_sheet, this.m_currentRow.intValue(), t_column, img, this.m_images);
            }
            catch (Exception e) {
                t_cell = t_rowStructureImage.createCell(t_column);
                t_cell.setCellValue(e.getMessage());
                t_cell.setCellType(1);
            }
            ++t_column;
        }
        this.m_currentRow = this.m_currentRow + 1;
    }

    private void addMassList(String a_name, List<MassInformation> a_massList, boolean a_withId, String a_displayStyle) {
        this.clear();
        this.m_images = new ArrayList<Picture>();
        HSSFSheet t_sheetStructures = this.m_workbook.createSheet(a_name);
        this.initColumnsMassList(t_sheetStructures);
        Collections.sort(a_massList, new ComperatorMassInformationMass());
        for (MassInformation t_info : a_massList) {
            this.addMassRows(t_info, t_sheetStructures, a_withId, a_displayStyle);
        }
    }

    private void addMassRows(MassInformation a_info, HSSFSheet a_sheet, boolean a_withId, String a_displayStyle) {
        HSSFRow t_rowStructure = a_sheet.createRow(this.m_currentRow.intValue());
        Cell t_cell = t_rowStructure.createCell(0);
        t_cell.setCellValue(a_info.getMass().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(1);
        t_cell.setCellValue(a_info.getMassPme().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(2);
        t_cell.setCellValue(a_info.getMassPme() + NA_MASS);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(3);
        t_cell.setCellValue((a_info.getMassPme() + NA_MASS + NA_MASS) / 2.0);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(4);
        t_cell.setCellValue((double)a_info.getMembers().size());
        t_cell.setCellType(0);
        int t_column = 5;
        for (GlycanInformation t_glycanInfo : a_info.getMembers()) {
            HSSFRow t_rowStructureImage = null;
            try {
                BufferedImage img = this.createImage(t_glycanInfo.getGwb(), a_displayStyle);
                if (a_withId) {
                    t_cell = t_rowStructure.createCell(t_column);
                    t_cell.setCellValue(t_glycanInfo.getId());
                    t_cell.setCellType(1);
                    t_rowStructureImage = a_sheet.createRow(this.m_currentRow + 1);
                    this.m_imageWriterHelper.writeCellImage((Workbook)this.m_workbook, (Sheet)a_sheet, this.m_currentRow + 1, t_column, img, this.m_images);
                } else {
                    t_rowStructureImage = t_rowStructure;
                    this.m_imageWriterHelper.writeCellImage((Workbook)this.m_workbook, (Sheet)a_sheet, this.m_currentRow.intValue(), t_column, img, this.m_images);
                }
            }
            catch (Exception e) {
                t_cell = t_rowStructureImage.createCell(t_column);
                t_cell.setCellValue(e.getMessage());
                t_cell.setCellType(1);
            }
            ++t_column;
        }
        this.m_currentRow = a_withId ? Integer.valueOf(this.m_currentRow + 2) : Integer.valueOf(this.m_currentRow + 1);
    }

    private void initColumnsMassList(HSSFSheet a_sheet) {
        HSSFRow t_row = a_sheet.createRow(0);
        Cell t_cell = t_row.createCell(0);
        t_cell.setCellValue("Native mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(0, 3000);
        t_cell = t_row.createCell(1);
        t_cell.setCellValue("PMe mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(1, 3000);
        t_cell = t_row.createCell(2);
        t_cell.setCellValue("PMe Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(2, 3000);
        t_cell = t_row.createCell(3);
        t_cell.setCellValue("PMe 2Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(3, 3000);
        t_cell = t_row.createCell(4);
        t_cell.setCellValue("# Structures");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(3, 3000);
    }

    private List<MassInformation> findMasses(List<GlycanInformation> a_glycans, Double a_deviationPPM) {
        ArrayList<MassInformation> t_result = new ArrayList<MassInformation>();
        for (GlycanInformation t_glycanInfo : a_glycans) {
            MassInformation t_info;
            if (!t_glycanInfo.getPassFilter().booleanValue() || (t_info = this.assignToMassInfo(t_glycanInfo, t_result, a_deviationPPM)) == null) continue;
            t_result.add(t_info);
        }
        return t_result;
    }

    private MassInformation assignToMassInfo(GlycanInformation a_glycanInfo, List<MassInformation> a_result, Double a_defiationPPM) {
        for (MassInformation t_massInformation : a_result) {
            if (!t_massInformation.isInRange(a_glycanInfo.getMass())) continue;
            t_massInformation.addMember(a_glycanInfo);
            return null;
        }
        MassInformation t_information = new MassInformation(a_glycanInfo.getMass(), a_defiationPPM);
        t_information.setMassPme(a_glycanInfo.getMassPme());
        t_information.addMember(a_glycanInfo);
        return t_information;
    }

    private void addCompositionList(String a_name, List<CompositionInformation> a_compositions) {
        this.clear();
        HSSFSheet t_sheetStructures = this.m_workbook.createSheet(a_name);
        HashMap<String, Integer> t_compositionColumns = this.initColumnsCompositionList(t_sheetStructures, a_compositions);
        Collections.sort(a_compositions, new ComperatorCompositionInformationMass());
        for (CompositionInformation t_info : a_compositions) {
            this.addCompositionRows(t_info, t_sheetStructures, t_compositionColumns);
        }
    }

    private void addCompositionRows(CompositionInformation a_info, HSSFSheet a_sheet, HashMap<String, Integer> a_compositionColumns) {
        HSSFRow t_rowStructure = a_sheet.createRow(this.m_currentRow.intValue());
        Cell t_cell = t_rowStructure.createCell(0);
        t_cell.setCellValue(a_info.getMass().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(1);
        t_cell.setCellValue(a_info.getMassPme().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(2);
        t_cell.setCellValue(a_info.getMassPme() + NA_MASS);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(3);
        t_cell.setCellValue((a_info.getMassPme() + NA_MASS + NA_MASS) / 2.0);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(4);
        t_cell.setCellValue(a_info.getCompositionName());
        t_cell.setCellType(1);
        t_cell = t_rowStructure.createCell(5);
        t_cell.setCellValue((double)a_info.getMembers().size());
        t_cell.setCellType(0);
        HashMap<String, Integer> t_compostionHash = a_info.getComposition();
        for (String t_component : t_compostionHash.keySet()) {
            t_cell = t_rowStructure.createCell(a_compositionColumns.get(t_component).intValue());
            t_cell.setCellValue((double)t_compostionHash.get(t_component).intValue());
            t_cell.setCellType(0);
        }
        this.m_currentRow = this.m_currentRow + 1;
    }

    private HashMap<String, Integer> initColumnsCompositionList(HSSFSheet a_sheet, List<CompositionInformation> a_glycans) {
        HSSFRow t_row = a_sheet.createRow(0);
        Cell t_cell = t_row.createCell(0);
        t_cell.setCellValue("Native mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(0, 3000);
        t_cell = t_row.createCell(1);
        t_cell.setCellValue("PMe mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(1, 3000);
        t_cell = t_row.createCell(2);
        t_cell.setCellValue("PMe Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(2, 3000);
        t_cell = t_row.createCell(3);
        t_cell.setCellValue("PMe 2Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(3, 3000);
        t_cell = t_row.createCell(4);
        t_cell.setCellValue("Composition");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(4, 12000);
        t_cell = t_row.createCell(5);
        t_cell.setCellValue("# Structures");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(5, 3000);
        HashMap<String, Integer> t_compColComposition = this.createCompositionColumnFromComposition(5, a_glycans);
        for (String t_component : t_compColComposition.keySet()) {
            t_cell = t_row.createCell(t_compColComposition.get(t_component).intValue());
            t_cell.setCellValue(InformationGenerator.formatComposition(t_component));
            t_cell.setCellType(1);
        }
        return t_compColComposition;
    }

    private List<CompositionInformation> createCompositionView(List<GlycanInformation> a_glycans) {
        HashMap<String, CompositionInformation> t_compositionView = new HashMap<String, CompositionInformation>();
        for (GlycanInformation t_glycanInformation : a_glycans) {
            if (!t_glycanInformation.getPassFilter().booleanValue()) continue;
            CompositionInformation t_collection = (CompositionInformation)t_compositionView.get(t_glycanInformation.getCompositionName());
            if (t_collection == null) {
                t_collection = new CompositionInformation();
                t_collection.setComposition(t_glycanInformation.getComposition());
                t_collection.setCompositionString(t_glycanInformation.getCompositionName());
                t_collection.setMass(t_glycanInformation.getMass());
                t_collection.setMassPme(t_glycanInformation.getMassPme());
                t_compositionView.put(t_glycanInformation.getCompositionName(), t_collection);
            }
            t_collection.addMember(t_glycanInformation);
        }
        ArrayList<CompositionInformation> t_result = new ArrayList<CompositionInformation>();
        for (String t_composition : t_compositionView.keySet()) {
            t_result.add((CompositionInformation)t_compositionView.get(t_composition));
        }
        return t_result;
    }

    private void addGlycanList(String a_name, List<GlycanInformation> a_glycans, Boolean a_filterSetting) {
        this.clear();
        HSSFSheet t_sheetStructures = this.m_workbook.createSheet(a_name);
        HashMap<String, Integer> t_compositionColumns = this.initColumnsGlycanList(t_sheetStructures, a_glycans);
        Collections.sort(a_glycans, new ComperatorGlycanInformationMass());
        for (GlycanInformation t_info : a_glycans) {
            if (!t_info.getPassFilter().equals(a_filterSetting)) continue;
            this.addGlycanRows(t_info, t_sheetStructures, t_compositionColumns);
        }
    }

    private void addGlycanRows(GlycanInformation a_info, HSSFSheet a_sheet, HashMap<String, Integer> a_compositionColumns) {
        HSSFRow t_rowStructure = a_sheet.createRow(this.m_currentRow.intValue());
        Cell t_cell = t_rowStructure.createCell(0);
        t_cell.setCellValue(a_info.getMass().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(1);
        t_cell.setCellValue(a_info.getMassPme().doubleValue());
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(2);
        t_cell.setCellValue(a_info.getMassPme() + NA_MASS);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(3);
        t_cell.setCellValue((a_info.getMassPme() + NA_MASS + NA_MASS) / 2.0);
        t_cell.setCellType(0);
        t_cell = t_rowStructure.createCell(4);
        t_cell.setCellValue(a_info.getCompositionName());
        t_cell.setCellType(1);
        t_cell = t_rowStructure.createCell(5);
        t_cell.setCellValue(a_info.getId());
        t_cell.setCellType(1);
        try {
            BufferedImage img = this.createImage(a_info.getGwb(), "normalinfo");
            this.m_imageWriterHelper.writeCellImage((Workbook)this.m_workbook, (Sheet)a_sheet, this.m_currentRow.intValue(), 6, img, this.m_images);
        }
        catch (Exception e) {
            t_cell = t_rowStructure.createCell(6);
            t_cell.setCellValue(e.getMessage());
            t_cell.setCellType(1);
        }
        HashMap<String, Integer> t_compostionHash = a_info.getComposition();
        for (String t_component : t_compostionHash.keySet()) {
            t_cell = t_rowStructure.createCell(a_compositionColumns.get(t_component).intValue());
            t_cell.setCellValue((double)t_compostionHash.get(t_component).intValue());
            t_cell.setCellType(0);
        }
        this.m_currentRow = this.m_currentRow + 1;
    }

    private BufferedImage createImage(String a_sequence, String a_displayStyle) throws Exception {
        this.m_gwb.setDisplay(a_displayStyle);
        double dScaleTo = this.m_imageScalingFactor < 1.0 ? 2.0 : this.m_imageScalingFactor;
        double dScaleFrom = this.m_imageScalingFactor < 1.0 ? this.m_imageScalingFactor / 2.0 : this.m_imageScalingFactor;
        BufferedImage img = this.m_gwb.getGlycanRenderer().getImage((Collection)new Union((Object)Glycan.fromString((String)a_sequence)), true, false, false, dScaleTo);
        if (this.m_imageScalingFactor < 1.0) {
            int width = (int)((double)img.getWidth() * dScaleFrom);
            int height = (int)((double)img.getHeight() * dScaleFrom);
            Image newImage = img.getScaledInstance(width, height, 16);
            BufferedImage newBufferedImage = SimianImageConverter.convert((Image)newImage);
            newImage.flush();
            return newBufferedImage;
        }
        return img;
    }

    private HashMap<String, Integer> initColumnsGlycanList(HSSFSheet a_sheet, List<GlycanInformation> a_glycans) {
        HSSFRow t_row = a_sheet.createRow(0);
        Cell t_cell = t_row.createCell(0);
        t_cell.setCellValue("Native mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(0, 3000);
        t_cell = t_row.createCell(1);
        t_cell.setCellValue("PMe mass");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(1, 3000);
        t_cell = t_row.createCell(2);
        t_cell.setCellValue("PMe Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(2, 3000);
        t_cell = t_row.createCell(3);
        t_cell.setCellValue("PMe 2Na+");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(3, 3000);
        t_cell = t_row.createCell(4);
        t_cell.setCellValue("Composition");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(4, 12000);
        t_cell = t_row.createCell(5);
        t_cell.setCellValue("GlycO ID");
        t_cell.setCellType(1);
        a_sheet.setColumnWidth(5, 3000);
        t_cell = t_row.createCell(6);
        t_cell.setCellValue("Cartoon");
        t_cell.setCellType(1);
        HashMap<String, Integer> t_compColComposition = this.createCompositionColumnFromGlycan(6, a_glycans);
        for (String t_component : t_compColComposition.keySet()) {
            t_cell = t_row.createCell(t_compColComposition.get(t_component).intValue());
            t_cell.setCellValue(InformationGenerator.formatComposition(t_component));
            t_cell.setCellType(1);
        }
        return t_compColComposition;
    }

    private HashMap<String, Integer> createCompositionColumnFromGlycan(int a_startPosition, List<GlycanInformation> a_glycans) {
        ArrayList<String> t_components = new ArrayList<String>();
        HashMap<String, Integer> t_result = new HashMap<String, Integer>();
        for (GlycanInformation t_info : a_glycans) {
            HashMap<String, Integer> t_compostion = t_info.getComposition();
            for (String t_comp : t_compostion.keySet()) {
                if (t_result.get(t_comp) != null) continue;
                t_result.put(t_comp, 0);
                t_components.add(t_comp);
            }
        }
        Collections.sort(t_components);
        int t_position = a_startPosition + 1;
        for (String t_string : t_components) {
            t_result.put(t_string, t_position);
            ++t_position;
        }
        return t_result;
    }

    private HashMap<String, Integer> createCompositionColumnFromComposition(int a_startPosition, List<CompositionInformation> a_glycans) {
        ArrayList<String> t_components = new ArrayList<String>();
        HashMap<String, Integer> t_result = new HashMap<String, Integer>();
        for (CompositionInformation t_info : a_glycans) {
            HashMap<String, Integer> t_compostion = t_info.getComposition();
            for (String t_comp : t_compostion.keySet()) {
                if (t_result.get(t_comp) != null) continue;
                t_result.put(t_comp, 0);
                t_components.add(t_comp);
            }
        }
        Collections.sort(t_components);
        int t_position = a_startPosition + 1;
        for (String t_string : t_components) {
            t_result.put(t_string, t_position);
            ++t_position;
        }
        return t_result;
    }

    public Double getImageScalingFactor() {
        return this.m_imageScalingFactor;
    }

    public void setImageScalingFactor(Double a_imageScalingFactor) {
        this.m_imageScalingFactor = a_imageScalingFactor;
    }
}

