/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.Document;
import org.apache.poi.hslf.record.ExControl;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.ExObjRefAtom;
import org.apache.poi.hslf.record.HSLFEscherClientDataRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.StringUtil;

public final class ActiveXShape
extends HSLFPictureShape {
    public static final int DEFAULT_ACTIVEX_THUMBNAIL = -1;

    public ActiveXShape(int movieIdx, HSLFPictureData pictureData) {
        super(pictureData, null);
        this.setActiveXIndex(movieIdx);
    }

    protected ActiveXShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(idx, isChild);
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        spRecord.setFlags(2576);
        this.setShapeType(ShapeType.HOST_CONTROL);
        this.setEscherProperty((short)267, idx);
        this.setEscherProperty((short)448, 0x8000001);
        this.setEscherProperty((short)511, 524296);
        this.setEscherProperty((short)513, 0x8000002);
        this.setEscherProperty((short)127, -1);
        HSLFEscherClientDataRecord cldata = this.getClientData(true);
        cldata.addChild(new ExObjRefAtom());
        return this._escherContainer;
    }

    public void setActiveXIndex(int idx) {
        ExObjRefAtom oe = (ExObjRefAtom)this.getClientDataRecord(RecordTypes.ExObjRefAtom.typeID);
        if (oe == null) {
            throw new HSLFException("OEShapeAtom for ActiveX doesn't exist");
        }
        oe.setExObjIdRef(idx);
    }

    public int getControlIndex() {
        int idx = -1;
        ExObjRefAtom oe = (ExObjRefAtom)this.getClientDataRecord(RecordTypes.ExObjRefAtom.typeID);
        if (oe != null) {
            idx = oe.getExObjIdRef();
        }
        return idx;
    }

    public void setProperty(String key, String value) {
    }

    public ExControl getExControl() {
        int idx = this.getControlIndex();
        ExControl ctrl = null;
        Document doc = this.getSheet().getSlideShow().getDocumentRecord();
        ExObjList lst = (ExObjList)doc.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst != null) {
            Record[] ch = lst.getChildRecords();
            for (int i = 0; i < ch.length; ++i) {
                ExControl c;
                if (!(ch[i] instanceof ExControl) || (c = (ExControl)ch[i]).getExOleObjAtom().getObjID() != idx) continue;
                ctrl = c;
                break;
            }
        }
        return ctrl;
    }

    @Override
    protected void afterInsert(HSLFSheet sheet) {
        ExControl ctrl = this.getExControl();
        ctrl.getExControlAtom().setSlideId(sheet._getSheetNumber());
        String name = ctrl.getProgId() + "-" + this.getControlIndex() + '\u0000';
        byte[] data = StringUtil.getToUnicodeLE((String)name);
        EscherComplexProperty prop = new EscherComplexProperty(896, false, data);
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        opt.addEscherProperty((EscherProperty)prop);
    }
}

