/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog.setTemplate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.setTemplate.AddCategoryEditingSupport;
import org.grits.toolbox.entry.sample.dialog.setTemplate.MaxOccurrenceEditingSupport;
import org.grits.toolbox.entry.sample.dialog.setTemplate.TemplateMembersContenProvider;
import org.grits.toolbox.entry.sample.dialog.setTemplate.TemplateMembersLabelProvider;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.utilities.CategoryComparator;
import org.grits.toolbox.entry.sample.utilities.TemplateLabelProvider;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;
import org.grits.toolbox.entry.sample.utilities.UtilityTemplate;

public class SetTemplateDialog
extends Dialog {
    private Logger logger = Logger.getLogger(SetTemplateDialog.class);
    private Component component = null;
    private Template template = null;
    private ISampleOntologyApi sampleOntologyApi = null;
    private List<Category> categories = null;
    private List<Template> matchingTemplates = null;
    private Set<String> existingNames = null;
    private boolean validLabel = true;
    private TemplateMembersLabelProvider templateLabelProvider = null;
    private HashMap<Integer, String> columnNoCategoryURIMap = null;
    private HashMap<String, HashMap<Integer, Integer>> originalColumnTickedMap = null;
    private HashMap<String, HashMap<Integer, Integer>> objectColumnTickedMap = null;
    private Button setExistingButton = null;
    private ComboViewer comboViewer = null;
    private Button createNewButton = null;
    private Text labelText = null;
    private Text descriptionText = null;
    private TableViewer tableViewer = null;
    private Font boldFont = null;
    private Image errorImage = null;
    private ControlDecoration controlDecoration = null;

    public SetTemplateDialog(Shell parentShell, ISampleOntologyApi sampleOntologyApi, Component component) {
        super(parentShell);
        try {
            this.component = component;
            this.sampleOntologyApi = sampleOntologyApi;
            FontData fontData = Display.getCurrent().getSystemFont().getFontData()[0];
            this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            this.categories = sampleOntologyApi.getAllCategories();
            Collections.sort(this.categories, new CategoryComparator());
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }

    public void create() {
        super.create();
        this.getShell().setImage(ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.CREATE_TEMPLATE_ICON).createImage());
        this.initializeValues();
        this.getButton(0).setEnabled(this.getOkButtonToEnable());
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText("Template");
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout(4, false);
        layout.marginTop = 20;
        layout.marginLeft = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.setExistingButton = new Button(container, 16);
        GridData existingButtonLayoutData = new GridData();
        this.setExistingButton.setText("Set Matching Template");
        this.setExistingButton.setLayoutData((Object)existingButtonLayoutData);
        this.setExistingButton.addSelectionListener(this.getAddSetExistingTemplateListener());
        this.setExistingButton.setSelection(false);
        this.comboViewer = new ComboViewer(container, 12);
        GridData comboViewerLayoutData = new GridData(768);
        comboViewerLayoutData.grabExcessHorizontalSpace = true;
        comboViewerLayoutData.horizontalSpan = 3;
        this.comboViewer.getCombo().setLayoutData((Object)comboViewerLayoutData);
        this.comboViewer.addSelectionChangedListener(this.getSelectTemplateListener());
        this.comboViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.createNewButton = new Button(container, 16);
        this.createNewButton.setText("Create New");
        GridData createNewButtonData = new GridData();
        createNewButtonData.grabExcessHorizontalSpace = true;
        createNewButtonData.horizontalSpan = 4;
        this.createNewButton.setLayoutData((Object)createNewButtonData);
        this.createNewButton.addSelectionListener(this.getCreateNewTemplateListener());
        this.createNewButton.setSelection(false);
        Label labelLabel = new Label(container, 0);
        labelLabel.setText("Label");
        labelLabel.setFont(this.boldFont);
        GridData userNameLabelData = new GridData();
        labelLabel.setLayoutData((Object)userNameLabelData);
        this.labelText = new Text(container, 2052);
        GridData labelTextLayoutData = new GridData(768);
        labelTextLayoutData.grabExcessHorizontalSpace = true;
        labelTextLayoutData.horizontalSpan = 3;
        this.labelText.setLayoutData((Object)labelTextLayoutData);
        this.controlDecoration = new ControlDecoration((Control)this.labelText, 16384);
        this.errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.controlDecoration.setDescriptionText("Invalid Label");
        this.controlDecoration.setImage(this.errorImage);
        this.controlDecoration.setMarginWidth(2);
        this.controlDecoration.hide();
        this.labelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                String textValue = text.getText();
                textValue = textValue.trim();
                SetTemplateDialog.this.controlDecoration.hide();
                if (textValue.isEmpty()) {
                    SetTemplateDialog.this.controlDecoration.setDescriptionText("Label cannot be empty.");
                    SetTemplateDialog.this.controlDecoration.show();
                    SetTemplateDialog.this.validLabel = false;
                } else if (SetTemplateDialog.this.existingNames.contains(textValue) && SetTemplateDialog.this.labelText.getEnabled()) {
                    SetTemplateDialog.this.controlDecoration.setDescriptionText("This Label already exists.");
                    SetTemplateDialog.this.controlDecoration.show();
                    SetTemplateDialog.this.validLabel = false;
                } else {
                    SetTemplateDialog.this.template.setLabel(textValue);
                    SetTemplateDialog.this.validLabel = true;
                }
                SetTemplateDialog.this.getButton(0).setEnabled(SetTemplateDialog.this.getOkButtonToEnable());
            }
        });
        Label genericLabel = new Label(container, 0);
        genericLabel.setText("Description");
        GridData labelData = new GridData();
        labelLabel.setLayoutData((Object)labelData);
        this.descriptionText = new Text(container, 2626);
        GridData descriptionTextLayoutData = new GridData(768);
        descriptionTextLayoutData.horizontalSpan = 3;
        descriptionTextLayoutData.heightHint = 40;
        labelTextLayoutData.grabExcessHorizontalSpace = true;
        this.descriptionText.setLayoutData((Object)descriptionTextLayoutData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                String textValue = text.getText().trim();
                SetTemplateDialog.this.template.setDescription(textValue);
            }
        });
        Table table = new Table(container, 68352);
        TableColumn tableColumn1 = new TableColumn(table, 16384, 0);
        tableColumn1.setText("DescriptorGroup/Descriptor");
        tableColumn1.setWidth(250);
        TableColumn tableColumn2 = new TableColumn(table, 16384, 1);
        tableColumn2.setText("Max. Occurrence");
        tableColumn2.setWidth(130);
        this.tableViewer = new TableViewer(table);
        int i = 2;
        TableColumn tableColumnK = null;
        TableViewerColumn columnViewer = null;
        AddCategoryEditingSupport editingSupport = null;
        HashMap<String, Integer> categoryURIColumnNoMap = new HashMap<String, Integer>();
        this.columnNoCategoryURIMap = new HashMap();
        for (Category category : this.categories) {
            tableColumnK = new TableColumn(table, 0x1000000, i);
            tableColumnK.setText(category.getLabel());
            tableColumnK.setWidth(80);
            tableColumnK.setAlignment(0x1000000);
            columnViewer = new TableViewerColumn(this.tableViewer, tableColumnK);
            editingSupport = new AddCategoryEditingSupport(this.tableViewer, i);
            columnViewer.setEditingSupport((EditingSupport)editingSupport);
            categoryURIColumnNoMap.put(category.getUri(), i);
            this.columnNoCategoryURIMap.put(i, category.getUri());
            ++i;
        }
        columnViewer = new TableViewerColumn(this.tableViewer, tableColumn2);
        columnViewer.setEditingSupport((EditingSupport)new MaxOccurrenceEditingSupport(this.tableViewer));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData tableLayoutData = new GridData();
        tableLayoutData.horizontalSpan = 4;
        tableLayoutData.heightHint = 400;
        table.setLayoutData((Object)tableLayoutData);
        this.tableViewer.setContentProvider((IContentProvider)new TemplateMembersContenProvider());
        this.tableViewer.getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SetTemplateDialog.this.getButton(0).setEnabled(SetTemplateDialog.this.getOkButtonToEnable());
            }

            public void mouseDown(MouseEvent e) {
                SetTemplateDialog.this.getButton(0).setEnabled(SetTemplateDialog.this.getOkButtonToEnable());
            }

            public void mouseDoubleClick(MouseEvent e) {
                SetTemplateDialog.this.getButton(0).setEnabled(SetTemplateDialog.this.getOkButtonToEnable());
            }
        });
        Composite optionComposite = new Composite(container, 0);
        optionComposite.setLayout((Layout)new GridLayout(6, false));
        GridData optionCompositeData = new GridData();
        optionCompositeData.horizontalSpan = 4;
        optionComposite.setLayoutData((Object)optionCompositeData);
        Image image = ImageShare.ADD_ICON.createImage();
        this.createLegendPart(optionComposite, image, "Add to Category   \t");
        image = ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.CHECKBOX_OPTIONAL_TICKED_ICON).createImage();
        this.createLegendPart(optionComposite, image, "Optional in Category   ");
        image = ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.CHECKBOX_TICKED_ICON).createImage();
        this.createLegendPart(optionComposite, image, "Mandatory in Category");
        return container;
    }

    private SelectionListener getCreateNewTemplateListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SetTemplateDialog.this.createNewButton.getSelection()) {
                    SetTemplateDialog.this.template = UtilityTemplate.createTemplateFromComponent(SetTemplateDialog.this.component);
                    SetTemplateDialog.this.labelText.setEnabled(true);
                    SetTemplateDialog.this.descriptionText.setEditable(true);
                    SetTemplateDialog.this.comboViewer.getCombo().setEnabled(false);
                    SetTemplateDialog.this.labelText.setText(SetTemplateDialog.this.template.getLabel());
                    String description = SetTemplateDialog.this.template.getDescription() == null ? "" : SetTemplateDialog.this.template.getDescription();
                    SetTemplateDialog.this.descriptionText.setText(description);
                    SetTemplateDialog.this.initializeTickedMap();
                    SetTemplateDialog.this.saveAsOriginalCopy();
                    SetTemplateDialog.this.templateLabelProvider.setOriginalObjectColumnTickedMap(SetTemplateDialog.this.originalColumnTickedMap);
                    SetTemplateDialog.this.templateLabelProvider.setObjectColumnTickedMap(SetTemplateDialog.this.objectColumnTickedMap);
                    SetTemplateDialog.this.templateLabelProvider.setEditable(true);
                    SetTemplateDialog.this.tableViewer.setInput((Object)SetTemplateDialog.this.template);
                    SetTemplateDialog.this.getButton(0).setText("Create && Set");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private ISelectionChangedListener getSelectTemplateListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int index;
                ComboViewer comboViewer = (ComboViewer)event.getSource();
                Template templateIndiv = (Template)comboViewer.getElementAt(index = Math.min(comboViewer.getCombo().getSelectionIndex(), comboViewer.getCombo().getItemCount()));
                SetTemplateDialog.this.template = templateIndiv.getUri() == null ? null : SetTemplateDialog.this.sampleOntologyApi.getTemplate(templateIndiv.getUri());
                if (SetTemplateDialog.this.template == null) {
                    SetTemplateDialog.this.createNewButton.setSelection(true);
                    SetTemplateDialog.this.setExistingButton.setEnabled(false);
                } else {
                    SetTemplateDialog.this.labelText.setEnabled(false);
                    SetTemplateDialog.this.descriptionText.setEditable(false);
                    SetTemplateDialog.this.labelText.setText(SetTemplateDialog.this.template.getLabel());
                    String description = SetTemplateDialog.this.template.getDescription() == null ? "" : SetTemplateDialog.this.template.getDescription();
                    SetTemplateDialog.this.descriptionText.setText(description);
                    SetTemplateDialog.this.initializeTickedMap();
                    SetTemplateDialog.this.templateLabelProvider.setOriginalObjectColumnTickedMap(SetTemplateDialog.this.originalColumnTickedMap);
                    SetTemplateDialog.this.templateLabelProvider.setObjectColumnTickedMap(SetTemplateDialog.this.objectColumnTickedMap);
                    SetTemplateDialog.this.templateLabelProvider.setEditable(false);
                    SetTemplateDialog.this.tableViewer.setInput((Object)SetTemplateDialog.this.template);
                    SetTemplateDialog.this.getButton(0).setText("Set");
                }
            }
        };
    }

    private SelectionListener getAddSetExistingTemplateListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SetTemplateDialog.this.selectCombo();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SetTemplateDialog.this.selectCombo();
            }
        };
    }

    protected void selectCombo() {
        if (this.setExistingButton.getSelection()) {
            if (this.comboViewer.getCombo().getItems().length > 0) {
                if (this.comboViewer.getCombo().getSelectionIndex() > 0) {
                    this.comboViewer.getCombo().select(this.comboViewer.getCombo().getSelectionIndex());
                } else {
                    int defaultSelectionIndex = 0;
                    if (this.component.getTemplateUri() != null) {
                        List templates = (List)this.comboViewer.getInput();
                        for (Template template : templates) {
                            if (!template.getUri().equals(this.component.getTemplateUri())) continue;
                            defaultSelectionIndex = templates.indexOf(template);
                            break;
                        }
                    }
                    this.comboViewer.getCombo().select(defaultSelectionIndex);
                }
                this.comboViewer.getCombo().setEnabled(true);
                this.comboViewer.setSelection(this.comboViewer.getSelection());
            } else {
                this.setExistingButton.setSelection(false);
                this.setExistingButton.setEnabled(false);
                this.createNewButton.setSelection(true);
                this.createNewButton.notifyListeners(13, new Event());
            }
        }
    }

    protected void initializeValues() {
        try {
            List<Template> templatesInGrits = this.sampleOntologyApi.getAllTemplates();
            Set<String> matchingTemplateUris = UtilityTemplate.getMatchingTemplateUris(this.component, this.sampleOntologyApi.getAllTemplates());
            this.matchingTemplates = new ArrayList<Template>();
            this.existingNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Template template : templatesInGrits) {
                this.existingNames.add(template.getLabel());
                if (!matchingTemplateUris.contains(template.getUri())) continue;
                this.matchingTemplates.add(template);
            }
            this.comboViewer.setInput(this.matchingTemplates);
            this.templateLabelProvider = new TemplateMembersLabelProvider(this.objectColumnTickedMap);
            this.templateLabelProvider.setColumnNoCategoryURIMap(this.columnNoCategoryURIMap);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.templateLabelProvider);
            this.setExistingButton.setEnabled(true);
            this.setExistingButton.setSelection(true);
            this.selectCombo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error((Object)ex);
            this.close();
        }
    }

    private void createLegendPart(Composite optionComposite, Image image, String value) {
        Label label = new Label(optionComposite, 0);
        label.setImage(image);
        GridData layoutData = new GridData(32);
        layoutData.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)layoutData);
        label = new Label(optionComposite, 0);
        label.setText(value);
        layoutData = new GridData(32);
        label.setLayoutData((Object)layoutData);
    }

    private void initializeTickedMap() {
        this.objectColumnTickedMap = new HashMap();
        TemplateMembersContenProvider contentProvider = (TemplateMembersContenProvider)this.tableViewer.getContentProvider();
        HashMap templateCategoryMemberURIValueMap = new HashMap();
        HashMap<Integer, Integer> memberValueMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> newMembershipMap = null;
        List<String> allowedCategories = null;
        String categoryURI = null;
        Category componentCategory = null;
        HashMap memberURIMap = new HashMap();
        HashSet<String> memberURIs = null;
        String eachCategoryURI = null;
        for (Integer column : this.columnNoCategoryURIMap.keySet()) {
            categoryURI = this.columnNoCategoryURIMap.get(column);
            componentCategory = this.getCategory(categoryURI);
            memberURIs = new HashSet<String>();
            memberURIs.addAll(UtilityDescriptorDescriptorGroup.getDescriptorURIs(componentCategory.getDescriptors()));
            memberURIs.addAll(UtilityDescriptorDescriptorGroup.getDescriptorGroupURIs(componentCategory.getDescriptorGroups()));
            memberURIMap.put(column, memberURIs);
            for (String descriptorURI : UtilityDescriptorDescriptorGroup.getDescriptorURIs(componentCategory.getDescriptors())) {
                memberValueMap = new HashMap();
                for (Integer eachColumn : this.columnNoCategoryURIMap.keySet()) {
                    eachCategoryURI = this.columnNoCategoryURIMap.get(eachColumn);
                    memberValueMap.put(eachColumn, this.getMembershipValueFromTemplate(eachCategoryURI, descriptorURI));
                }
                templateCategoryMemberURIValueMap.put(descriptorURI, memberValueMap);
            }
            for (String descriptorGroupURI : UtilityDescriptorDescriptorGroup.getDescriptorGroupURIs(componentCategory.getDescriptorGroups())) {
                memberValueMap = new HashMap();
                for (Integer eachColumn : this.columnNoCategoryURIMap.keySet()) {
                    eachCategoryURI = this.columnNoCategoryURIMap.get(eachColumn);
                    memberValueMap.put(eachColumn, this.getMembershipValueFromTemplate(eachCategoryURI, descriptorGroupURI));
                }
                templateCategoryMemberURIValueMap.put(descriptorGroupURI, memberValueMap);
            }
        }
        Object[] objectArray = contentProvider.getElements(this.template);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String uri = null;
            if (object instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)object;
                uri = descriptor.getUri();
                try {
                    descriptor = this.template.getUri() == null ? this.sampleOntologyApi.getDescriptor(descriptor.getUri()) : descriptor;
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
                allowedCategories = descriptor.getCategories();
            } else if (object instanceof DescriptorGroup) {
                DescriptorGroup descriptorGroup = (DescriptorGroup)object;
                uri = descriptorGroup.getUri();
                try {
                    descriptorGroup = this.template.getUri() == null ? this.sampleOntologyApi.getDescriptorGroup(descriptorGroup.getUri()) : descriptorGroup;
                }
                catch (Exception ex) {
                    this.logger.error((Object)ex);
                }
                allowedCategories = descriptorGroup.getCategories();
            }
            newMembershipMap = new HashMap<Integer, Integer>();
            int value = 0;
            for (Integer column : this.columnNoCategoryURIMap.keySet()) {
                categoryURI = this.columnNoCategoryURIMap.get(column);
                if (this.template.getUri() == null) {
                    value = ((HashSet)memberURIMap.get(column)).contains(uri) ? 2 : -1;
                    value = value == -1 && allowedCategories.contains(categoryURI) ? 1 : value;
                } else {
                    value = templateCategoryMemberURIValueMap.containsKey(uri) ? ((Integer)((HashMap)templateCategoryMemberURIValueMap.get(uri)).get(column)).intValue() : this.getMembershipValueFromTemplate(categoryURI, uri);
                }
                newMembershipMap.put(column, value);
            }
            this.objectColumnTickedMap.put(object.toString(), newMembershipMap);
            ++n2;
        }
    }

    private int getMembershipValueFromTemplate(String categoryURI, String uri) {
        CategoryTemplate categoryTemplate = UtilityTemplate.getCategoryTemplate(this.template, categoryURI);
        HashSet<String> mandatoryURIs = new HashSet<String>();
        mandatoryURIs.addAll(UtilityDescriptorDescriptorGroup.getMandatoryDescriptorURIs(categoryTemplate));
        mandatoryURIs.addAll(UtilityDescriptorDescriptorGroup.getMandatoryDescriptorGroupURIs(categoryTemplate));
        HashSet<String> optionalURIs = new HashSet<String>();
        optionalURIs.addAll(UtilityDescriptorDescriptorGroup.getOptionalDescriptorURIs(categoryTemplate));
        optionalURIs.addAll(UtilityDescriptorDescriptorGroup.getOptionalDescriptorGroupURIs(categoryTemplate));
        int value = -1;
        value = mandatoryURIs.contains(uri) ? 2 : value;
        value = value < 2 && optionalURIs.contains(uri) ? 1 : value;
        return value;
    }

    private void saveAsOriginalCopy() {
        this.originalColumnTickedMap = new HashMap();
        for (String element : this.objectColumnTickedMap.keySet()) {
            HashMap<Integer, Integer> elementMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> map = this.objectColumnTickedMap.get(element);
            for (int column : map.keySet()) {
                elementMap.put(column, map.get(column));
            }
            this.originalColumnTickedMap.put(element, elementMap);
        }
    }

    public Category getCategory(String categoryURI) {
        Category category = null;
        switch (categoryURI) {
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                category = this.component.getSampleInformation();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                category = this.component.getTracking();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                category = this.component.getAmount();
                break;
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                category = this.component.getPurityQC();
            }
        }
        return category;
    }

    protected boolean getOkButtonToEnable() {
        return this.validLabel;
    }

    public Template getTemplate() {
        return this.template;
    }

    protected void okPressed() {
        if (this.createNewButton.getSelection()) {
            this.template = this.getTemplateFromTickedMap();
        }
        super.okPressed();
    }

    private Template getTemplateFromTickedMap() {
        this.objectColumnTickedMap = this.templateLabelProvider.getObjectColumnTickedMap();
        TemplateMembersContenProvider contentProvider = (TemplateMembersContenProvider)this.tableViewer.getContentProvider();
        Template template = new Template();
        template.setLabel(this.labelText.getText());
        String description = this.descriptionText.getText().isEmpty() ? null : this.descriptionText.getText();
        template.setDescription(description);
        HashMap<Integer, Integer> membershipMap = null;
        Object[] objectArray = contentProvider.getElements(this.template);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            membershipMap = this.objectColumnTickedMap.get(object.toString());
            int value = 0;
            for (Integer column : this.columnNoCategoryURIMap.keySet()) {
                value = membershipMap.get(column);
                String categoryURI = this.columnNoCategoryURIMap.get(column);
                CategoryTemplate categoryTemplate = UtilityTemplate.getCategoryTemplate(template, categoryURI);
                if (object instanceof Descriptor) {
                    Descriptor descriptor = (Descriptor)object;
                    switch (value) {
                        case 2: {
                            categoryTemplate.addMandatoryDescriptor(descriptor);
                            break;
                        }
                        case 1: {
                            categoryTemplate.addOptionalDescriptor(descriptor);
                        }
                    }
                }
                if (!(object instanceof DescriptorGroup)) continue;
                DescriptorGroup descriptorGroup = (DescriptorGroup)object;
                switch (value) {
                    case 2: {
                        categoryTemplate.addMandatoryDescriptorGroup(descriptorGroup);
                        break;
                    }
                    case 1: {
                        categoryTemplate.addOptionalDescriptorGroup(descriptorGroup);
                    }
                }
            }
            ++n2;
        }
        return template;
    }
}

