/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.preference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.project.UtilityPreferenceValue;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.preference.SamplePreference;
import org.jdom.Element;

@Singleton
public class SamplePreferenceStore {
    private static final Logger logger = Logger.getLogger(SamplePreferenceStore.class);
    @Inject
    static IGritsPreferenceStore gritsPreferenceStore;
    @Inject
    static ISampleOntologyApi sampleOntologyApi;
    private static Map<Preference, Object> preferenceMap;

    static {
        preferenceMap = new HashMap<Preference, Object>();
    }

    public static int getDefaultNumberOfComponents() {
        logger.info((Object)("Loading preference : " + Preference.NUM_OF_COMPONENTS.preferenceName));
        if (!preferenceMap.containsKey((Object)Preference.NUM_OF_COMPONENTS)) {
            PreferenceEntity preferenceEntity = null;
            try {
                preferenceEntity = gritsPreferenceStore.getPreferenceEntity(Preference.NUM_OF_COMPONENTS.preferenceName);
            }
            catch (UnsupportedVersionException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (preferenceEntity == null) {
                preferenceEntity = new PreferenceEntity(Preference.NUM_OF_COMPONENTS.preferenceName);
                logger.info((Object)("Loading preference with previous name : " + Preference.NUM_OF_COMPONENTS.previousName));
                Element preferenceElement = gritsPreferenceStore.getPreferenceElement(Preference.NUM_OF_COMPONENTS.previousName);
                if (preferenceElement != null) {
                    preferenceEntity.setValue(UtilityPreferenceValue.getPreversioningValue((Element)preferenceElement));
                    logger.info((Object)("Removing preference with previous name : " + Preference.NUM_OF_COMPONENTS.previousName));
                    gritsPreferenceStore.removePreference(Preference.NUM_OF_COMPONENTS.previousName);
                } else {
                    preferenceEntity.setValue("1");
                }
                gritsPreferenceStore.savePreference(preferenceEntity);
            }
            int value = 1;
            try {
                value = Integer.parseInt(preferenceEntity.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)("Error parsing number of components : " + preferenceEntity.getValue()));
                preferenceEntity.setValue(String.valueOf(value));
                gritsPreferenceStore.savePreference(preferenceEntity);
            }
            preferenceMap.put(Preference.NUM_OF_COMPONENTS, value);
        }
        return (Integer)preferenceMap.get((Object)Preference.NUM_OF_COMPONENTS);
    }

    public static String getDefaultTemplateUri() {
        logger.info((Object)("Loading preference : " + Preference.DEFAULT_TEMPLATE.preferenceName));
        if (!preferenceMap.containsKey((Object)Preference.DEFAULT_TEMPLATE)) {
            String templateUri;
            PreferenceEntity preferenceEntity = null;
            try {
                preferenceEntity = gritsPreferenceStore.getPreferenceEntity(Preference.DEFAULT_TEMPLATE.preferenceName);
            }
            catch (UnsupportedVersionException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            if (preferenceEntity == null) {
                preferenceEntity = new PreferenceEntity(Preference.DEFAULT_TEMPLATE.preferenceName);
                logger.info((Object)("Loading preference with previous name : " + Preference.DEFAULT_TEMPLATE.previousName));
                Element preferenceElement = gritsPreferenceStore.getPreferenceElement(Preference.DEFAULT_TEMPLATE.previousName);
                if (preferenceElement != null) {
                    preferenceEntity.setValue(UtilityPreferenceValue.getPreversioningValue((Element)preferenceElement));
                    logger.info((Object)("Removing preference with previous name : " + Preference.DEFAULT_TEMPLATE.previousName));
                    gritsPreferenceStore.removePreference(Preference.DEFAULT_TEMPLATE.previousName);
                }
                gritsPreferenceStore.savePreference(preferenceEntity);
            }
            if (!SamplePreferenceStore.templateExist(templateUri = preferenceEntity.getValue())) {
                logger.error((Object)("Default template uri not found : " + templateUri));
                templateUri = null;
                preferenceEntity.setValue(templateUri);
                gritsPreferenceStore.savePreference(preferenceEntity);
            }
            preferenceMap.put(Preference.DEFAULT_TEMPLATE, templateUri);
        }
        return (String)preferenceMap.get((Object)Preference.DEFAULT_TEMPLATE);
    }

    public static boolean templateExist(String templateUri) {
        boolean templateFound = false;
        if (templateUri != null) {
            for (Template template : sampleOntologyApi.getAllTemplates()) {
                if (!templateUri.equals(template.getUri())) continue;
                templateFound = true;
                break;
            }
        }
        return templateFound;
    }

    public static List<Template> getAllTemplates() {
        logger.info((Object)"Loading all templates from the ontology");
        return sampleOntologyApi.getAllTemplates();
    }

    public static boolean saveNumberOfComponents(int value) {
        logger.info((Object)("Saving component number preference : " + Preference.NUM_OF_COMPONENTS.preferenceName));
        PreferenceEntity preferenceEntity = new PreferenceEntity(Preference.NUM_OF_COMPONENTS.preferenceName);
        preferenceEntity.setValue(String.valueOf(value));
        preferenceMap.put(Preference.NUM_OF_COMPONENTS, value);
        return gritsPreferenceStore.savePreference(preferenceEntity);
    }

    public static boolean saveDefaultTemplate(String templateUri) {
        logger.info((Object)("Saving template preference : " + Preference.DEFAULT_TEMPLATE.preferenceName));
        PreferenceEntity preferenceEntity = new PreferenceEntity(Preference.DEFAULT_TEMPLATE.preferenceName);
        preferenceEntity.setValue(templateUri);
        preferenceMap.put(Preference.DEFAULT_TEMPLATE, templateUri);
        return gritsPreferenceStore.savePreference(preferenceEntity);
    }

    public static enum Preference {
        NUM_OF_COMPONENTS(String.valueOf(SamplePreference.class.getName()) + ".numberOfComponents", "org.grits.toolbox.entry.sample.preference.AnalytePreferenceVariables.numberOfComponents"),
        DEFAULT_TEMPLATE(String.valueOf(SamplePreference.class.getName()) + ".defaultTemplateUri", "org.grits.toolbox.entry.sample.preference.AnalytePreferenceVariables.defaultTemplate");

        private String preferenceName = null;
        private String previousName = null;

        private Preference(String preferenceName, String previousName) {
            this.preferenceName = preferenceName;
            this.previousName = previousName;
        }
    }
}

