/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.analyte.pages;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromComponentListener;
import org.grits.toolbox.entry.sample.dialog.listener.CopyFromTemplateListener;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.ontologymanager.SampleOntologyApi;
import org.grits.toolbox.entry.sample.preference.SamplePreferenceStore;
import org.grits.toolbox.entry.sample.utilities.TemplateLabelProvider;

public class NewAnalytePageTwo
extends WizardPage {
    private static final Logger logger = Logger.getLogger(NewAnalytePageTwo.class);
    private static final String PAGE_NAME = "ComponentPage";
    private Text sampleLabelText;
    public Button radioButton2;
    private CopyFromComponentListener copyFromComponentListener;
    private String textValue = "";
    public Button radioButton3;
    private ComboViewer selectedTemplateCombo;
    private CopyFromTemplateListener copyFromTemplateListener;
    private ISampleOntologyApi sampleOntologyApi;
    private String label;
    private Composite container;
    public int selectedOption;

    public NewAnalytePageTwo() {
        super(PAGE_NAME);
        this.setTitle("Analyte Component");
        this.setDescription("Component in Analyte");
        try {
            this.sampleOntologyApi = new SampleOntologyApi();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 10;
        this.container.setLayout((Layout)layout);
        GridData textDataName = this.getFieldInDialog(this.container, "Component Name");
        this.sampleLabelText = new Text(this.container, 2048);
        this.sampleLabelText.setLayoutData((Object)textDataName);
        this.addDecoratorValidation();
        this.getLabel(this.container, "", 4);
        this.getLabel(this.container, "Create Component : ", 4);
        this.getLabel(this.container, "", 1);
        Button radioButton1 = new Button(this.container, 16);
        radioButton1.setSelection(true);
        radioButton1.setText("New");
        this.getLabel(this.container, "", 2);
        this.getLabel(this.container, "", 1);
        this.radioButton2 = new Button(this.container, 16);
        this.radioButton2.setText("Copy Component");
        this.getLabel(this.container, "     Component    ", 1);
        Text selectedSampleText = new Text(this.container, 128);
        selectedSampleText.setLayoutData((Object)new GridData(768));
        selectedSampleText.setText("");
        selectedSampleText.setEnabled(false);
        try {
            this.copyFromComponentListener = new CopyFromComponentListener(radioButton1, selectedSampleText);
            this.radioButton2.addSelectionListener((SelectionListener)this.copyFromComponentListener);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Compiling Component List", (String)"Component List could not be retrieved");
            this.radioButton2.setEnabled(false);
        }
        this.getLabel(this.container, "", 1);
        this.radioButton3 = new Button(this.container, 16);
        this.radioButton3.setText("Use Template");
        this.getLabel(this.container, "     Template  ", 1);
        this.selectedTemplateCombo = new ComboViewer(this.container, 8);
        this.selectedTemplateCombo.getCombo().setLayoutData((Object)new GridData(768));
        this.selectedTemplateCombo.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.selectedTemplateCombo.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        try {
            ArrayList<Template> templates = new ArrayList<Template>(this.sampleOntologyApi.getAllTemplates());
            this.selectedTemplateCombo.setInput(templates);
            this.copyFromTemplateListener = new CopyFromTemplateListener(this.container, this.selectedTemplateCombo);
            this.radioButton3.addSelectionListener((SelectionListener)this.copyFromTemplateListener);
            String defaultTemplateUri = SamplePreferenceStore.getDefaultTemplateUri();
            if (defaultTemplateUri != null) {
                if (this.loadPreferenceTemplate(templates)) {
                    radioButton1.setSelection(false);
                    this.radioButton3.setSelection(true);
                }
            } else {
                this.selectedTemplateCombo.getCombo().setEnabled(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MessageDialog.openWarning((Shell)parent.getShell(), (String)"Error Compiling Component List", (String)"Component List could not be retrieved");
            this.radioButton3.setEnabled(false);
        }
        this.setControl((Control)this.container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.sampleLabelText.setFocus();
        this.sampleLabelText.selectAll();
    }

    private boolean loadPreferenceTemplate(List<Template> templates) {
        boolean foundAndSelected = false;
        String defaultTemplateUri = SamplePreferenceStore.getDefaultTemplateUri();
        for (Template template : templates) {
            if (!template.getUri().equals(defaultTemplateUri)) continue;
            this.selectedTemplateCombo.getCombo().select(this.selectedTemplateCombo.getCombo().indexOf(template.getLabel()));
            foundAndSelected = true;
            break;
        }
        return foundAndSelected;
    }

    private void getLabel(Composite container, String labelTitle, int horizontalSpan) {
        Label label = new Label(container, 0);
        label.setText(labelTitle);
        GridData gd = new GridData();
        gd.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gd);
    }

    private void addDecoratorValidation() {
        this.label = this.textValue;
        this.sampleLabelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text sampleLabelText = (Text)e.getSource();
                NewAnalytePageTwo.this.textValue = sampleLabelText.getText().trim();
                if (NewAnalytePageTwo.this.textValue.isEmpty()) {
                    NewAnalytePageTwo.this.setPageComplete(false);
                    NewAnalytePageTwo.this.setErrorMessage("\n Please choose a unique name. You cannot leave the field empty. \n Currently the set value is -\t  \"" + NewAnalytePageTwo.this.label + "\" \n");
                } else {
                    NewAnalytePageTwo.this.setPageComplete(true);
                    NewAnalytePageTwo.this.setErrorMessage(null);
                    NewAnalytePageTwo.this.label = NewAnalytePageTwo.this.textValue;
                }
            }
        });
    }

    private GridData getFieldInDialog(Composite container, String labelTitle) {
        this.getLabel(container, labelTitle, 1);
        GridData textDataName = new GridData();
        textDataName.grabExcessHorizontalSpace = true;
        textDataName.horizontalAlignment = 4;
        textDataName.horizontalSpan = 3;
        return textDataName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOldName(String oldName) {
        this.textValue = oldName;
        this.sampleLabelText.setText(this.textValue);
    }

    public Component getSampleToBeCopied() {
        return this.copyFromComponentListener.selectedComponent;
    }

    public Template getSelectedTemplate() {
        return this.copyFromTemplateListener.getSelectedTemplate();
    }

    public String getLabel() {
        return this.sampleLabelText.getText();
    }
}

