/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.internal.Grid;
import org.swtchart.internal.series.Series;
import org.swtchart.internal.series.SeriesSet;

public class PlotArea
extends Composite
implements PaintListener,
IPlotArea {
    protected Chart chart;
    protected SeriesSet seriesSet;
    List<ICustomPaintListener> paintListeners;
    private static final int DEFAULT_BACKGROUND = 1;

    public PlotArea(Chart chart, int style) {
        super((Composite)chart, style | 0x40000 | 0x20000000);
        this.chart = chart;
        this.seriesSet = new SeriesSet(chart);
        this.paintListeners = new ArrayList<ICustomPaintListener>();
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.addPaintListener(this);
    }

    public ISeriesSet getSeriesSet() {
        return this.seriesSet;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        ((SeriesSet)this.getSeriesSet()).compressAllSeries();
    }

    public void setBackground(Color color) {
        if (color == null) {
            super.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public void addCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.add(listener);
    }

    @Override
    public void removeCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.remove(listener);
    }

    public void paintControl(PaintEvent e) {
        Point p = this.getSize();
        GC gc = e.gc;
        Color oldBackground = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, p.x, p.y);
        for (IAxis iAxis : this.chart.getAxisSet().getAxes()) {
            ((Grid)iAxis.getGrid()).draw(gc, p.x, p.y);
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (!listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        for (ISeries iSeries : this.chart.getSeriesSet().getSeries()) {
            if (!(iSeries instanceof IBarSeries)) continue;
            ((Series)iSeries).draw(gc, p.x, p.y);
        }
        for (ISeries iSeries : this.chart.getSeriesSet().getSeries()) {
            if (!(iSeries instanceof ILineSeries)) continue;
            ((Series)iSeries).draw(gc, p.x, p.y);
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        e.gc.setBackground(oldBackground);
    }

    public void dispose() {
        super.dispose();
        this.seriesSet.dispose();
    }
}

