/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.CompleteLinkageStrategy;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.widgets.heatmap.AxisDataSet;
import org.grits.toolbox.widgets.heatmap.GritsPredefinedColorMap;
import org.grits.toolbox.widgets.heatmap.HeatMapData;
import org.grits.toolbox.widgets.heatmap.gui.ColorMapCanvas;
import org.grits.toolbox.widgets.heatmap.gui.GritsAxis;
import org.grits.toolbox.widgets.heatmap.gui.GritsHeatMapFigure;
import org.grits.toolbox.widgets.heatmap.gui.MyListDialog;

public class HeatMapChart
extends Canvas {
    static int count = 0;
    LightweightSystem lws;
    GritsHeatMapFigure heatMap;
    private HeatMapData[][] chartData;
    private HeatMapData[][] ordered;
    private List<String> orderedRowIdentifiers;
    private List<String> orderedColumnIdentifiers;
    private String[] columnIdentifiers;
    private String[] rowIdentifiers;
    private int originaldataWidth;
    private int originaldataHeight;
    int dataWidth;
    int dataHeight;
    Double min = 0.0;
    Double max = 0.0;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> future;
    boolean rowDendrogramVisible = true;
    boolean columnDendrogramVisible = true;
    boolean xAxisVisible = true;
    boolean yAxisVisible = true;
    boolean xAxisOnTop = false;
    boolean yAxisOnRight = true;
    int angle = 0;
    ColorMap colorMap;
    DistanceFormula distanceFormula = DistanceFormula.Spherical;

    public HeatMapChart(Composite parent) {
        super(parent, 0);
        this.init();
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    private void init() {
        this.lws = new LightweightSystem();
        this.lws.setControl((Canvas)this);
        if (this.colorMap == null) {
            this.colorMap = new ColorMap();
            this.colorMap.setColorMap(GritsPredefinedColorMap.BlueRedYelow.getMap());
            this.colorMap.setAutoScale(true);
            this.colorMap.setInterpolate(true);
        }
        MenuManager manager = new MenuManager();
        MenuManager mgr = new MenuManager("Test");
        manager.add((IAction)new Action("Show ColorMap"){

            public void run() {
                Shell shell = new Shell();
                shell.setSize(100, 200);
                ColorMapCanvas colorMap = new ColorMapCanvas((Composite)shell, 0);
                colorMap.initializeRamp(HeatMapChart.this.heatMap.getMin(), HeatMapChart.this.heatMap.getMax(), HeatMapChart.this.heatMap.getColorMap());
                shell.setLayout((Layout)new FillLayout());
                shell.open();
                colorMap.setBounds(shell.getClientArea());
                Display display = Display.getCurrent();
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
        manager.add((IAction)new Action("Show/Hide Row Dendrogram"){

            public void run() {
                HeatMapChart.this.heatMap.getRowDendrogram().setVisible(!HeatMapChart.this.heatMap.getRowDendrogram().isVisible());
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Show/Hide Column Dendrogram"){

            public void run() {
                HeatMapChart.this.heatMap.getColumnDendrogram().setVisible(!HeatMapChart.this.heatMap.getColumnDendrogram().isVisible());
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Show/Hide XAxis"){

            public void run() {
                HeatMapChart.this.heatMap.getXAxis().setVisible(!HeatMapChart.this.heatMap.getXAxis().isVisible());
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Show/Hide YAxis"){

            public void run() {
                HeatMapChart.this.heatMap.getYAxis().setVisible(!HeatMapChart.this.heatMap.getYAxis().isVisible());
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Put XAxis on Top"){

            public void run() {
                HeatMapChart.this.heatMap.getXAxis().setPrimarySide(false);
                HeatMapChart.this.heatMap.setxAxisOnTop(true);
                if (HeatMapChart.this.heatMap.getColumnDendrogram().isVisible()) {
                    HeatMapChart.this.heatMap.getColumnDendrogram().setPrimarySide(false);
                }
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Put XAxis at the Bottom"){

            public void run() {
                HeatMapChart.this.heatMap.getXAxis().setPrimarySide(true);
                HeatMapChart.this.heatMap.setxAxisOnTop(false);
                if (HeatMapChart.this.heatMap.getColumnDendrogram().isVisible()) {
                    HeatMapChart.this.heatMap.getColumnDendrogram().setPrimarySide(true);
                }
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Put XAxis on Top"){

            public void run() {
                HeatMapChart.this.heatMap.getXAxis().setPrimarySide(false);
                HeatMapChart.this.heatMap.setxAxisOnTop(true);
                if (HeatMapChart.this.heatMap.getColumnDendrogram().isVisible()) {
                    HeatMapChart.this.heatMap.getColumnDendrogram().setPrimarySide(false);
                }
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Change XAxis Label Angle"){

            public void run() {
                Dialog tickLabelAngleDialog = new Dialog(Display.getCurrent().getActiveShell()){
                    private ControlDecoration dec2;

                    protected Control createDialogArea(Composite parent) {
                        Composite container = new Composite(parent, 0);
                        GridLayout gridLayout = new GridLayout();
                        gridLayout.numColumns = 2;
                        gridLayout.verticalSpacing = 10;
                        container.setLayout((Layout)gridLayout);
                        Label angleLabel = new Label(container, 16384);
                        angleLabel.setText("Enter an angle");
                        angleLabel.setToolTipText("Angle in which the XAxis labels should be drawn");
                        Text angleText = new Text(container, 2048);
                        angleText.setText("0");
                        angleText.setLayoutData((Object)new GridData(50, angleText.getLineHeight()));
                        (this).HeatMapChart.this.angle = 0;
                        this.dec2 = new ControlDecoration((Control)angleText, 16512);
                        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
                        this.dec2.setImage(image);
                        this.dec2.setDescriptionText("Should enter an integer between [0-90]");
                        this.dec2.hide();
                        angleText.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                Text newText = (Text)e.widget;
                                String newValue = newText.getText();
                                if (newValue != null) {
                                    newValue = newValue.trim();
                                }
                                try {
                                    ((this).this).HeatMapChart.this.angle = Integer.parseInt(newValue);
                                    if (((this).this).HeatMapChart.this.angle < 0 || ((this).this).HeatMapChart.this.angle > 90) {
                                        dec2.show();
                                    } else {
                                        dec2.hide();
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    dec2.show();
                                }
                            }
                        });
                        return container;
                    }
                };
                if (tickLabelAngleDialog.open() == 0) {
                    ((GritsAxis)HeatMapChart.this.heatMap.getXAxis()).getTickLabels().setTickLabelAngle(HeatMapChart.this.angle);
                    HeatMapChart.this.heatMap.repaint();
                }
            }
        });
        manager.add((IAction)new Action("Put YAxis to the Left"){

            public void run() {
                HeatMapChart.this.heatMap.getYAxis().setPrimarySide(true);
                HeatMapChart.this.heatMap.setyAxisOnRight(false);
                if (HeatMapChart.this.heatMap.getRowDendrogram().isVisible()) {
                    HeatMapChart.this.heatMap.getRowDendrogram().setPrimarySide(false);
                }
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Put YAxis to the Right"){

            public void run() {
                HeatMapChart.this.heatMap.getYAxis().setPrimarySide(false);
                HeatMapChart.this.heatMap.setyAxisOnRight(true);
                if (HeatMapChart.this.heatMap.getRowDendrogram().isVisible()) {
                    HeatMapChart.this.heatMap.getRowDendrogram().setPrimarySide(true);
                }
                HeatMapChart.this.heatMap.repaint();
            }
        });
        manager.add((IAction)new Action("Change Color Map"){

            public void run() {
                String newColorMap;
                Object[] selected;
                ArrayList<String> colorMapList = new ArrayList<String>();
                colorMapList.addAll(Arrays.asList(ColorMap.PredefinedColorMap.getStringValues()));
                colorMapList.add(GritsPredefinedColorMap.BlueRedYelow.name());
                MyListDialog dialog = new MyListDialog(Display.getCurrent().getActiveShell());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                dialog.setInput(colorMapList);
                dialog.setMessage("Please select the new color map");
                dialog.setInitialSelections(new Object[]{HeatMapChart.this.heatMap.getColorMap().getPredefinedColorMap().name()});
                if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0 && !(newColorMap = (String)selected[0]).equals(HeatMapChart.this.heatMap.getColorMap().getPredefinedColorMap().name())) {
                    ColorMap.PredefinedColorMap colorMap = this.findColorMap(ColorMap.PredefinedColorMap.values(), newColorMap);
                    if (colorMap != null) {
                        HeatMapChart.this.heatMap.setColorMap(new ColorMap(colorMap, true, true));
                        HeatMapChart.this.heatMap.repaint();
                    } else {
                        GritsPredefinedColorMap colorMap1 = GritsPredefinedColorMap.valueOf(newColorMap);
                        ColorMap newMap = new ColorMap();
                        newMap.setColorMap(colorMap1.getMap());
                        newMap.setAutoScale(true);
                        newMap.setInterpolate(true);
                        HeatMapChart.this.heatMap.setColorMap(newMap);
                        HeatMapChart.this.heatMap.repaint();
                    }
                }
            }

            private ColorMap.PredefinedColorMap findColorMap(ColorMap.PredefinedColorMap[] values, String newColorMap) {
                ColorMap.PredefinedColorMap[] predefinedColorMapArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    ColorMap.PredefinedColorMap predefinedColorMap = predefinedColorMapArray[n2];
                    if (predefinedColorMap.name().equals(newColorMap)) {
                        return predefinedColorMap;
                    }
                    ++n2;
                }
                return null;
            }
        });
        manager.add((IContributionItem)mgr);
        this.setMenu(manager.createContextMenu((Control)this));
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                IContributionItem[] items = menuMgr.getItems();
                int i = 0;
                while (i < items.length) {
                    ((ActionContributionItem)items[i]).update();
                    ++i;
                }
            }
        });
    }

    public GritsHeatMapFigure getHeatMap() {
        return this.heatMap;
    }

    public void initializeChart(HeatMapData[][] chartData, String[] columnIndentifiers, String[] rowIdentifiers) throws Exception {
        if (chartData == null || columnIndentifiers == null || rowIdentifiers == null) {
            return;
        }
        this.chartData = chartData;
        this.columnIdentifiers = columnIndentifiers;
        this.rowIdentifiers = rowIdentifiers;
        this.originaldataWidth = columnIndentifiers.length;
        this.originaldataHeight = rowIdentifiers.length;
        this.dataWidth = this.originaldataWidth;
        this.dataHeight = this.originaldataHeight;
        if (chartData.length != this.originaldataHeight) {
            throw new Exception("data values do not match the number of columns");
        }
        if (chartData[0] == null || chartData[0].length != this.originaldataWidth) {
            throw new Exception("data values do not match the number of rows");
        }
        this.heatMap = new GritsHeatMapFigure(this);
        this.cluster(chartData, columnIndentifiers, rowIdentifiers);
    }

    public void cluster(HeatMapData[][] chartData, String[] columnIndentifiers, String[] rowIdentifiers) {
        double[][] distancesForRows = this.calculateDistancesForRows(chartData);
        double[][] distancesForColumns = this.calculateDistancesForColumns(chartData);
        Cluster rowCluster = this.applyClustering(distancesForRows, rowIdentifiers);
        Cluster columnCluster = this.applyClustering(distancesForColumns, columnIndentifiers);
        this.orderedRowIdentifiers = new ArrayList<String>();
        HeatMapChart.getLeafOrder(rowCluster, this.orderedRowIdentifiers);
        this.orderedColumnIdentifiers = new ArrayList<String>();
        HeatMapChart.getLeafOrder(columnCluster, this.orderedColumnIdentifiers);
        HeatMapData[][] byRow = this.orderChartData(chartData, this.orderedRowIdentifiers, true);
        this.ordered = this.orderChartData(byRow, this.orderedColumnIdentifiers, false);
        Collections.reverse(this.orderedRowIdentifiers);
        this.configureHeatMap(chartData, this.orderedRowIdentifiers, this.orderedColumnIdentifiers, rowCluster, columnCluster);
        this.lws.setContents((IFigure)this.heatMap);
    }

    private HeatMapData[][] orderChartData(HeatMapData[][] chartData, List<String> orderedIdentifiers, boolean byRow) {
        if (chartData.length == 0) {
            return chartData;
        }
        HeatMapData[][] ordered = new HeatMapData[chartData.length][chartData[0].length];
        if (byRow) {
            int i = 0;
            block0: for (String rowId : orderedIdentifiers) {
                HeatMapData[][] heatMapDataArray = chartData;
                int n = chartData.length;
                int n2 = 0;
                while (n2 < n) {
                    HeatMapData[] row = heatMapDataArray[n2];
                    if (row[0].getRowIdentifier().equals(rowId)) {
                        ordered[i++] = row;
                        continue block0;
                    }
                    ++n2;
                }
            }
        } else {
            int i = 0;
            HeatMapData[][] heatMapDataArray = chartData;
            int n = chartData.length;
            int n3 = 0;
            while (n3 < n) {
                HeatMapData[] row = heatMapDataArray[n3];
                HeatMapData[] orderedRow = new HeatMapData[row.length];
                int j = 0;
                block3: for (String columnId : orderedIdentifiers) {
                    HeatMapData[] heatMapDataArray2 = row;
                    int n4 = row.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        HeatMapData cell = heatMapDataArray2[n5];
                        if (cell.getColumnIdentifier().equals(columnId)) {
                            orderedRow[j++] = cell;
                            continue block3;
                        }
                        ++n5;
                    }
                }
                ordered[i++] = orderedRow;
                ++n3;
            }
        }
        return ordered;
    }

    public void configureHeatMap(HeatMapData[][] chartData, List<String> orderedRowIdentifiers, List<String> orderedColumnIdentifiers, Cluster rowCluster, Cluster columnCluster) {
        this.max = HeatMapChart.findMax(chartData);
        this.heatMap.setMax(this.max);
        this.min = HeatMapChart.findMin(chartData);
        this.heatMap.setMin(this.min);
        this.heatMap.setDataHeight(this.dataHeight);
        this.heatMap.setDataWidth(this.dataWidth);
        this.heatMap.getXAxis().setRange(0.0, (double)this.dataWidth);
        this.heatMap.getYAxis().setRange(0.0, (double)this.dataHeight);
        this.heatMap.getXAxis().setVisible(this.xAxisVisible);
        this.heatMap.getYAxis().setVisible(this.yAxisVisible);
        AxisDataSet labelData = new AxisDataSet();
        labelData.setValues(orderedRowIdentifiers);
        ((GritsAxis)this.heatMap.getYAxis()).setLabelData(labelData);
        labelData = new AxisDataSet();
        labelData.setValues(orderedColumnIdentifiers);
        ((GritsAxis)this.heatMap.getXAxis()).setLabelData(labelData);
        if (this.xAxisVisible && this.xAxisOnTop) {
            this.heatMap.getXAxis().setPrimarySide(false);
            this.heatMap.setxAxisOnTop(true);
            if (this.columnDendrogramVisible) {
                this.heatMap.getColumnDendrogram().setPrimarySide(false);
            }
        }
        if (this.yAxisVisible && !this.yAxisOnRight) {
            this.heatMap.setyAxisOnRight(this.yAxisOnRight);
            if (this.rowDendrogramVisible) {
                this.heatMap.getRowDendrogram().setPrimarySide(false);
            }
        }
        if (this.yAxisVisible && this.yAxisOnRight) {
            this.heatMap.getYAxis().setPrimarySide(false);
            this.heatMap.setyAxisOnRight(this.yAxisOnRight);
        }
        this.heatMap.getRowDendrogram().setVisible(this.rowDendrogramVisible);
        this.heatMap.getColumnDendrogram().setVisible(this.columnDendrogramVisible);
        this.heatMap.getRowDendrogram().setModel(rowCluster);
        this.heatMap.getColumnDendrogram().setModel(columnCluster);
        this.heatMap.setColorMap(this.colorMap);
        this.heatMap.addROI("ROI 1", new GritsHeatMapFigure.IROIListener(){

            @Override
            public void roiUpdated(int xIndex, int yIndex, int width, int height) {
                System.out.println("Region of Interest: (" + xIndex + ", " + yIndex + ", " + width + ", " + height + ")");
            }
        }, null);
    }

    private static void getLeafOrder(Cluster cluster, List<String> orderedIdentifiers) {
        if (cluster.isLeaf()) {
            orderedIdentifiers.add(cluster.getName());
        }
        for (Cluster child : cluster.getChildren()) {
            HeatMapChart.getLeafOrder(child, orderedIdentifiers);
        }
    }

    private static double findMin(HeatMapData[][] chartData) {
        double min = 0.0;
        int i = 0;
        while (i < chartData.length) {
            int j = 0;
            while (j < chartData[i].length) {
                if (chartData[i][j].getValue() < min) {
                    min = chartData[i][j].getValue();
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    private static double findMax(HeatMapData[][] chartData) {
        double max = 0.0;
        int i = 0;
        while (i < chartData.length) {
            int j = 0;
            while (j < chartData[i].length) {
                if (chartData[i][j].getValue() > max) {
                    max = chartData[i][j].getValue();
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    Cluster applyClustering(double[][] distances, String[] identifiers) {
        DefaultClusteringAlgorithm alg = new DefaultClusteringAlgorithm();
        Cluster cluster = alg.performClustering(distances, identifiers, (LinkageStrategy)new CompleteLinkageStrategy());
        cluster.toConsole(5);
        return cluster;
    }

    public double[][] calculateDistancesForRows(HeatMapData[][] values) {
        double[][] distancesForRows = new double[values.length][values.length];
        int i = 0;
        while (i < values.length) {
            int j = i;
            while (j < values.length) {
                distancesForRows[i][j] = i == j ? 0.0 : HeatMapChart.calculateDistance(values[i], values[j], this.distanceFormula, HeatMapChart.findMin(values), HeatMapChart.findMax(values));
                ++j;
            }
            ++i;
        }
        return distancesForRows;
    }

    public double[][] calculateDistancesForColumns(HeatMapData[][] values) {
        int j;
        double[][] distancesForColumns = new double[values[0].length][values[0].length];
        HeatMapData[][] columnArray = new HeatMapData[values[0].length][values.length];
        int i = 0;
        while (i < values[0].length) {
            j = 0;
            while (j < values.length) {
                columnArray[i][j] = values[j][i];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < columnArray.length) {
            j = i;
            while (j < columnArray.length) {
                distancesForColumns[i][j] = i == j ? 0.0 : HeatMapChart.calculateDistance(columnArray[i], columnArray[j], this.distanceFormula, HeatMapChart.findMin(values), HeatMapChart.findMax(values));
                ++j;
            }
            ++i;
        }
        return distancesForColumns;
    }

    public static double calculateDistance(HeatMapData[] array1, HeatMapData[] array2, DistanceFormula formula, Double min, Double max) {
        if (array1.length != array2.length) {
            throw new RuntimeException("Size of the data do not match");
        }
        if (formula.equals((Object)DistanceFormula.Spherical)) {
            return HeatMapChart.sphericalDistance(array1, array2, min, max);
        }
        return HeatMapChart.euclideanDistance(array1, array2);
    }

    public static double euclideanDistance(HeatMapData[] array1, HeatMapData[] array2) {
        double Sum = 0.0;
        int i = 0;
        while (i < array1.length) {
            Sum += Math.pow(array1[i].getValue() - array2[i].getValue(), 2.0);
            ++i;
        }
        return Math.sqrt(Sum);
    }

    public static double sphericalDistance(HeatMapData[] array1, HeatMapData[] array2, Double min, Double max) {
        HeatMapData[] normalized1 = HeatMapChart.normalize(array1, min, max);
        HeatMapData[] normalized2 = HeatMapChart.normalize(array2, min, max);
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        int i = 0;
        while (i < normalized1.length) {
            dotProduct += normalized1[i].getValue() * normalized2[i].getValue();
            normA += Math.pow(normalized1[i].getValue(), 2.0);
            normB += Math.pow(normalized2[i].getValue(), 2.0);
            ++i;
        }
        return Math.acos(dotProduct / (Math.sqrt(normA) * Math.sqrt(normB)));
    }

    public static HeatMapData[] normalize(HeatMapData[] array, double min, double max) {
        HeatMapData[] normalized = new HeatMapData[array.length];
        int i = 0;
        HeatMapData[] heatMapDataArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            HeatMapData heatMapData = heatMapDataArray[n2];
            HeatMapData norm = new HeatMapData();
            norm.setColumnIdentifier(heatMapData.getColumnIdentifier());
            norm.setRowIdentifier(heatMapData.getRowIdentifier());
            norm.setValue(heatMapData.getValue() / (max - min));
            normalized[i++] = norm;
            ++n2;
        }
        return normalized;
    }

    public void setDataArray() {
        final double[] simuData = new double[this.dataWidth * this.dataHeight * 2];
        final double[] data = new double[this.dataWidth * this.dataHeight];
        int i = 0;
        while (i < this.dataHeight) {
            int j = 0;
            while (j < this.dataWidth) {
                simuData[i * this.dataWidth + j] = this.ordered[i][j].getValue();
                ++j;
            }
            ++i;
        }
        if (this.future != null && !this.future.isCancelled()) {
            this.future.cancel(true);
        }
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.future = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                System.arraycopy(simuData, count % HeatMapChart.this.dataWidth, data, 0, HeatMapChart.this.dataWidth * HeatMapChart.this.dataHeight);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ++count;
                        (this).HeatMapChart.this.heatMap.setDataArray(simuData);
                    }
                });
            }
        }, 100L, 10L, TimeUnit.MILLISECONDS);
    }

    public void finish() {
        this.future.cancel(true);
        this.scheduler.shutdown();
    }

    public boolean isRowDendrogramVisible() {
        return this.rowDendrogramVisible;
    }

    public void setRowDendrogramVisible(boolean rowDendrogramVisible) {
        this.rowDendrogramVisible = rowDendrogramVisible;
    }

    public boolean isColumnDendrogramVisible() {
        return this.columnDendrogramVisible;
    }

    public void setColumnDendrogramVisible(boolean columnDendrogramVisible) {
        this.columnDendrogramVisible = columnDendrogramVisible;
    }

    public boolean isxAxisVisible() {
        return this.xAxisVisible;
    }

    public void setxAxisVisible(boolean xAxisVisible) {
        this.xAxisVisible = xAxisVisible;
    }

    public boolean isyAxisVisible() {
        return this.yAxisVisible;
    }

    public void setyAxisVisible(boolean yAxisVisible) {
        this.yAxisVisible = yAxisVisible;
    }

    public boolean isxAxisOnTop() {
        return this.xAxisOnTop;
    }

    public void setxAxisOnTop(boolean xAxisOnTop) {
        this.xAxisOnTop = xAxisOnTop;
    }

    public boolean isyAxisOnRight() {
        return this.yAxisOnRight;
    }

    public void setyAxisOnRight(boolean yAxisOnRight) {
        this.yAxisOnRight = yAxisOnRight;
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    public void recalculateClusters(double column1, double column2, double row1, double row2) throws Exception {
        int rIndex1 = (int)Math.floor(row1);
        int rIndex2 = (int)Math.floor(row2);
        int cIndex1 = (int)Math.floor(column1);
        int cIndex2 = (int)Math.floor(column2);
        HeatMapData[][] cropped = new HeatMapData[rIndex1 - rIndex2 + 1][cIndex2 - cIndex1 + 1];
        ArrayList<String> croppedRowIdentifiers = new ArrayList<String>();
        ArrayList<String> croppedColumnIdentifiers = new ArrayList<String>();
        int k = 0;
        int lastIndex = this.ordered.length - 1;
        int i = rIndex1;
        while (i >= rIndex2) {
            if (!croppedRowIdentifiers.contains(this.orderedRowIdentifiers.get(i))) {
                croppedRowIdentifiers.add(this.orderedRowIdentifiers.get(i));
            }
            int m = 0;
            int j = cIndex1;
            while (j <= cIndex2) {
                if (!croppedColumnIdentifiers.contains(this.orderedColumnIdentifiers.get(j))) {
                    croppedColumnIdentifiers.add(this.orderedColumnIdentifiers.get(j));
                }
                cropped[k][m++] = this.ordered[lastIndex - i][j];
                ++j;
            }
            ++k;
            --i;
        }
        this.dataWidth = croppedColumnIdentifiers.size();
        this.dataHeight = croppedRowIdentifiers.size();
        Rectangle originalCrop = this.heatMap.getOriginalCrop();
        Range xAxisRange = this.heatMap.getxAxisRange();
        Range yAxisRange = this.heatMap.getyAxisRange();
        this.heatMap = new GritsHeatMapFigure(this);
        this.heatMap.setOriginalCrop(originalCrop);
        this.heatMap.setxAxisRange(xAxisRange);
        this.heatMap.setyAxisRange(yAxisRange);
        this.cluster(cropped, croppedColumnIdentifiers.toArray(new String[croppedColumnIdentifiers.size()]), croppedRowIdentifiers.toArray(new String[croppedRowIdentifiers.size()]));
    }

    public void recalculateWithOriginalData() {
        this.dataWidth = this.originaldataWidth;
        this.dataHeight = this.originaldataHeight;
        Rectangle originalCrop = this.heatMap.getOriginalCrop();
        Range xAxisRange = this.heatMap.getxAxisRange();
        Range yAxisRange = this.heatMap.getyAxisRange();
        this.heatMap = new GritsHeatMapFigure(this);
        this.heatMap.setOriginalCrop(originalCrop);
        this.heatMap.setxAxisRange(xAxisRange);
        this.heatMap.setyAxisRange(yAxisRange);
        this.cluster(this.chartData, this.columnIdentifiers, this.rowIdentifiers);
    }

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(500, 450);
        shell.setLayout((Layout)new FillLayout());
        shell.open();
        ArrayList<String> rows = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        HeatMapData[][] chartData = HeatMapChart.readCSVFile(rows, columns);
        HeatMapChart chart = new HeatMapChart((Composite)shell);
        chart.setBounds(shell.getClientArea());
        try {
            chart.initializeChart(chartData, columns.toArray(new String[columns.size()]), rows.toArray(new String[rows.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        chart.setDataArray();
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        chart.finish();
    }

    private static HeatMapData[][] readCSVFile(List<String> rowNames, List<String> columnNames) {
        String fileToParse = "/Users/sena/Desktop/heatmap75/tiemeyercluster4b.csv";
        BufferedReader fileReader = null;
        try {
            String line = "";
            fileReader = new BufferedReader(new FileReader(fileToParse));
            ArrayList data = new ArrayList();
            int rowIndex = 0;
            while ((line = fileReader.readLine()) != null) {
                ArrayList<HeatMapData> row = new ArrayList<HeatMapData>();
                String[] tokens = line.split(",");
                if (tokens.length == 0) continue;
                int n = 0;
                String[] stringArray = tokens;
                int n2 = tokens.length;
                int n22 = 0;
                while (n22 < n2) {
                    block12: {
                        block13: {
                            String token;
                            block9: {
                                block10: {
                                    block11: {
                                        token = stringArray[n22];
                                        if (rowIndex != 0 && n != 0) break block9;
                                        if (rowIndex != 0) break block10;
                                        if (n != 0) break block11;
                                        ++n;
                                        break block12;
                                    }
                                    if (!token.isEmpty()) {
                                        columnNames.add(token);
                                    }
                                }
                                if (n == 0 && !token.isEmpty()) {
                                    rowNames.add(token);
                                }
                                break block13;
                            }
                            HeatMapData d = new HeatMapData();
                            d.setValue(Double.parseDouble(token));
                            row.add(d);
                            d.setColumnIdentifier(columnNames.get(n - 1));
                            d.setRowIdentifier(rowNames.get(rowIndex - 1));
                        }
                        ++n;
                    }
                    ++n22;
                }
                if (rowIndex != 0 && row.size() > 0) {
                    data.add(row);
                }
                ++rowIndex;
            }
            HeatMapData[][] chartData = new HeatMapData[data.size()][((List)data.get(0)).size()];
            int i = 0;
            for (List list : data) {
                int j = 0;
                for (HeatMapData heatMapData : list) {
                    chartData[i][j++] = heatMapData;
                }
                ++i;
            }
            fileReader.close();
            return chartData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static enum DistanceFormula {
        Euclidean("Euclidean"),
        Spherical("Spherical");

        String label;

        private DistanceFormula(String label) {
            this.label = label;
        }
    }
}

