/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.grits.toolbox.widgets.heatmap.gui.GritsHeatMapFigure;

public class ROIFigure
extends Figure {
    private static final int HANDLERS_COUNT = 8;
    protected static final int HANDLE_SIZE = 5;
    private static final Rectangle RECT_SINGLETON = new Rectangle();
    private PrecisionRectangle roiGeoBounds;
    private Rectangle roiDataBounds;
    private ResizeHandler[] resizeHandlers;
    private RectangleFigure roiRectFigure;
    private GritsHeatMapFigure.IROIListener roiListener;
    private GritsHeatMapFigure.IROIInfoProvider roiInfoProvider;
    private String name;
    private GritsHeatMapFigure intensityGraphFigure;

    public ROIFigure(GritsHeatMapFigure intensityGraphFigure, String name, Color color, GritsHeatMapFigure.IROIListener roiListener, GritsHeatMapFigure.IROIInfoProvider roiInfoProvider) {
        this.intensityGraphFigure = intensityGraphFigure;
        this.name = name;
        this.roiListener = roiListener;
        this.roiInfoProvider = roiInfoProvider;
        this.setToolTip((IFigure)new Label(name));
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.black);
        this.roiRectFigure = new RectangleFigure(){

            public boolean containsPoint(int x, int y) {
                if (!super.containsPoint(x, y)) {
                    return false;
                }
                return !Rectangle.SINGLETON.setBounds(this.getBounds()).shrink(3, 3).contains(x, y);
            }
        };
        this.roiRectFigure.setCursor(Cursors.SIZEALL);
        this.roiRectFigure.setFill(false);
        this.roiRectFigure.setOutline(true);
        this.roiRectFigure.setForegroundColor(color);
        ROIRectDragger roiRectDragger = new ROIRectDragger();
        this.roiRectFigure.addMouseListener((MouseListener)roiRectDragger);
        this.roiRectFigure.addMouseMotionListener((MouseMotionListener)roiRectDragger);
        this.setFocusTraversable(true);
        this.setRequestFocusEnabled(true);
        this.resizeHandlers = new ResizeHandler[8];
        this.add((IFigure)this.roiRectFigure);
        int i = 0;
        while (i < 8) {
            this.resizeHandlers[i] = new ResizeHandler(i);
            this.add((IFigure)this.resizeHandlers[i]);
            ++i;
        }
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                ResizeHandler[] resizeHandlerArray = ROIFigure.this.resizeHandlers;
                int n = resizeHandlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResizeHandler handler = resizeHandlerArray[n2];
                    handler.setVisible(true);
                    ++n2;
                }
            }

            public void focusLost(FocusEvent fe) {
                ResizeHandler[] resizeHandlerArray = ROIFigure.this.resizeHandlers;
                int n = resizeHandlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResizeHandler handler = resizeHandlerArray[n2];
                    handler.setVisible(false);
                    ++n2;
                }
            }
        });
        intensityGraphFigure.addCroppedDataSizeListener(new GritsHeatMapFigure.ICroppedDataSizeListener(){

            @Override
            public void croppedDataSizeChanged(int croppedDataWidth, int croppedDataHeight) {
                ROIFigure.this.updateROIGeoBounds();
                ROIFigure.this.updateChildrenBounds();
            }
        });
    }

    public boolean containsPoint(int x, int y) {
        x -= this.getBounds().x;
        y -= this.getBounds().y;
        boolean contain = false;
        ResizeHandler[] resizeHandlerArray = this.resizeHandlers;
        int n = this.resizeHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ResizeHandler handler = resizeHandlerArray[n2];
            contain = contain || handler.containsPoint(x, y);
            ++n2;
        }
        return contain || this.roiRectFigure.containsPoint(x, y);
    }

    public String getName() {
        return this.name;
    }

    protected void layout() {
        if (this.roiDataBounds == null) {
            return;
        }
        this.updateROIGeoBounds();
        this.updateChildrenBounds();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.roiInfoProvider != null && this.roiDataBounds != null) {
            String text = this.roiInfoProvider.getROIInfo(this.roiDataBounds.x, this.roiDataBounds.y, this.roiDataBounds.width, this.roiDataBounds.height);
            Dimension size = TextUtilities.INSTANCE.getTextExtents(text, this.getFont());
            graphics.pushState();
            graphics.translate(this.getLocation());
            graphics.fillRectangle(this.roiGeoBounds.x, this.roiGeoBounds.y - size.height, size.width, size.height);
            graphics.drawText(text, this.roiGeoBounds.x, this.roiGeoBounds.y - size.height);
            graphics.popState();
        }
        super.paintFigure(graphics);
    }

    protected void updateChildrenBounds() {
        this.roiRectFigure.setBounds((Rectangle)this.roiGeoBounds);
        ResizeHandler[] resizeHandlerArray = this.resizeHandlers;
        int n = this.resizeHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ResizeHandler handler = resizeHandlerArray[n2];
            handler.setBounds(handler.getHandlerBoundsCalulator().calcBoundsFromROIBounds((Rectangle)this.roiGeoBounds));
            ++n2;
        }
        if (this.roiInfoProvider != null) {
            this.repaint();
        }
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void setROIGeoBounds(int x, int y, int w, int h) {
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        this.roiGeoBounds.setBounds(x, y, w, h);
        this.roiDataBounds = this.getROIFromGeoBounds(new PrecisionRectangle(this.roiGeoBounds.preciseX() + (double)this.getBounds().x, this.roiGeoBounds.preciseY() + (double)this.getBounds().y, this.roiGeoBounds.preciseWidth(), this.roiGeoBounds.preciseHeight()));
        if (this.roiDataBounds.width < 1 || this.roiDataBounds.height < 1) {
            if (this.roiDataBounds.width < 1) {
                this.roiDataBounds.width = 1;
            }
            if (this.roiDataBounds.height < 1) {
                this.roiDataBounds.height = 1;
            }
            this.roiGeoBounds = this.getGeoBoundsFromROI(this.roiDataBounds);
        }
        this.updateChildrenBounds();
    }

    public void setROIDataBounds(int xIndex, int yIndex, int width, int height) {
        RECT_SINGLETON.setBounds(xIndex, yIndex, width, height);
        if (RECT_SINGLETON.equals((Object)this.roiDataBounds)) {
            return;
        }
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.roiDataBounds.setBounds(xIndex, yIndex, width, height);
        this.updateROIGeoBounds();
        this.updateChildrenBounds();
    }

    public void setROIDataBoundsX(int xIndex) {
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.setROIDataBounds(xIndex, this.roiDataBounds.y, this.roiDataBounds.width, this.roiDataBounds.height);
    }

    public void setROIDataBoundsY(int yIndex) {
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.setROIDataBounds(this.roiDataBounds.x, yIndex, this.roiDataBounds.width, this.roiDataBounds.height);
    }

    public void setROIDataBoundsW(int width) {
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.setROIDataBounds(this.roiDataBounds.x, this.roiDataBounds.y, width, this.roiDataBounds.height);
    }

    public void setROIDataBoundsH(int height) {
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.setROIDataBounds(this.roiDataBounds.x, this.roiDataBounds.y, this.roiDataBounds.width, height);
    }

    private void updateROIGeoBounds() {
        if (this.roiDataBounds == null) {
            this.roiDataBounds = new PrecisionRectangle();
        }
        this.roiGeoBounds = this.getGeoBoundsFromROI(this.roiDataBounds);
    }

    public void fireROIUpdated() {
        if (this.roiListener != null) {
            this.roiListener.roiUpdated(this.roiDataBounds.x, this.roiDataBounds.y, this.roiDataBounds.width, this.roiDataBounds.height);
        }
    }

    private Rectangle getROIFromGeoBounds(PrecisionRectangle roiBounds) {
        PrecisionPoint lt = ((GritsHeatMapFigure.GraphArea)this.getParent()).getDataLocation(roiBounds.preciseX(), roiBounds.preciseY());
        PrecisionPoint rb = ((GritsHeatMapFigure.GraphArea)this.getParent()).getDataLocation(roiBounds.preciseX() + roiBounds.preciseWidth(), roiBounds.preciseY() + roiBounds.preciseHeight());
        return new Rectangle((int)Math.round(lt.preciseX()) + this.intensityGraphFigure.getCropLeft(), (int)Math.round(lt.preciseY()) + this.intensityGraphFigure.getCropTop(), (int)Math.ceil(rb.preciseX() - lt.preciseX()), (int)Math.ceil(rb.preciseY() - lt.preciseY()));
    }

    private PrecisionRectangle getGeoBoundsFromROI(Rectangle roiDataBounds) {
        PrecisionPoint lt = ((GritsHeatMapFigure.GraphArea)this.getParent()).getGeoLocation(roiDataBounds.preciseX() - (double)this.intensityGraphFigure.getCropLeft(), roiDataBounds.preciseY() - (double)this.intensityGraphFigure.getCropTop());
        PrecisionPoint rb = ((GritsHeatMapFigure.GraphArea)this.getParent()).getGeoLocation(roiDataBounds.preciseX() + roiDataBounds.preciseWidth() - (double)this.intensityGraphFigure.getCropLeft(), roiDataBounds.preciseY() + roiDataBounds.preciseHeight() - (double)this.intensityGraphFigure.getCropTop());
        return new PrecisionRectangle(lt.preciseX() - (double)this.getBounds().x, lt.preciseY() - (double)this.getBounds().y, rb.preciseX() - lt.preciseX(), rb.preciseY() - lt.preciseY());
    }

    public void setROIColor(Color roiColor) {
        this.roiRectFigure.setForegroundColor(roiColor);
    }

    abstract class CommonDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        protected Point start;
        protected Rectangle startROIBounds;
        protected boolean armed;

        CommonDragger() {
        }

        public void mousePressed(MouseEvent me) {
            this.start = me.getLocation();
            this.startROIBounds = ROIFigure.this.roiGeoBounds.getCopy();
            me.consume();
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseReleased(MouseEvent me) {
            if (this.armed) {
                this.armed = false;
                this.updateROIBounds(me);
                ROIFigure.this.fireROIUpdated();
                me.consume();
            }
        }

        protected abstract void updateROIBounds(MouseEvent var1);

        public void mouseDragged(MouseEvent me) {
            this.armed = true;
            this.updateROIBounds(me);
            me.consume();
        }
    }

    class HandlerBoundsCalulator {
        HandlerBoundsCalulator() {
        }

        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
            return new Rectangle(roiBounds.x - 2, roiBounds.y - 2, 5, 5);
        }
    }

    class ROIRectDragger
    extends CommonDragger {
        ROIRectDragger() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            ROIFigure.this.requestFocus();
            super.mousePressed(me);
        }

        @Override
        protected void updateROIBounds(MouseEvent me) {
            int dx = me.x - this.start.x;
            int dy = me.y - this.start.y;
            RECT_SINGLETON.setBounds(this.startROIBounds.x + dx, this.startROIBounds.y + dy, this.startROIBounds.width, this.startROIBounds.height);
            ROIFigure.this.setROIGeoBounds(RECT_SINGLETON.x, RECT_SINGLETON.y, RECT_SINGLETON.width, RECT_SINGLETON.height);
        }
    }

    class ResizeHandler
    extends RectangleFigure {
        private HandlerBoundsCalulator handlerBoundsCalulator;

        public ResizeHandler(int index) {
            this.setFill(true);
            this.setBackgroundColor(ColorConstants.black);
            this.setOutline(true);
            this.setForegroundColor(ColorConstants.white);
            Cursor cursor = null;
            CommonDragger dragger = null;
            switch (index) {
                case 0: {
                    cursor = Cursors.SIZENW;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(me.x, me.y, this.startROIBounds.width - dx, this.startROIBounds.height - dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator();
                    break;
                }
                case 1: {
                    cursor = Cursors.SIZEN;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x, me.y, this.startROIBounds.width, this.startROIBounds.height - dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(roiBounds.width / 2, 0);
                        }
                    };
                    break;
                }
                case 2: {
                    cursor = Cursors.SIZENE;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x, this.startROIBounds.y + dy, this.startROIBounds.width + dx, this.startROIBounds.height - dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(roiBounds.width, 0);
                        }
                    };
                    break;
                }
                case 3: {
                    cursor = Cursors.SIZEE;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x, this.startROIBounds.y, this.startROIBounds.width + dx, this.startROIBounds.height);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(roiBounds.width, roiBounds.height / 2);
                        }
                    };
                    break;
                }
                case 4: {
                    cursor = Cursors.SIZESE;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x, this.startROIBounds.y, this.startROIBounds.width + dx, this.startROIBounds.height + dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(roiBounds.width, roiBounds.height);
                        }
                    };
                    break;
                }
                case 5: {
                    cursor = Cursors.SIZES;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x, this.startROIBounds.y, this.startROIBounds.width, this.startROIBounds.height + dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(roiBounds.width / 2, roiBounds.height);
                        }
                    };
                    break;
                }
                case 6: {
                    cursor = Cursors.SIZESW;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            int dy = me.y - this.start.y;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x + dx, this.startROIBounds.y, this.startROIBounds.width - dx, this.startROIBounds.height + dy);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(0, roiBounds.height);
                        }
                    };
                    break;
                }
                case 7: {
                    cursor = Cursors.SIZEW;
                    dragger = new CommonDragger(ROIFigure.this){

                        @Override
                        protected void updateROIBounds(MouseEvent me) {
                            int dx = me.x - this.start.x;
                            ROIFigure.this.setROIGeoBounds(this.startROIBounds.x + dx, this.startROIBounds.y, this.startROIBounds.width - dx, this.startROIBounds.height);
                        }
                    };
                    this.handlerBoundsCalulator = new HandlerBoundsCalulator(ROIFigure.this){

                        @Override
                        public Rectangle calcBoundsFromROIBounds(Rectangle roiBounds) {
                            return super.calcBoundsFromROIBounds(roiBounds).translate(0, roiBounds.height / 2);
                        }
                    };
                    break;
                }
            }
            this.setCursor(cursor);
            this.addMouseListener(dragger);
            this.addMouseMotionListener((MouseMotionListener)dragger);
        }

        public HandlerBoundsCalulator getHandlerBoundsCalulator() {
            return this.handlerBoundsCalulator;
        }
    }
}

