/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.tablecore;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.excel.DefaultExportFormatter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class GRITSNatTableStyleConfiguration
extends AbstractRegistryConfiguration {
    public static final Color oddColor = GUIHelper.COLOR_WHITE;
    public static final Color evenColor = GUIHelper.getColor((int)203, (int)203, (int)203);
    public static final Color headerColor = GUIHelper.getColor((int)203, (int)203, (int)203);
    public static final Color fgColor = GUIHelper.COLOR_BLACK;
    public static final Color gradientBgColor = GUIHelper.COLOR_WHITE;
    public static final Color gradientFgColor = GUIHelper.getColor((int)136, (int)212, (int)215);
    public static final Font font = GUIHelper.DEFAULT_FONT;
    public static final HorizontalAlignmentEnum hAlign = HorizontalAlignmentEnum.CENTER;
    public static final VerticalAlignmentEnum vAlign = VerticalAlignmentEnum.MIDDLE;
    public static final BorderStyle borderStyle = new BorderStyle(1, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.SOLID);
    public static final ICellPainter cellPainter = new LineBorderDecorator((ICellPainter)new TextPainter(true, true, 0, true));

    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cellPainter);
        Style cellStyle = GRITSNatTableStyleConfiguration.getNewStyle();
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter());
        configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, (Object)new DefaultExportFormatter());
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", "CORNER");
    }

    public static Style getNewStyle() {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)headerColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)font);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, (Object)hAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, (Object)vAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, (Object)borderStyle);
        return cellStyle;
    }

    protected void configureOddRowStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)oddColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", "EVEN_BODY");
    }

    protected void configureEvenRowStyle(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)evenColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, "NORMAL", "ODD_BODY");
    }
}

