/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddAdductsForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddEditIonDialog;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GridUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;

public class AddIonExchangeForm
extends WizardPage {
    private Method method;
    private Text txtMaxCharge;
    private List<GridItem> adductGridItems = new ArrayList<GridItem>();
    private HashMap<String, Object> adducts = new HashMap();
    private Grid gridAdduct;
    private Button btnDeleteAdduct;
    private Button btnEditAdduct;
    private boolean canFlip = true;
    private boolean bTraversedTo = false;
    private List<Molecule> possibleIons = null;
    private ModifyListener txtMaxChargeModifyListener;
    private static final String ADD_DIALOG_TITLE = "Add/Edit Ion Exchange Dialog";

    public AddIonExchangeForm(Method method) {
        super("wizardPage");
        this.setTitle("Ion Exchange Settings");
        this.setDescription("Add ion exchange settings");
        this.setMethod(method);
    }

    public void updatePossibleIons() {
        this.possibleIons = this.buildAdductList();
    }

    private List<Molecule> buildAdductList() {
        ArrayList<Molecule> possibleIons = new ArrayList<Molecule>();
        int i = 0;
        while (i < this.method.getIons().size()) {
            if (!((IonSettings)this.method.getIons().get(i)).getLabel().equals(GlycanPreDefinedOptions.ION_ADDUCT_HYDROGEN.getLabel()) && !((IonSettings)this.method.getIons().get(i)).getLabel().equals(GlycanPreDefinedOptions.ION_ADDUCT_NEGHYDROGEN.getLabel())) {
                possibleIons.add((Molecule)this.method.getIons().get(i));
            }
            ++i;
        }
        return possibleIons;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblMaxCharge = new Label(container, 0);
        lblMaxCharge.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblMaxCharge.setText("Max Count*");
        this.txtMaxCharge = new Text(container, 2048);
        this.txtMaxChargeModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddIonExchangeForm.this.validateInput()) {
                    ((AddAdductsForm)AddIonExchangeForm.this.getPreviousPage()).setPageComplete(true);
                    AddIonExchangeForm.this.setPageComplete(true);
                } else {
                    AddIonExchangeForm.this.setPageComplete(false);
                }
            }
        };
        this.txtMaxCharge.addModifyListener(this.txtMaxChargeModifyListener);
        this.txtMaxCharge.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAdductSettings = new Label(container, 0);
        lblAdductSettings.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblAdductSettings.setText("Ion Exchange Settings*");
        Button btnAddAdduct = new Button(container, 0);
        btnAddAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddIonExchangeForm.this.possibleIons != null && !AddIonExchangeForm.this.possibleIons.isEmpty()) {
                    GridUtils.addButtonPressed(AddIonExchangeForm.ADD_DIALOG_TITLE, AddIonExchangeForm.this.gridAdduct, AddIonExchangeForm.this.adductGridItems, AddIonExchangeForm.this.adducts, AddIonExchangeForm.this.possibleIons, false, AddEditIonDialog.DialogType.ION_EXCHANGE, AddIonExchangeForm.this.getShell());
                    if (AddIonExchangeForm.this.validateInput()) {
                        ((AddAdductsForm)AddIonExchangeForm.this.getPreviousPage()).setPageComplete(true);
                        AddIonExchangeForm.this.setPageComplete(true);
                    } else {
                        AddIonExchangeForm.this.setPageComplete(false);
                    }
                } else {
                    AddIonExchangeForm.this.setPageComplete(true);
                    AddIonExchangeForm.this.setErrorMessage("No valid adducts appropriate exchange");
                }
            }
        });
        btnAddAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddAdduct.setText(" Add Ion Exchange");
        new Label(container, 0);
        this.btnDeleteAdduct = new Button(container, 0);
        this.btnDeleteAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridUtils.deleteButtonPressed(AddIonExchangeForm.this.gridAdduct, AddIonExchangeForm.this.adductGridItems, AddIonExchangeForm.this.adducts);
                if (AddIonExchangeForm.this.validateInput()) {
                    ((AddAdductsForm)AddIonExchangeForm.this.getPreviousPage()).setPageComplete(true);
                    AddIonExchangeForm.this.setPageComplete(true);
                } else {
                    AddIonExchangeForm.this.setPageComplete(false);
                }
            }
        });
        this.btnDeleteAdduct.setEnabled(false);
        this.btnDeleteAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDeleteAdduct.setText("Delete Ion Exchange");
        new Label(container, 0);
        this.btnEditAdduct = new Button(container, 0);
        this.btnEditAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddIonExchangeForm.this.handleEdit();
            }
        });
        this.btnEditAdduct.setEnabled(false);
        this.btnEditAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditAdduct.setText("Edit Ion Exchange");
        new Label(container, 0);
        this.gridAdduct = new Grid(container, 2048);
        this.gridAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddIonExchangeForm.this.gridAdduct.getSelection().length != 0) {
                    AddIonExchangeForm.this.btnDeleteAdduct.setEnabled(true);
                    AddIonExchangeForm.this.btnEditAdduct.setEnabled(true);
                }
            }
        });
        this.gridAdduct.setHeaderVisible(true);
        GridData gd_gridAdduct = new GridData(4, 4, true, true, 1, 1);
        gd_gridAdduct.heightHint = 20;
        this.gridAdduct.setLayoutData((Object)gd_gridAdduct);
        GridColumn gridColumn = new GridColumn(this.gridAdduct, 0);
        gridColumn.setWidth(150);
        gridColumn.setText("Name");
        GridColumn gridColumn_0 = new GridColumn(this.gridAdduct, 0);
        gridColumn_0.setWidth(50);
        gridColumn_0.setText("Label");
        GridColumn gridColumn_1 = new GridColumn(this.gridAdduct, 0);
        gridColumn_1.setWidth(100);
        gridColumn_1.setText("Polarity");
        GridColumn gridColumn_2 = new GridColumn(this.gridAdduct, 0);
        gridColumn_2.setWidth(50);
        gridColumn_2.setText("Charge");
        GridColumn gridColumn_3 = new GridColumn(this.gridAdduct, 0);
        gridColumn_3.setWidth(100);
        gridColumn_3.setText("Mass");
        GridColumn gridColumn_4 = new GridColumn(this.gridAdduct, 0);
        gridColumn_4.setWidth(100);
        gridColumn_4.setText("Number");
        if (this.gridAdduct.getItemCount() == 0 && this.adducts.keySet().size() == 1) {
            GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)this.adducts.get(GlycanPreDefinedOptions.ION_ADDUCT_SODIUM.getLabel()));
        }
        this.gridAdduct.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                AddIonExchangeForm.this.handleEdit();
            }
        });
        this.setControl((Control)container);
        this.updateControlsFromPreferences();
        if (this.validateInput()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public void handleEdit() {
        if (this.gridAdduct.getSelectionIndices().length == 0) {
            this.setErrorMessage("You must select an ion exchange to edit.");
            return;
        }
        if (this.gridAdduct.getSelectionIndices().length > 1) {
            this.setErrorMessage("You can edit only one ion exchange at a time");
            return;
        }
        IonSettings adduct = new IonSettings();
        adduct = (IonSettings)this.adducts.get(this.gridAdduct.getItem(this.gridAdduct.getSelectionIndex()).getText(1).trim());
        adduct.getName();
        if (adduct != null) {
            if (this.gridAdduct.getSelectionIndices().length > 1) {
                this.setErrorMessage("You can edit only one adduct at a time");
                return;
            }
            if (this.possibleIons != null && !this.possibleIons.isEmpty()) {
                GridUtils.editButtonPressed(ADD_DIALOG_TITLE, this.gridAdduct, this.adductGridItems, this.adducts, this.possibleIons, false, AddEditIonDialog.DialogType.ION_EXCHANGE, this.getShell());
                if (this.validateInput()) {
                    ((AddAdductsForm)this.getPreviousPage()).setPageComplete(true);
                    this.setPageComplete(true);
                } else {
                    this.setPageComplete(false);
                }
            }
        }
    }

    public boolean canFlipToNextPage() {
        return this.canFlip;
    }

    public void setTraversedTo(boolean _bVal) {
        this.bTraversedTo = _bVal;
    }

    public boolean validateInput() {
        if (this.gridAdduct.getSelectionCount() == 0 || this.adducts.isEmpty() && this.btnDeleteAdduct != null) {
            this.btnDeleteAdduct.setEnabled(false);
            this.btnEditAdduct.setEnabled(false);
        }
        if (!this.adducts.isEmpty()) {
            if (TextFieldUtils.isEmpty((Text)this.txtMaxCharge) || !TextFieldUtils.isInteger((Text)this.txtMaxCharge) || !TextFieldUtils.isNonZero((Text)this.txtMaxCharge)) {
                this.setErrorMessage("Please enter a valid number for charge");
                this.canFlip = false;
                return false;
            }
            if (this.adducts.keySet().size() == 0) {
                this.setErrorMessage("Please add a valid adduct");
                this.canFlip = false;
                return false;
            }
        }
        this.save();
        this.canFlip = true;
        this.setErrorMessage(null);
        this.setTraversedTo(false);
        return true;
    }

    public boolean checkAdduct() {
        return this.adductGridItems.size() != 0;
    }

    public void save() {
        if (!this.isPageComplete()) {
            return;
        }
        ArrayList<IonSettings> adductsFinalList = new ArrayList<IonSettings>();
        if (!this.adducts.isEmpty()) {
            for (Object curAdduct : this.adducts.values()) {
                boolean bNotFound = true;
                for (Molecule posAdduct : this.possibleIons) {
                    if (!((IonSettings)curAdduct).getLabel().equals(posAdduct.getLabel())) continue;
                    bNotFound = false;
                    break;
                }
                if (!bNotFound) continue;
                this.setErrorMessage("Exchange ion: " + curAdduct + " not appropriate for current adduct list.");
                this.canFlip = false;
                this.setPageComplete(false);
                ((AddAdductsForm)this.getPreviousPage()).setErrorMessage("Error on Ion Exchange page. Please fix the next page.");
                return;
            }
            for (Object adduct : this.adducts.values()) {
                adductsFinalList.add((IonSettings)adduct);
            }
        } else if (this.bTraversedTo) {
            this.bTraversedTo = false;
        }
        if (!this.txtMaxCharge.getText().isEmpty()) {
            this.method.setMaxIonExchangeCount(Integer.valueOf(Integer.parseInt(this.txtMaxCharge.getText())));
        }
        this.method.setIonExchanges(adductsFinalList);
        this.setErrorMessage(null);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void updateControlsFromPreferences() {
        if (!(this.getWizard() instanceof MSGlycanAnnotationWizard)) {
            return;
        }
        this.removeListeners();
        MSGlycanAnnotationWizard myWizard = (MSGlycanAnnotationWizard)this.getWizard();
        if (myWizard.getPreferences() != null && myWizard.getPreferences().getMethod() != null) {
            Integer ionCount = myWizard.getPreferences().getMethod().getMaxIonExchangeCount();
            if (ionCount != null) {
                this.txtMaxCharge.setText("" + ionCount);
            }
            List ionSettings = myWizard.getPreferences().getMethod().getIonExchanges();
            this.adducts.clear();
            this.gridAdduct.disposeAllItems();
            for (IonSettings adduct : ionSettings) {
                if (GridUtils.getDuplicateAdduct(this.adducts, (Molecule)adduct) != null) continue;
                GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)adduct);
            }
        }
        this.addListeners();
    }

    private void addListeners() {
        this.txtMaxCharge.addModifyListener(this.txtMaxChargeModifyListener);
    }

    private void removeListeners() {
        this.txtMaxCharge.removeModifyListener(this.txtMaxChargeModifyListener);
    }
}

