/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.utilShare.TextFieldUtils;

public class GlycanAdvancedSettings
extends TitleAreaDialog {
    private Text shiftText;
    private Button button;
    private boolean allowInnerFragment = false;
    private double shift = 0.0;
    private Combo innerFragment;

    public GlycanAdvancedSettings(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Advanced Settings");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblNewLabel = new Label(container, 0);
        GridData gd_lblNewLabel = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel.widthHint = 48;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        lblNewLabel.setText("Shift");
        this.shiftText = new Text(container, 2048);
        this.shiftText.setText("0.0");
        this.shiftText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.shiftText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GlycanAdvancedSettings.this.validateInput()) {
                    GlycanAdvancedSettings.this.button.setEnabled(true);
                } else {
                    GlycanAdvancedSettings.this.button.setEnabled(false);
                }
            }
        });
        Label lblInnerFragment = new Label(container, 0);
        lblInnerFragment.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblInnerFragment.setText("Allow Inner Fragment");
        this.innerFragment = new Combo(container, 0);
        this.innerFragment.setItems(new String[]{"True", "False"});
        this.innerFragment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.innerFragment.select(1);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (GlycanAdvancedSettings.this.innerFragment.getItem(GlycanAdvancedSettings.this.innerFragment.getSelectionIndex()).equals("True")) {
                    GlycanAdvancedSettings.this.allowInnerFragment = true;
                }
                GlycanAdvancedSettings.this.shift = Double.parseDouble(GlycanAdvancedSettings.this.shiftText.getText());
            }
        });
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.button.setText("Apply");
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public boolean validateInput() {
        if (TextFieldUtils.isEmpty((Text)this.shiftText) || !TextFieldUtils.isDouble((Text)this.shiftText)) {
            this.setErrorMessage("Enter a valid number in the Accuracy field");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public boolean isAllowInnerFragment() {
        return this.allowInnerFragment;
    }

    public void setAllowInnerFragment(boolean allowInnerFragment) {
        this.allowInnerFragment = allowInnerFragment;
    }
}

