/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.handler;

import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.adaptor.MSAnnotationExportFileAdapter;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationExportDialog;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;

public class MSAnnotationExportCommand {
    private static final Logger logger = Logger.getLogger(MSAnnotationExportCommand.class);
    private Entry entry = null;
    private MSAnnotationTableDataObject tableDataObject = null;
    private int iMasterParentScan = -1;
    private int m_lastVisibleColInx = -1;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, EPartService partService) {
        if (this.initialize(part, partService)) {
            this.createSimianExportDialog(shell);
        } else {
            logger.warn((Object)"A valid MS Annotation entry must be open and active in order to export.");
            ErrorUtils.createWarningMessageBox((Shell)shell, (String)"Invalid Entry", (String)"An appropriate MS Annotation entry must be open and active in order to export.");
        }
    }

    protected MSAnnotationExportFileAdapter getNewExportAdapter() {
        MSAnnotationExportFileAdapter adapter = new MSAnnotationExportFileAdapter();
        return adapter;
    }

    protected boolean initialize(MPart part, EPartService partService) {
        block7: {
            MSAnnotationMultiPageViewer viewer;
            block9: {
                block8: {
                    try {
                        viewer = null;
                        if (part != null && part.getObject() instanceof MSAnnotationMultiPageViewer) {
                            viewer = (MSAnnotationMultiPageViewer)((Object)part.getObject());
                        } else {
                            for (MPart mPart : partService.getParts()) {
                                if (mPart.getObject() instanceof MSAnnotationMultiPageViewer && mPart.equals(mPart.getParent().getSelectedElement()) && !(viewer = (MSAnnotationMultiPageViewer)((Object)mPart.getObject())).getPeaksView().isEmpty()) break;
                            }
                        }
                        if (viewer == null) break block7;
                        if (!viewer.getPeaksView().isEmpty()) break block8;
                        return false;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return false;
                    }
                }
                this.setEntry(viewer.getEntry());
                if (viewer.getPeaksView().get(0) != null && ((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase() != null) break block9;
                return false;
            }
            MSAnnotationTableDataObject tdo = (MSAnnotationTableDataObject)((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase().getNatTable().getGRITSTableDataObject();
            this.setTableDataObject(tdo);
            int iMasterParentScan = ((MSAnnotationTable)((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase().getNatTable()).getScanNumberForVisibility(tdo, -1);
            this.setMasterParentScan(iMasterParentScan);
            TableDataProcessor processor = ((MassSpecPeaksView)viewer.getPeaksView().get(0)).getViewBase().getNatTable().getTableDataProcessor();
            this.setLastVisibleColInx(processor.getLastVisibleCol());
            return true;
        }
        return false;
    }

    protected void createSimianExportDialog(Shell activeShell) {
        MSAnnotationExportFileAdapter adapter = this.getNewExportAdapter();
        MSAnnotationExportDialog dialog = this.getNewExportDialog(activeShell, adapter);
        dialog.setMSAnnotationEntry(this.entry);
        dialog.setTableDataObject(this.getTableDataObject());
        dialog.setMasterParentScan(this.getMasterParentScan());
        dialog.setLastVisibleColInx(this.getLastVisibleColInx());
        dialog.open();
    }

    protected MSAnnotationExportDialog getNewExportDialog(Shell activeShell, MSAnnotationExportFileAdapter adapter) {
        return new MSAnnotationExportDialog(PropertyHandler.getModalDialog((Shell)activeShell), adapter);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public MSAnnotationTableDataObject getTableDataObject() {
        return this.tableDataObject;
    }

    public void setTableDataObject(MSAnnotationTableDataObject tableDataObject) {
        this.tableDataObject = tableDataObject;
    }

    public int getMasterParentScan() {
        return this.iMasterParentScan;
    }

    public void setMasterParentScan(int iMasterParentScan) {
        this.iMasterParentScan = iMasterParentScan;
    }

    public int getLastVisibleColInx() {
        return this.m_lastVisibleColInx;
    }

    public void setLastVisibleColInx(int m_lastVisibleColInx) {
        this.m_lastVisibleColInx = m_lastVisibleColInx;
    }

    @CanExecute
    public boolean isEnabled(@Named(value="e4ActivePart") MPart part, EPartService partService) {
        return this.initialize(part, partService);
    }
}

