/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.tablehelpers;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.grits.toolbox.display.control.table.tablecore.GRITSImagePainter;

public class ExtCheckBoxPainter
extends LineBorderDecorator {
    private final Image checkedImg = GUIHelper.getImage((String)"checked");
    private final Image uncheckedImg = GUIHelper.getImage((String)"unchecked");
    protected boolean bCurStatus = false;
    protected String sText = null;
    protected Image curImage = null;

    public ExtCheckBoxPainter(String sText, boolean _bCurStatus) {
        super((ICellPainter)new GRITSImagePainter());
        this.sText = sText;
        this.setCurStatus(_bCurStatus);
    }

    public void setCurStatus(boolean bCurStatus) {
        this.bCurStatus = bCurStatus;
        this.curImage = bCurStatus ? this.checkedImg : this.uncheckedImg;
    }

    public boolean getCurStatus() {
        return this.bCurStatus;
    }

    public int getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public int getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, bounds, configRegistry);
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Point p = gc.stringExtent(this.sText);
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle((ILayerCell)cell, (IConfigRegistry)configRegistry);
            gc.setFont(GUIHelper.DEFAULT_FONT);
            gc.setForeground(GUIHelper.COLOR_BLACK);
            int xOffset = (bounds.width - (p.x + imageBounds.width)) / 2;
            if (xOffset < 0) {
                xOffset = 0;
            }
            int imageX = bounds.x + xOffset;
            int imageY = bounds.y + CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height);
            gc.drawImage(image, imageX, imageY);
            gc.drawText(this.sText, imageX + imageBounds.width, imageY - CellStyleUtil.getVerticalAlignmentPadding((IStyle)cellStyle, (Rectangle)bounds, (int)imageBounds.height), true);
        }
    }

    public void paintIconImage(GC gc, Rectangle rectangle, int yOffset, boolean checked) {
        Image checkBoxImage = checked ? this.checkedImg : this.uncheckedImg;
        int x = rectangle.x + rectangle.width / 2 - checkBoxImage.getBounds().width / 2;
        gc.drawImage(checkBoxImage, x, rectangle.y + yOffset);
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.curImage;
    }

    public Image getCurCheckboxImage() {
        return this.curImage;
    }

    protected boolean isChecked(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.convertDataType(cell, configRegistry);
    }

    protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getCurStatus();
    }
}

