/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.command.ViewMSOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScanHierarchyView;
import org.grits.toolbox.ms.annotation.utils.AnnotationRowExtraction;
import org.grits.toolbox.ms.file.scan.data.ScanView;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;

public class MSAnnotationScanHierarchyView
extends MassSpecScanHierarchyView {
    static final Logger logger = Logger.getLogger(MSAnnotationScanHierarchyView.class);
    AnnotationReader xmlReader;
    String sSourceFile;
    Data data;
    Method method;

    protected void readData() {
        if (this.property == null) {
            this.data = null;
            return;
        }
        if (this.data == null) {
            this.xmlReader = new AnnotationReader();
            if (this.parentView.getEntry().getProperty() instanceof MSAnnotationEntityProperty) {
                MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)this.parentView.getEntry().getProperty();
                MSAnnotationProperty msAnnotProp = (MSAnnotationProperty)msAnnotEntityProp.getParentProperty();
                this.sSourceFile = msAnnotProp.getFullyQualifiedArchiveFileNameByAnnotationID(this.parentView.getEntry());
                logger.debug((Object)("Reading archive: " + this.sSourceFile));
                this.data = this.xmlReader.readDataWithoutFeatures(this.sSourceFile);
                this.method = this.data.getDataHeader().getMethod();
            }
        }
    }

    protected Integer getNumberOfAnnotations(ScanView scanView) {
        Scan scan;
        Integer numAnnotations = null;
        if (this.data != null && this.data.getScans() != null && !this.data.getScans().isEmpty() && (scan = (Scan)this.data.getScans().get(scanView.getScanNo())) != null) {
            if (scanView.getMsLevel() > 1) {
                ScanFeatures features;
                int parentScan = scan.getParentScan();
                if (scanView.getMsLevel() == 2 && this.method.getMsType().equals("Direct Infusion")) {
                    parentScan = this.data.getFirstMS1Scan();
                }
                if ((features = this.xmlReader.readScanAnnotation(this.sSourceFile, parentScan)) != null) {
                    numAnnotations = this.findNumberOfAnnotations(features, scanView);
                }
            } else {
                numAnnotations = scan.getNumAnnotatedPeaks();
            }
        }
        return numAnnotations;
    }

    private int findNumberOfAnnotations(ScanFeatures features, ScanView scanView) {
        HashMap htPeakToFeatures = null;
        HashMap htParentScanToParentPeaksToSubScan = null;
        htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)features);
        boolean bNeedsConvert = false;
        if (htPeakToFeatures.isEmpty()) {
            htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)features);
            bNeedsConvert = true;
        }
        if (htPeakToFeatures.isEmpty()) {
            return 0;
        }
        htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)this.data);
        if (this.method.getMsType().equals("Direct Infusion") && scanView.getMsLevel() - 1 == 1) {
            AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)this.data);
        }
        for (Peak peak : features.getScanPeaks()) {
            ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)this.data, (Integer)scanView.getParentScan(), (Integer)peak.getId(), (HashMap)htParentScanToParentPeaksToSubScan);
            if (bNeedsConvert) {
                AnnotationRowExtraction.convertPeakIdsToRowIds((Data)this.data, (ScanFeatures)features, (int)scanView.getParentScan(), (Integer)peak.getId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
            }
            for (Scan precursorScan : precursorScans) {
                if (precursorScan == null || !precursorScan.getScanNo().equals(scanView.getScanNo())) continue;
                String sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)(precursorScan != null ? precursorScan.getScanNo() : null));
                int iNumMatch = 0;
                if (htPeakToFeatures.containsKey(sRowId)) {
                    List alFeatures = (List)htPeakToFeatures.get(sRowId);
                    for (Feature feature : alFeatures) {
                        if (((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getAnnotationId() != -1 && !((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getAnnotationId().equals(feature.getAnnotationId())) continue;
                        ++iNumMatch;
                    }
                }
                return iNumMatch;
            }
        }
        return 0;
    }

    public void mouseDoubleClick(ScanView selected) {
        Property parentProperty;
        List path = this.findPath(selected);
        int iAnnotId = -1;
        String annotIdString = null;
        if (this.parentView.getEntry().getProperty() instanceof MSAnnotationEntityProperty && (parentProperty = ((MSAnnotationEntityProperty)this.parentView.getEntry().getProperty()).getParentProperty()) instanceof MSAnnotationProperty && (annotIdString = ((MSAnnotationProperty)parentProperty).getMSAnnotationMetaData().getAnnotationId()) != null && !annotIdString.isEmpty()) {
            iAnnotId = Integer.parseInt(annotIdString);
        }
        Entry annotEntry = MSAnnotationMultiPageViewer.getEntryByAnnotationId(annotIdString);
        this.showMSOverview(annotEntry);
        IEclipseContext parentViewerContext = this.parentView.getContext();
        int i = 0;
        for (ScanView scan : path) {
            MSAnnotationTableDataObject tdo;
            MSAnnotationTable msTable;
            MSAnnotationMultiPageViewer msAnnotView = MSAnnotationMultiPageViewer.getActiveViewer(parentViewerContext);
            if (scan.getMsLevel() > 2) {
                if (msAnnotView.getDetailsView() != null) {
                    msTable = (MSAnnotationTable)msAnnotView.getDetailsView().getViewBase().getNatTable();
                    msAnnotView.setActivePage(msAnnotView.getAnnotDetailsTabIndex());
                    tdo = (MSAnnotationTableDataObject)msTable.getGRITSTableDataObject();
                    iAnnotId = this.findAnnotId(msTable, tdo, scan);
                    if (i < path.size() - 1) {
                        msTable.performDoubleClickOnScan(scan.getScanNo(), 0.0, iAnnotId, null, scan.getMsLevel(), scan.getParentScan());
                    }
                } else if (msAnnotView.getPeaksView() != null && !msAnnotView.getPeaksView().isEmpty()) {
                    msTable = (MSAnnotationTable)((MassSpecPeaksView)msAnnotView.getPeaksView().get(0)).getViewBase().getNatTable();
                    tdo = (MSAnnotationTableDataObject)msTable.getGRITSTableDataObject();
                    iAnnotId = this.findAnnotId(msTable, tdo, scan);
                    if (i < path.size() - 1) {
                        msTable.performDoubleClickOnScan(scan.getScanNo(), 0.0, iAnnotId, null, scan.getMsLevel(), scan.getParentScan());
                    }
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Could not open scan " + scan.getScanNo() + " page"));
                }
            } else if (scan.getMsLevel() > 1) {
                msTable = (MSAnnotationTable)((MassSpecPeaksView)msAnnotView.getPeaksView().get(0)).getViewBase().getNatTable();
                tdo = (MSAnnotationTableDataObject)msTable.getGRITSTableDataObject();
                iAnnotId = this.findAnnotId(msTable, tdo, scan);
                if (i < path.size() - 1) {
                    msTable.performDoubleClickOnScan(scan.getScanNo(), 0.0, iAnnotId, null, scan.getMsLevel(), scan.getParentScan());
                }
            } else {
                msTable = (MSAnnotationTable)msAnnotView.getScansView().getViewBase().getNatTable();
                msTable.performDoubleClickOnScan(scan.getScanNo(), 0.0, -1, null, scan.getMsLevel(), scan.getParentScan());
            }
            ++i;
        }
    }

    protected Integer findAnnotId(MSAnnotationTable msTable, MSAnnotationTableDataObject tdo, ScanView scan) {
        int iAnnotId = -1;
        int i = 0;
        while (i < msTable.getBottomDataLayer().getRowCount()) {
            Object targetScanObj = msTable.getBottomDataLayer().getDataValueByPosition(((Integer)tdo.getScanNoCols().get(0)).intValue(), i);
            if (targetScanObj != null) {
                int iTargetScanNum = -1;
                try {
                    iTargetScanNum = Integer.parseInt(targetScanObj.toString());
                }
                catch (NumberFormatException ex) {
                    logger.debug((Object)ex.getMessage(), (Throwable)ex);
                }
                if (iTargetScanNum == -1) {
                    logger.error((Object)"Unable to find scan number source table. Can't continue.");
                    return -1;
                }
                if (scan.getScanNo() != -1 && iTargetScanNum == scan.getScanNo()) {
                    Object annotObj;
                    if (tdo.getAnnotationIdCols() != null && !tdo.getAnnotationIdCols().isEmpty() && (annotObj = msTable.getBottomDataLayer().getDataValueByPosition(((Integer)tdo.getAnnotationIdCols().get(0)).intValue(), i)) != null) {
                        try {
                            iAnnotId = Integer.parseInt(annotObj.toString());
                        }
                        catch (NumberFormatException ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                            return -1;
                        }
                    }
                    msTable.performMouseDown(i);
                    break;
                }
            }
            ++i;
        }
        return iAnnotId;
    }

    protected void showMSOverview(Entry newEntry) {
        ViewMSOverviewCommandExecutor.showMSOverview(this.parentView.getContext(), newEntry);
    }

    public void initializeView(List<ScanView> scans) {
        super.initializeView(scans);
        List items = this.part.getToolbar().getChildren();
        for (MToolBarElement mToolBarElement : items) {
            if (!(mToolBarElement instanceof MToolItem)) continue;
            ((MToolItem)mToolBarElement).setSelected(false);
        }
    }

    public void filter(boolean filter) {
        if (filter) {
            class FilterProcess
            implements IRunnableWithProgress {
                List<ScanView> filteredScans;

                FilterProcess() {
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int totalWork = 1;
                    if (MSAnnotationScanHierarchyView.this.scanList != null && !MSAnnotationScanHierarchyView.this.scanList.isEmpty()) {
                        totalWork = ((ScanView)MSAnnotationScanHierarchyView.this.scanList.get(MSAnnotationScanHierarchyView.this.scanList.size() - 1)).getScanNo();
                    }
                    monitor.beginTask("Filtering...", totalWork);
                    this.filteredScans = MSAnnotationScanHierarchyView.this.filterScansWithAnnotation(MSAnnotationScanHierarchyView.this.scanList, monitor);
                    monitor.done();
                }

                List<ScanView> getFilteredScans() {
                    return this.filteredScans;
                }
            }
            FilterProcess p = new FilterProcess();
            try {
                new ProgressMonitorDialog(new Shell()).run(true, false, (IRunnableWithProgress)p);
                this.treeViewer.setInput(p.getFilteredScans());
                this.treeViewer.refresh();
            }
            catch (InvocationTargetException e) {
                logger.error((Object)"Error while filtering", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error while filtering", (Throwable)e);
            }
        } else {
            this.treeViewer.setInput((Object)this.scanList);
            this.treeViewer.refresh();
        }
    }

    List<ScanView> filterScansWithAnnotation(List<ScanView> scanList, IProgressMonitor monitor) {
        ArrayList<ScanView> filteredScans = new ArrayList<ScanView>();
        for (ScanView scanView : scanList) {
            Integer annotations = this.getNumberOfAnnotations(scanView);
            if (annotations != null && annotations > 0) {
                ScanView scanViewCopy = new ScanView();
                scanViewCopy.setMsLevel(scanView.getMsLevel());
                scanViewCopy.setParentScan(scanView.getParentScan());
                scanViewCopy.setPreCursorIntensity(scanView.getPreCursorIntensity());
                scanViewCopy.setPreCursorMz(scanView.getPreCursorMz());
                scanViewCopy.setRetentionTime(scanView.getRetentionTime());
                scanViewCopy.setScanNo(scanView.getScanNo());
                if (scanView.getSubScans() != null) {
                    monitor.subTask("Subscans of " + scanView.getScanNo());
                    scanViewCopy.setSubScans(this.filterScansWithAnnotation(scanView.getSubScans(), monitor));
                }
                if (this.method.getMsType().equals("Direct Infusion")) {
                    if (scanViewCopy.getMsLevel() != 1 || !scanViewCopy.getSubScans().isEmpty()) {
                        filteredScans.add(scanViewCopy);
                    }
                } else {
                    filteredScans.add(scanViewCopy);
                }
            }
            monitor.worked(1);
        }
        return filteredScans;
    }
}

