/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.log;

import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.eclipse.core.runtime.Platform;

public class GritsLogAppender {
    public static WriterAppender createAppender() {
        String logFolderPath = GritsLogAppender.getLogFolderPath();
        if (logFolderPath != null) {
            FileAppender gritsAppender = new FileAppender();
            gritsAppender.setName("FileLogger");
            SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd-hh.mm.ss", Locale.ENGLISH);
            gritsAppender.setFile(String.valueOf(logFolderPath) + File.separator + "GRITS-v" + "1.2.3" + "-" + format.format(new Date()) + ".log");
            gritsAppender.setAppend(true);
            return gritsAppender;
        }
        return null;
    }

    public static Priority getDefaultThreshold() {
        return Level.TRACE;
    }

    public static int getGritsLoggingLevel() {
        return 20000;
    }

    public static int getNonGritsLoggingLevel() {
        return 20000;
    }

    private static String getLogFolderPath() {
        String logFolderPath = String.valueOf(Platform.getConfigurationLocation().getURL().getPath()) + "org.grits.toolbox" + File.separator + "log";
        if (GritsLogAppender.isValidFolder(logFolderPath)) {
            return logFolderPath;
        }
        String homeDirectory = System.getProperty("user.home");
        if (homeDirectory != null && homeDirectory.trim().length() > 0 && GritsLogAppender.isValidFolder(logFolderPath = String.valueOf(homeDirectory) + File.separator + ".grits-toolbox" + File.separator + "log")) {
            return logFolderPath;
        }
        return null;
    }

    private static boolean isValidFolder(String logFolderPath) {
        File logFolder;
        block5: {
            logFolder = new File(logFolderPath);
            if (!logFolder.exists()) break block5;
            if (Files.isExecutable(logFolder.toPath()) && Files.isWritable(logFolder.toPath())) {
                return true;
            }
        }
        try {
            if (logFolder.mkdirs()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

