/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@Singleton
public class PreferenceHandler {
    private static final Logger logger = Logger.getLogger(PreferenceHandler.class);
    @Inject
    static IGritsPreferenceStore gritsPreferenceStore;

    public static PreferenceEntity getPreferenceEntity(String preferenceName) throws UnsupportedVersionException {
        return gritsPreferenceStore.getPreferenceEntity(preferenceName);
    }

    public static Element getPreferenceElement(String preferenceName) {
        return gritsPreferenceStore.getPreferenceElement(preferenceName);
    }

    public static boolean savePreference(PreferenceEntity preferenceEntity) {
        return gritsPreferenceStore.savePreference(preferenceEntity);
    }

    public static boolean removePreference(String preferenceName) {
        return gritsPreferenceStore.removePreference(preferenceName);
    }

    public static HashMap<String, Boolean> getPreferenceValues(String fileName, String pluginId) {
        HashMap<String, Boolean> preferenceValues;
        block8: {
            preferenceValues = new HashMap<String, Boolean>();
            try {
                URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)pluginId).getResource("preference"));
                String fileLocation = String.valueOf(resourceURL.getPath()) + File.separator + fileName;
                File preferenceFile = new File(fileLocation);
                if (preferenceFile.exists()) {
                    try {
                        Element defaultPreferences;
                        SAXBuilder builder = new SAXBuilder();
                        Document document = builder.build(preferenceFile);
                        Element element = defaultPreferences = document == null ? null : document.getRootElement();
                        if (defaultPreferences != null) {
                            List children = defaultPreferences.getChildren("preference");
                            String name = null;
                            boolean selected = false;
                            for (Object child : children) {
                                name = ((Element)child).getAttributeValue("name");
                                if (name == null) continue;
                                selected = ((Element)child).getAttributeValue("selected") == null ? false : ((Element)child).getAttributeValue("selected").equals("true");
                                preferenceValues.put(name, selected);
                            }
                        }
                        break block8;
                    }
                    catch (JDOMException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    break block8;
                }
                logger.error((Object)("File not found for default preference : " + fileLocation));
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return preferenceValues;
    }

    public static HashMap<String, Boolean> getPreferenceValues(String fileName) {
        return PreferenceHandler.getPreferenceValues(fileName, "org.grits.toolbox.core");
    }
}

