/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class RolePreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(RolePreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.tasklist.role";
    public static String lastSelection = null;
    private SingleChoicePreference rolePreference = null;
    private List<String> allRoles = null;
    private String defaultRole = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Roles");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createRolesTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newRoleCount = 1;
                while (RolePreference.this.allRoles.contains("Role " + newRoleCount)) {
                    ++newRoleCount;
                }
                String newRole = "Role " + newRoleCount;
                RolePreference.this.allRoles.add(newRole);
                if (RolePreference.this.allRoles.size() == 1) {
                    RolePreference.this.defaultRole = newRole;
                }
                RolePreference.this.checkboxTableViewer.refresh();
                RolePreference.this.tableColumn2.getViewer().editElement((Object)newRole, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)RolePreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedRole = (String)selection.getFirstElement();
                    int selectionIndex = RolePreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    RolePreference.this.allRoles.remove(selectedRole);
                    if (selectedRole.equals(RolePreference.this.defaultRole)) {
                        RolePreference.this.defaultRole = RolePreference.this.allRoles.isEmpty() ? null : (String)RolePreference.this.allRoles.iterator().next();
                    }
                    RolePreference.this.checkboxTableViewer.refresh();
                    if (!RolePreference.this.allRoles.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, RolePreference.this.allRoles.size() - 1);
                        RolePreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(RolePreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)RolePreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(RolePreference.this.defaultRole);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RolePreference.this.defaultRole = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.ROLE.getPreferenceName()));
        this.rolePreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE);
        this.allRoles = new ArrayList<String>();
        this.allRoles.addAll(this.rolePreference.getAllValues());
        this.defaultRole = this.rolePreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allRoles, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allRoles);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createRolesTableViewer(Composite container) {
        Table rolesTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        rolesTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(rolesTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Roles");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (RolePreference.this.checkboxTableViewer.getChecked(element)) {
                        RolePreference.this.defaultRole = newValue;
                    }
                    if (RolePreference.this.allRoles.contains(element)) {
                        RolePreference.this.allRoles.set(RolePreference.this.allRoles.indexOf(element), newValue);
                    }
                    RolePreference.this.checkboxTableViewer.refresh();
                    RolePreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allRolesMap = this.rolePreference.loadDefaultValues(ProjectPreferenceStore.Preference.ROLE);
        this.allRoles = new ArrayList<String>();
        this.defaultRole = null;
        for (String role : allRolesMap.keySet()) {
            this.allRoles.add(role);
            if (!allRolesMap.get(role).booleanValue()) continue;
            this.defaultRole = role;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Role\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniqueRoles = new HashSet<String>();
        uniqueRoles.addAll(this.allRoles);
        String string = errorMessage = uniqueRoles.size() == this.allRoles.size() ? errorMessage : "Non-unique Roles";
        if (uniqueRoles.contains("")) {
            errorMessage = "Empty Role";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.rolePreference.setAllValues(new HashSet<String>());
        this.rolePreference.setDefaultValue(null);
        for (String role : this.allRoles) {
            if (this.checkboxTableViewer.getChecked(role) && this.rolePreference.getDefaultValue() == null) {
                this.rolePreference.setDefaultValue(role);
            }
            this.rolePreference.addValue(role);
        }
        return this.rolePreference.savePreference();
    }
}

