/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.workspace;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.workspace.WorkspaceHistory;
import org.grits.toolbox.core.workspace.WorkspaceHistoryEntry;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class WorkspaceHistoryFileHandler {
    private static final String history_xml_location = String.valueOf(PropertyHandler.getVariable("configuration_location")) + "/history.xml";
    private static final Logger logger = Logger.getLogger(WorkspaceHistoryFileHandler.class);

    public static boolean isHistoryExists() {
        File file = new File(history_xml_location);
        return file.exists();
    }

    public static void createHistoryXMLFile() throws Exception {
        Element workspaceList = new Element("workspace_list");
        Document doc = new Document(workspaceList);
        doc.setRootElement(workspaceList);
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        try {
            xmlOutput.output(doc, (Writer)new FileWriter(history_xml_location));
        }
        catch (IOException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new Exception("Unable to create history xml file: " + history_xml_location + ": " + e.getMessage());
        }
    }

    public static String getLastActiveHistory() throws Exception {
        String resultPath = null;
        if (WorkspaceHistoryFileHandler.isHistoryExists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build(new File(history_xml_location));
                XPath xpath = null;
                xpath = XPath.newInstance((String)"//workspace[@last_active='true']");
                List resultList = xpath.selectNodes((Object)document);
                for (Element oNode : resultList) {
                    if (!oNode.getAttribute("last_active").getValue().equals("true")) continue;
                    resultPath = oNode.getAttribute("path").getValue();
                }
            }
            catch (JDOMException jDOMException) {
                logger.fatal((Object)("Error occurred while reading history xml file: " + history_xml_location));
                throw new Exception("Error occurred while reading history xml file: " + history_xml_location);
            }
            catch (IOException iOException) {
                logger.fatal((Object)("Error occurred while reading history xml file: " + history_xml_location));
                throw new Exception("Error occurred while reading history xml file: " + history_xml_location);
            }
        } else {
            logger.fatal((Object)("workspace history file does not exist: " + history_xml_location));
            throw new Exception("workspace history file does not exist: " + history_xml_location);
        }
        return resultPath;
    }

    public static List<WorkspaceHistoryEntry> readHistoryFile() throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(history_xml_location);
        ArrayList<WorkspaceHistoryEntry> resultList = new ArrayList<WorkspaceHistoryEntry>();
        if (xmlFile.exists()) {
            Document document = null;
            try {
                document = builder.build(xmlFile);
            }
            catch (JDOMException e) {
                logger.fatal((Object)e);
                throw new JDOMException("Error occured while reading history xml file: " + history_xml_location, (Throwable)e);
            }
            catch (IOException e) {
                logger.fatal((Object)e);
                throw new IOException("Error occured while reading history xml file: " + history_xml_location, e);
            }
            Element rootNode = document.getRootElement();
            if (!rootNode.getName().equals("workspace_list")) {
                logger.fatal((Object)("Workspace History file does not start with workspace_list tag: " + history_xml_location));
                throw new IOException("Workspace History file does not start with workspace_list tag: " + history_xml_location);
            }
            List childrenNodes = rootNode.getChildren();
            for (Element child : childrenNodes) {
                if (!child.getName().equals("workspace")) {
                    logger.fatal((Object)("Child element does not start with workspace tag in " + history_xml_location));
                    throw new IOException("Child element does not start with workspace tag in " + history_xml_location);
                }
                WorkspaceHistoryEntry con = new WorkspaceHistoryEntry();
                Attribute path = child.getAttribute("path");
                con.setPath(path.getValue());
                Attribute lastActive = child.getAttribute("last_active");
                con.setLastActive(lastActive.getValue());
                resultList.add(con);
            }
            return resultList;
        }
        logger.fatal((Object)("workspace history file does not exist: " + history_xml_location));
        throw new IOException("workspace history file does not exist: " + history_xml_location);
    }

    public static void updateHistoryXMLFile(String path, boolean flag) throws IOException, JDOMException {
        Element rootNode;
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(history_xml_location);
        if (!xmlFile.exists()) {
            logger.fatal((Object)("Cannot find history xml file: " + history_xml_location));
            throw new IOException("Cannot find history xml file:" + history_xml_location);
        }
        Document doc = null;
        try {
            doc = builder.build(xmlFile);
            rootNode = doc.getRootElement();
        }
        catch (JDOMException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new JDOMException("Error occured while reading history xml file: " + history_xml_location, (Throwable)e);
        }
        if (!flag) {
            Element workspace = new Element("workspace");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("path", path));
            atts.add(new Attribute("last_active", "true"));
            workspace.setAttributes(atts);
            doc.getRootElement().addContent((Content)workspace);
        }
        List childrenNodes = rootNode.getChildren();
        int i = 0;
        while (i < childrenNodes.size()) {
            Element attr = (Element)childrenNodes.get(i);
            if (attr.getAttributeValue("path").equals(path)) {
                attr.getAttribute("last_active").setValue("true");
            } else {
                attr.getAttribute("last_active").setValue("false");
            }
            ++i;
        }
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        try {
            xmlOutput.output(doc, (Writer)new FileWriter(history_xml_location));
        }
        catch (IOException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new IOException("Error occurred while writing to xml file: " + history_xml_location, e);
        }
    }

    public static void writeHistoryFile(WorkspaceHistory history) throws Exception {
        File xmlFile = new File(history_xml_location);
        if (!xmlFile.exists()) {
            logger.fatal((Object)("Cannot find history xml file: " + history_xml_location));
            throw new IOException("Cannot find history xml file:" + history_xml_location);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WorkspaceHistory.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)history, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(xmlFile);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }
}

