/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

public class CompositionOptions {
    public String OR1_NAME = "Or1";
    public String OR2_NAME = "Or2";
    public String OR3_NAME = "Or3";
    public double OR1_MASS = 0.0;
    public double OR2_MASS = 0.0;
    public double OR3_MASS = 0.0;
    public int PEN = 0;
    public int HEX = 0;
    public int HEP = 0;
    public int HEXN = 0;
    public int HEXNAC = 0;
    public int DPEN = 0;
    public int DHEX = 0;
    public int DDHEX = 0;
    public int MEHEX = 0;
    public int OR1 = 0;
    public int OR2 = 0;
    public int OR3 = 0;
    public int HEXA = 0;
    public int DHEXA = 0;
    public int NEU5GC = 0;
    public int NEU5AC = 0;
    public int NEU5GCLAC = 0;
    public int NEU5ACLAC = 0;
    public int KDO = 0;
    public int KDN = 0;
    public int MUR = 0;
    public int S = 0;
    public int P = 0;
    public int AC = 0;
    public int PYR = 0;
    public int PC = 0;

    public void store(Configuration config) {
        config.put("CompositionOptions", "pen", this.PEN);
        config.put("CompositionOptions", "hex", this.HEX);
        config.put("CompositionOptions", "hep", this.HEP);
        config.put("CompositionOptions", "hexn", this.HEXN);
        config.put("CompositionOptions", "hexnac", this.HEXNAC);
        config.put("CompositionOptions", "dpen", this.DPEN);
        config.put("CompositionOptions", "dhex", this.DHEX);
        config.put("CompositionOptions", "ddhex", this.DDHEX);
        config.put("CompositionOptions", "mehex", this.MEHEX);
        config.put("CompositionOptions", "or1", this.OR1);
        config.put("CompositionOptions", "or2", this.OR2);
        config.put("CompositionOptions", "or3", this.OR3);
        config.put("CompositionOptions", "or1_mass", this.OR1_MASS);
        config.put("CompositionOptions", "or2_mass", this.OR2_MASS);
        config.put("CompositionOptions", "or3_mass", this.OR3_MASS);
        config.put("CompositionOptions", "hexa", this.HEXA);
        config.put("CompositionOptions", "dhexa", this.DHEXA);
        config.put("CompositionOptions", "neu5gc", this.NEU5GC);
        config.put("CompositionOptions", "neu5ac", this.NEU5AC);
        config.put("CompositionOptions", "neu5gclac", this.NEU5GCLAC);
        config.put("CompositionOptions", "neu5aclac", this.NEU5ACLAC);
        config.put("CompositionOptions", "kdp", this.KDO);
        config.put("CompositionOptions", "kdn", this.KDN);
        config.put("CompositionOptions", "mur", this.MUR);
        config.put("CompositionOptions", "s", this.S);
        config.put("CompositionOptions", "p", this.P);
        config.put("CompositionOptions", "ac", this.AC);
        config.put("CompositionOptions", "pyr", this.PYR);
        config.put("CompositionOptions", "pc", this.PC);
    }

    public void retrieve(Configuration config) {
        this.PEN = config.get("CompositionOptions", "pen", this.PEN);
        this.HEX = config.get("CompositionOptions", "hex", this.HEX);
        this.HEP = config.get("CompositionOptions", "hep", this.HEP);
        this.HEXN = config.get("CompositionOptions", "hexn", this.HEXN);
        this.HEXNAC = config.get("CompositionOptions", "hexnac", this.HEXNAC);
        this.DPEN = config.get("CompositionOptions", "dpen", this.DPEN);
        this.DHEX = config.get("CompositionOptions", "dhex", this.DHEX);
        this.DDHEX = config.get("CompositionOptions", "ddhex", this.DDHEX);
        this.MEHEX = config.get("CompositionOptions", "mehex", this.MEHEX);
        this.OR1 = config.get("CompositionOptions", "or1", this.OR1);
        this.OR2 = config.get("CompositionOptions", "or2", this.OR2);
        this.OR3 = config.get("CompositionOptions", "or3", this.OR3);
        this.OR1_MASS = config.get("CompositionOptions", "or1_mass", this.OR1_MASS);
        this.OR2_MASS = config.get("CompositionOptions", "or2_mass", this.OR2_MASS);
        this.OR3_MASS = config.get("CompositionOptions", "or3_mass", this.OR3_MASS);
        this.HEXA = config.get("CompositionOptions", "hexa", this.HEXA);
        this.DHEXA = config.get("CompositionOptions", "dhexa", this.DHEXA);
        this.NEU5GC = config.get("CompositionOptions", "neu5gc", this.NEU5GC);
        this.NEU5AC = config.get("CompositionOptions", "neu5ac", this.NEU5AC);
        this.NEU5GCLAC = config.get("CompositionOptions", "neu5gclac", this.NEU5GCLAC);
        this.NEU5ACLAC = config.get("CompositionOptions", "neu5aclac", this.NEU5ACLAC);
        this.KDO = config.get("CompositionOptions", "kdp", this.KDO);
        this.KDN = config.get("CompositionOptions", "kdn", this.KDN);
        this.MUR = config.get("CompositionOptions", "mur", this.MUR);
        this.S = config.get("CompositionOptions", "s", this.S);
        this.P = config.get("CompositionOptions", "p", this.P);
        this.AC = config.get("CompositionOptions", "ac", this.AC);
        this.PYR = config.get("CompositionOptions", "pyr", this.PYR);
        this.PC = config.get("CompositionOptions", "pc", this.PC);
    }

    public Glycan getCompositionAsGlycan(MassOptions mopt) throws Exception {
        int i;
        Glycan ret = Glycan.createComposition(mopt);
        for (i = 0; i < this.PEN; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("Pen"));
        }
        for (i = 0; i < this.HEX; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("Hex"));
        }
        for (i = 0; i < this.HEP; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("Hept"));
        }
        for (i = 0; i < this.HEXN; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("HexN"));
        }
        for (i = 0; i < this.HEXNAC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("HexNAc"));
        }
        for (i = 0; i < this.DPEN; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("dPen"));
        }
        for (i = 0; i < this.DHEX; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("dHex"));
        }
        for (i = 0; i < this.DDHEX; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("ddHex"));
        }
        for (i = 0; i < this.MEHEX; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("MeH"));
        }
        for (i = 0; i < this.HEXA; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("HexA"));
        }
        for (i = 0; i < this.DHEXA; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("dHexA"));
        }
        for (i = 0; i < this.NEU5GC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("NeuGc"));
        }
        for (i = 0; i < this.NEU5AC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("NeuAc"));
        }
        for (i = 0; i < this.NEU5GCLAC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("NeuGcLac"));
        }
        for (i = 0; i < this.NEU5ACLAC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("NeuAcLac"));
        }
        for (i = 0; i < this.KDO; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("KDO"));
        }
        for (i = 0; i < this.KDN; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("KDN"));
        }
        for (i = 0; i < this.MUR; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("MurNAc"));
        }
        for (i = 0; i < this.S; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("S"));
        }
        for (i = 0; i < this.P; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("P"));
        }
        for (i = 0; i < this.AC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("Ac"));
        }
        for (i = 0; i < this.PYR; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("Pyr"));
        }
        for (i = 0; i < this.PC; ++i) {
            ret.addAntenna(ResidueDictionary.newResidue("PC"));
        }
        for (i = 0; i < this.OR1; ++i) {
            ret.addAntenna(new Residue(ResidueType.createOtherResidue(this.OR1_NAME, this.OR1_MASS)));
        }
        for (i = 0; i < this.OR2; ++i) {
            ret.addAntenna(new Residue(ResidueType.createOtherResidue(this.OR2_NAME, this.OR2_MASS)));
        }
        for (i = 0; i < this.OR3; ++i) {
            ret.addAntenna(new Residue(ResidueType.createOtherResidue(this.OR3_NAME, this.OR3_MASS)));
        }
        return ret;
    }
}

