/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.jdesktop.layout.GroupLayout;

public class RepetitionPropertiesDialog
extends EscapeDialog
implements ActionListener,
ItemListener {
    private Residue current;
    private GlycanDocument theDoc;
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_max_rep;
    private JTextField field_min_rep;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;

    public RepetitionPropertiesDialog(Frame parent, Residue _current, GlycanDocument _theDoc) {
        super(parent, true);
        this.current = _current;
        this.theDoc = _theDoc;
        this.initComponents();
        this.fillComponents();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private void fillComponents() {
        this.field_min_rep.setText("" + this.current.getMinRepetitions());
        this.field_max_rep.setText("" + this.current.getMaxRepetitions());
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent(this.field_min_rep);
        tp.addComponent(this.field_max_rep);
        tp.addComponent(this.button_ok);
        tp.addComponent(this.button_cancel);
        this.setFocusTraversalPolicy(tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        String min_rep = this.field_min_rep.getText();
        String max_rep = this.field_max_rep.getText();
        this.current.setMinRepetitions(min_rep);
        this.current.setMaxRepetitions(max_rep);
        this.theDoc.fireDocumentChanged();
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.enableItems();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.field_min_rep = new JTextField();
        this.field_max_rep = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RepetitionPropertiesDialog.this.closeDialog();
            }
        });
        this.jLabel1.setText("Min repetitions");
        this.field_min_rep.setText("jTextField1");
        this.field_max_rep.setText("jTextField1");
        this.jLabel2.setText("Max repetitions");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel)).add((Component)this.jSeparator1, -1, 183, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_max_rep, -1, 74, Short.MAX_VALUE).add((Component)this.field_min_rep, -1, 74, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.field_min_rep, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_max_rep, -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_ok).add((Component)this.button_cancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

