/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    private XMLUtils() {
    }

    public static Document newDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Document read(String data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(data.getBytes()));
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Document read(byte[] data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(data));
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static Document read(InputStream is) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return null;
        }
    }

    public static boolean write(OutputStream os, Document d) {
        try {
            if (os == null || d == null) {
                return false;
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(d);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
            StreamResult result = new StreamResult(bw);
            transformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public static Node findChild(Node node, String child_name) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(child_name)) continue;
            return child;
        }
        return null;
    }

    public static Node assertChild(Node node, String child_name) throws Exception {
        Node ret = XMLUtils.findChild(node, child_name);
        if (ret == null) {
            throw new Exception("Cannot find " + child_name + " node");
        }
        return ret;
    }

    public static Vector<Node> findAllChildren(Node node) {
        if (node == null) {
            return null;
        }
        Vector<Node> found_children = new Vector<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            found_children.add(child);
        }
        return found_children;
    }

    public static Vector<Node> findAllChildren(Node node, String child_name) {
        if (node == null) {
            return null;
        }
        Vector<Node> found_children = new Vector<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(child_name)) continue;
            found_children.add(child);
        }
        return found_children;
    }

    public static Node findChildAssertive(Node node, String child_name) {
        if (node == null) {
            return null;
        }
        Node child = XMLUtils.findChild(node, child_name);
        if (child != null) {
            return child;
        }
        return node.appendChild(node.getOwnerDocument().createElement(child_name));
    }

    public static void setText(Node node, String value) {
        if (node == null) {
            return;
        }
        Node child = XMLUtils.findChild(node, "#text");
        if (child == null) {
            node.appendChild(node.getOwnerDocument().createTextNode(value));
        } else {
            child.setNodeValue(value);
        }
    }

    public static String getText(Node node) {
        if (node == null) {
            return null;
        }
        Node child = XMLUtils.findChild(node, "#text");
        if (child == null) {
            return null;
        }
        return child.getNodeValue();
    }

    public static String getAttribute(Node node, String att_name) {
        if (node == null) {
            return "";
        }
        return XMLUtils.getText(node.getAttributes().getNamedItem(att_name));
    }

    public static Integer getIntegerAttribute(Node node, String att_name) {
        if (node == null) {
            return null;
        }
        String text = XMLUtils.getText(node.getAttributes().getNamedItem(att_name));
        if (text == null) {
            return null;
        }
        return Integer.valueOf(text);
    }

    public static Double getDoubleAttribute(Node node, String att_name) {
        if (node == null) {
            return null;
        }
        String text = XMLUtils.getText(node.getAttributes().getNamedItem(att_name));
        if (text == null) {
            return null;
        }
        return Double.valueOf(text);
    }

    public static Boolean getBooleanAttribute(Node node, String att_name) {
        if (node == null) {
            return null;
        }
        String text = XMLUtils.getText(node.getAttributes().getNamedItem(att_name));
        if (text == null) {
            return null;
        }
        return Boolean.valueOf(text);
    }
}

