/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.views;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.CancelableMultiPageEditor;
import org.grits.toolbox.core.editor.IEntryEditorPart;
import org.grits.toolbox.core.preference.share.IGritsPreferenceStore;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.datamodel.ms.annotation.glycan.report.preference.MSGlycanAnnotationReportViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.report.process.loader.MSGlycanAnnotationReportTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.MSGlycanAnnotationReportProperty;
import org.grits.toolbox.entry.ms.annotation.glycan.report.tablehelpers.MSGlycanAnnotationReportTable;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportMultiPageViewerWorker;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportPropertyView;
import org.grits.toolbox.entry.ms.annotation.glycan.report.views.MSGlycanAnnotationReportResultsView;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecTableBase;
import org.grits.toolbox.widgets.processDialog.GRITSProgressDialog;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MSGlycanAnnotationReportMultiPageViewer
extends CancelableMultiPageEditor {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportMultiPageViewer.class);
    protected Entry entry = null;
    protected MSGlycanAnnotationReportPropertyView propertyView = null;
    protected MSGlycanAnnotationReportResultsView resultsView = null;
    protected int propertyViewTabIndex = -1;
    protected int resultsViewTabIndex = -1;
    public static String VIEW_ID = "plugin.ms.annotation.glycan.views.MSGlycanAnnotationReportMultiPageViewer";
    @Inject
    protected IGritsPreferenceStore gritsPreferenceStore;
    @Inject
    MDirtyable dirtyable;
    @Inject
    protected static IGritsDataModelService gritsModelService;
    @Inject
    ESelectionService selectionService;
    @Inject
    IEventBroker eventBroker;

    public String toString() {
        return "MSGlycanAnnotationReportMultiPageViewer (" + this.entry + ")";
    }

    @Inject
    public MSGlycanAnnotationReportMultiPageViewer(Entry entry) {
        this.entry = entry;
    }

    @Inject
    public MSGlycanAnnotationReportMultiPageViewer(MPart part) {
        this.entry = (Entry)part.getTransientData().get("org.grits.toolbox.entry.current");
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void setPropertyViewTabIndex(int propertyViewTabIndex) {
        this.propertyViewTabIndex = propertyViewTabIndex;
    }

    public int getPropertyViewTabIndex() {
        return this.propertyViewTabIndex;
    }

    public void setResultsViewTabIndex(int resultsViewTabIndex) {
        this.resultsViewTabIndex = resultsViewTabIndex;
    }

    public int getResultsViewTabIndex() {
        return this.resultsViewTabIndex;
    }

    protected Entry getFirstPageEntry() {
        try {
            Entry parentEntry = null;
            if (gritsModelService.getLastSelection() != null && gritsModelService.getLastSelection().getFirstElement() instanceof Entry) {
                parentEntry = (Entry)gritsModelService.getLastSelection().getFirstElement();
            }
            return parentEntry;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected Object getDesiredActivePage() {
        return this.resultsView;
    }

    public void setActivePage() {
        try {
            int i = 0;
            while (i < this.getPageCount()) {
                IEntryEditorPart page = this.getPageItem(i);
                if (page != null && page.equals(this.getDesiredActivePage())) {
                    this.setActivePage(i);
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to getFirstTabIndex", (Throwable)ex);
        }
    }

    protected int addPages(int _iMajorCount, MSGlycanAnnotationReportProperty prop) {
        this.dtpdThreadedDialog = new GRITSProgressDialog(new Shell(), 1, true);
        this.dtpdThreadedDialog.open();
        this.dtpdThreadedDialog.getMajorProgressBarListener().setMaxValue(_iMajorCount);
        MSGlycanAnnotationReportMultiPageViewerWorker msmpvw = new MSGlycanAnnotationReportMultiPageViewerWorker(this, _iMajorCount, prop);
        this.dtpdThreadedDialog.setGritsWorker((GRITSWorker)msmpvw);
        int iSuccess = this.dtpdThreadedDialog.startWorker();
        return iSuccess;
    }

    protected int getNumMajorSteps(MSGlycanAnnotationReportProperty prop) {
        int iCount = 3;
        return iCount;
    }

    public void createPages() {
        if (this.entry == null) {
            this.entry = this.getFirstPageEntry();
        }
        Property prop = this.entry.getProperty();
        int iNumSteps = this.getNumMajorSteps((MSGlycanAnnotationReportProperty)prop);
        this.iStatus = this.addPages(iNumSteps, (MSGlycanAnnotationReportProperty)prop);
        if (this.iStatus == GRITSProcessStatus.ERROR) {
            throw new RuntimeException("Failed to open the entry");
        }
        this.setPartName(this.entry.getDisplayName());
        this.setActivePage();
    }

    protected boolean initMSPropertyView() {
        try {
            this.getPart().getContext().set(Entry.class, (Object)this.entry);
            this.propertyView = (MSGlycanAnnotationReportPropertyView)((Object)ContextInjectionFactory.make(MSGlycanAnnotationReportPropertyView.class, (IEclipseContext)this.getPart().getContext()));
            this.propertyView.setMergeSettings(((MSGlycanAnnotationReportTableDataProcessor)this.resultsView.getTableDataProcessor()).getMergeReportSettings());
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open ms property view", (Throwable)ex);
            return false;
        }
    }

    protected int initResultsView(MSGlycanAnnotationReportProperty entityProperty) {
        try {
            this.resultsView = this.getNewResultsView(this.entry, entityProperty);
            this.resultsView.setTableDataProcessor(this.getThreadedDialog());
            return GRITSProcessStatus.OK;
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open scans view", (Throwable)ex);
            return GRITSProcessStatus.ERROR;
        }
    }

    protected MassSpecProperty getMSProperty(Entry entry) {
        if (entry == null || entry.getProperty() == null) {
            return null;
        }
        if (entry.getProperty() instanceof MassSpecProperty) {
            return (MassSpecProperty)entry.getProperty();
        }
        return this.getMSProperty(entry.getParent());
    }

    protected MSGlycanAnnotationReportResultsView getNewResultsView(Entry entry, MSGlycanAnnotationReportProperty property) {
        this.getPart().getContext().set(Property.class, (Object)property);
        this.getPart().getContext().set(Entry.class, (Object)entry);
        return (MSGlycanAnnotationReportResultsView)((Object)ContextInjectionFactory.make(MSGlycanAnnotationReportResultsView.class, (IEclipseContext)this.getPart().getContext()));
    }

    public MSGlycanAnnotationReportResultsView getResultsView() {
        return this.resultsView;
    }

    public MSGlycanAnnotationReportPropertyView getPropertyView() {
        return this.propertyView;
    }

    @Persist
    public void doSave(final IProgressMonitor monitor) {
        GRITSProgressDialog progressDialog = new GRITSProgressDialog(Display.getCurrent().getActiveShell(), 0, false, false);
        progressDialog.open();
        progressDialog.getMajorProgressBarListener().setMaxValue(2);
        progressDialog.setGritsWorker(new GRITSWorker(){

            public int doWork() {
                if (MSGlycanAnnotationReportMultiPageViewer.this.propertyView != null && MSGlycanAnnotationReportMultiPageViewer.this.propertyView.isDirty()) {
                    this.updateListeners("Saving properties", 1);
                    MSGlycanAnnotationReportMultiPageViewer.this.propertyView.doSave(monitor);
                }
                if (MSGlycanAnnotationReportMultiPageViewer.this.resultsView != null && MSGlycanAnnotationReportMultiPageViewer.this.resultsView.isDirty()) {
                    this.updateListeners("Saving resport", 2);
                    MSGlycanAnnotationReportMultiPageViewer.this.resultsView.doSave(monitor);
                }
                MSGlycanAnnotationReportMultiPageViewer.this.setDirty(false);
                this.updateListeners("Done saving", 2);
                return GRITSProcessStatus.OK;
            }
        });
        progressDialog.startWorker();
    }

    @Optional
    @Inject
    public void tabContentModified(@UIEventTopic(value="content_modified_in_a_tab") IEntryEditorPart part) {
        if (part.equals((Object)this.propertyView) || part.equals((Object)this.resultsView)) {
            this.setDirty(part.isDirty());
        }
    }

    public void setDirty(boolean d) {
        this.dirtyable.setDirty(d);
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    public boolean isCanceled() {
        return false;
    }

    public int addPropertyPage() {
        try {
            boolean success = this.initMSPropertyView();
            int iPageCount = this.getPageCount();
            if (success) {
                try {
                    int inx = this.addPage((IEntryEditorPart)this.propertyView, this.entry);
                    this.setPageText(inx, "Report Properties");
                    this.setActivePage(inx);
                    this.setStatus(GRITSProcessStatus.OK);
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to open Report property view", (Throwable)ex);
                    this.setStatus(GRITSProcessStatus.ERROR);
                }
            }
            if (this.isCanceled()) {
                this.setStatus(GRITSProcessStatus.CANCEL);
            }
            boolean bl = success = this.getStatus() == GRITSProcessStatus.OK;
            if (!success) {
                if (this.getPageCount() != iPageCount) {
                    this.removePage(this.getPageCount());
                }
                this.propertyView = null;
            } else {
                this.setPropertyViewTabIndex(this.getPageCount() - 1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Report property view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Report Properties tab.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addResultsPage_Step1(MSGlycanAnnotationReportProperty prop) {
        try {
            int iSuccess = this.initResultsView(prop);
            this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            if (iSuccess == GRITSProcessStatus.CANCEL) {
                this.setStatus(GRITSProcessStatus.CANCEL);
                return GRITSProcessStatus.CANCEL;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open MS Peaks view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Report.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    public int addResultsPage_Step2() {
        try {
            boolean success = true;
            int iPageCount = this.getPageCount();
            try {
                int inx = this.addPage((IEntryEditorPart)this.resultsView, this.entry);
                this.setPageText(inx, "Results View");
                this.setActivePage(inx);
                int iSuccess = this.resultsView.getStatus();
                this.setStatus(iSuccess);
                this.dtpdThreadedDialog.setMinorStatus(iSuccess);
            }
            catch (Exception ex) {
                logger.error((Object)"Error adding Report tab.", (Throwable)ex);
                this.setStatus(GRITSProcessStatus.ERROR);
            }
            boolean bl = success = this.getStatus() != GRITSProcessStatus.ERROR;
            if (!success) {
                if (this.getPageCount() != iPageCount && this.getPageCount() >= 1) {
                    this.removePage(this.getPageCount() - 1);
                }
                this.resultsView = null;
            } else {
                this.setResultsViewTabIndex(this.getPageCount() - 1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to open Report view", (Throwable)ex);
            this.setStatus(GRITSProcessStatus.ERROR);
        }
        if (this.getStatus() == GRITSProcessStatus.ERROR) {
            String sMessage = "An error occurred creating the Report.";
            this.dtpdThreadedDialog.getMajorProgressBarListener().setError(sMessage);
        }
        return this.getStatus();
    }

    protected void updateColumnVisibility(MSGlycanAnnotationReportTable table, MSGlycanAnnotationReportViewerPreference curPref, MSGlycanAnnotationReportViewerPreference updatePref) {
        if (curPref.getClass().equals(updatePref.getClass()) && curPref.getMSLevel() == updatePref.getMSLevel() && curPref.getFillType() == updatePref.getFillType() && !updatePref.getColumnSettings().equals(curPref.getColumnSettings())) {
            table.getGRITSTableDataObject().setTablePreferences((TableViewerPreference)updatePref);
            table.updateViewFromPreferenceSettings();
        }
    }

    protected void updateColumnVisibility(MSGlycanAnnotationReportViewerPreference updatePref) {
        try {
            if (this.getResultsView() != null) {
                MSGlycanAnnotationReportResultsView resultsView = this.getResultsView();
                if (resultsView.getResultsView() == null) {
                    return;
                }
                MassSpecTableBase viewBase = resultsView.getResultsView().getBaseView();
                if (viewBase == null || viewBase.getNatTable() == null) {
                    return;
                }
                MSGlycanAnnotationReportTable table = (MSGlycanAnnotationReportTable)viewBase.getNatTable();
                MSGlycanAnnotationReportTableDataProcessor proc = (MSGlycanAnnotationReportTableDataProcessor)resultsView.getTableDataProcessor();
                MSGlycanAnnotationReportViewerPreference curPref = (MSGlycanAnnotationReportViewerPreference)proc.getSimianTableDataObject().getTablePreferences();
                this.updateColumnVisibility(table, curPref, updatePref);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error updating Results view from editor: " + this.getTitle()), (Throwable)ex);
        }
    }

    @Optional
    @Inject
    public void updatePreferences(@UIEventTopic(value="preference_value_changed_in_grits") String preferenceName) {
        if (preferenceName != null && preferenceName.startsWith(MSGlycanAnnotationReportViewerPreference.class.getName())) {
            try {
                PreferenceEntity preferenceEntity = this.gritsPreferenceStore.getPreferenceEntity(preferenceName);
                MSGlycanAnnotationReportViewerPreference updatePref = (MSGlycanAnnotationReportViewerPreference)TableViewerPreference.getTableViewerPreference((PreferenceEntity)preferenceEntity, MSGlycanAnnotationReportViewerPreference.class);
                this.updateColumnVisibility(updatePref);
            }
            catch (UnsupportedVersionException e) {
                logger.error((Object)"Error updating column visibility", (Throwable)e);
            }
        }
    }

    public static String[] getPreferencePageLabels() {
        return new String[]{"Results View"};
    }

    public static FillTypes[] getPreferencePageFillTypes() {
        return new FillTypes[]{FillTypes.Scans};
    }

    public static int getPreferencePageMaxNumPages() {
        return 1;
    }

    public static MSGlycanAnnotationReportMultiPageViewer getActiveViewerForEntry(IEclipseContext context, Entry entry) {
        EPartService partService = (EPartService)context.get(EPartService.class);
        for (MPart part : partService.getParts()) {
            if (!(part.getObject() instanceof MSGlycanAnnotationReportMultiPageViewer) || !((MSGlycanAnnotationReportMultiPageViewer)((Object)part.getObject())).getEntry().equals(entry)) continue;
            return (MSGlycanAnnotationReportMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    @Focus
    public void setFocus() {
        this.getContainer().forceFocus();
    }

    public static MSGlycanAnnotationReportMultiPageViewer getActiveViewer(IEclipseContext context) {
        MPart part = (MPart)context.get("e4ActivePart");
        if (part != null && part.getObject() instanceof MSGlycanAnnotationReportMultiPageViewer) {
            return (MSGlycanAnnotationReportMultiPageViewer)((Object)part.getObject());
        }
        return null;
    }

    public void selectMSGlycanAnnotationEntry(Entry msAnnotationEntry) {
        this.eventBroker.send("grits_entry_selected", (Object)msAnnotationEntry);
    }
}

