/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class PushDownAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    private static IMember[] getSelectedMembers(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection.size() == 1) {
            try {
                IType type = RefactoringAvailabilityTester.getSingleSelectedType(selection);
                if (type != null) {
                    return new IType[]{type};
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof IMember) continue;
            return null;
        }
        HashSet<Object> memberSet = new HashSet<Object>();
        memberSet.addAll(Arrays.asList(selection.toArray()));
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    public PushDownAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public PushDownAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.PushDownAction_Push_Down);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.push_down_action");
    }

    private IMember getSelectedMemberFromEditor() throws JavaModelException {
        IJavaElement element = SelectionConverter.resolveEnclosingElement(this.fEditor, (ITextSelection)this.fEditor.getSelectionProvider().getSelection());
        if (element == null || !(element instanceof IMember)) {
            return null;
        }
        return (IMember)element;
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember[] members = PushDownAction.getSelectedMembers(selection);
            if (RefactoringAvailabilityTester.isPushDownAvailable(members) && ActionUtil.isEditable(this.getShell(), (IJavaElement)members[0])) {
                RefactoringExecutionStarter.startPushDownRefactoring(members, this.getShell());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection selection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IMember member = this.getSelectedMemberFromEditor();
            IMember[] array = new IMember[]{member};
            if (member != null && RefactoringAvailabilityTester.isPushDownAvailable(array)) {
                RefactoringExecutionStarter.startPushDownRefactoring(array, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.PushDownAction_To_activate);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isPushDownAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isPushDownAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }
}

