/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.eurocarbdb.MolecularFramework.io.CarbohydrateSequenceEncoding;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.SortingTablePanel;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureDictionary;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.wggds.webservices.io.QueryResultProcessor;
import org.wggds.webservices.io.data.BiologicalContext;
import org.wggds.webservices.io.data.CompleteInformation;
import org.wggds.webservices.io.data.OutputFormat;
import org.wggds.webservices.io.data.QueryResultHeader;
import org.wggds.webservices.io.data.ServerSideError;
import org.wggds.webservices.io.data.StructureResult;
import org.wggds.webservices.io.query.AllStructuresQuery;

public class DictionariesManagerPanel
extends SortingTablePanel<ProfilerPlugin>
implements ActionListener,
ProfilerPlugin.DictionariesChangeListener {
    protected JToolBar theToolBar;

    public DictionariesManagerPanel(ProfilerPlugin profiler) {
        this.setProfiler(profiler);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theToolBar = this.createToolBar();
        this.add((Component)this.theToolBar, "South");
        this.theTable.setShowVerticalLines(false);
        this.theTable.setSelectionMode(0);
        this.theTable.setUseStyledText(false);
    }

    @Override
    protected ProfilerPlugin getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return null;
    }

    @Override
    protected void setDocumentFromWorkspace(GlycanWorkspace workspace) {
    }

    public void setProfiler(ProfilerPlugin _theDocument) {
        if (this.theDocument != null) {
            ((ProfilerPlugin)this.theDocument).removeDictionariesChangeListener(this);
        }
        this.theDocument = _theDocument != null ? _theDocument : new ProfilerPlugin(this.theApplication);
        ((ProfilerPlugin)this.theDocument).addDictionariesChangeListener(this);
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("add", FileUtils.defaultThemeManager.getImageIcon("add"), "Add new dictionary", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open existing dictionary", 79, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete selected dictionary", 127, "", (ActionListener)this);
        this.theActionManager.add("edit", FileUtils.defaultThemeManager.getImageIcon("edit"), "Edit selected dictionary", 69, "", (ActionListener)this);
        this.theActionManager.add("setwggdsurl", FileUtils.defaultThemeManager.getImageIcon("wggds_logo_260"), "Edit WGGDS URL", 77, "", (ActionListener)this);
        this.theActionManager.add("wggdssync", FileUtils.defaultThemeManager.getImageIcon("wggds_logo_260"), "Update local copy", 77, "", (ActionListener)this);
        this.theActionManager.add("wggdsearchlive", FileUtils.defaultThemeManager.getImageIcon("wggds_logo_260"), "Search live", 77, "", (ActionListener)this);
        this.theActionManager.add("wggdsreset", FileUtils.defaultThemeManager.getImageIcon("wggds_logo_260"), "Restore to builtin version", 77, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        boolean writeable = has_selection && this.getSelectedDictionary().isOnFileSystem();
        this.theActionManager.get("delete").setEnabled(writeable);
        this.theActionManager.get("edit").setEnabled(has_selection);
        this.theActionManager.get("setwggdsurl").setEnabled(has_selection);
        if (has_selection) {
            StructureDictionary dict = this.getSelectedDictionary();
            this.theActionManager.get("wggdssync").setEnabled(dict.isWggds() && writeable);
            this.theActionManager.get("wggdsearchlive").setEnabled(dict.isWggds());
            this.theActionManager.get("wggdsearchlive").setSelected(dict.isLiveSearch());
            this.theActionManager.get("wggdsreset").setEnabled(!dict.getSourceFile().equals("") && writeable);
        } else {
            this.theActionManager.get("wggdssync").setEnabled(false);
            this.theActionManager.get("wggdsearchlive").setEnabled(false);
            this.theActionManager.get("wggdsreset").setEnabled(false);
        }
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("add"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("delete"));
        toolbar.add((Action)this.theActionManager.get("edit"));
        toolbar.add((Action)this.theActionManager.get("setwggdsurl"));
        toolbar.add((Action)this.theActionManager.get("wggdssync"));
        toolbar.add(this.theActionManager.get("wggdsearchlive").getJCheckBox("Search Live", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StructureDictionary dict = DictionariesManagerPanel.this.getSelectedDictionary();
                if (dict != null) {
                    dict.setLiveSearch(((JCheckBox)arg0.getSource()).isSelected());
                }
                dict.save();
                DictionariesManagerPanel.this.updateActions();
            }
        }));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        final JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("delete"));
        menu.add((Action)this.theActionManager.get("edit"));
        menu.add((Action)this.theActionManager.get("setwggdsurl"));
        menu.add((Action)this.theActionManager.get("wggdssync"));
        menu.add((Action)this.theActionManager.get("wggdsreset"));
        menu.add(this.theActionManager.get("wggdsearchlive").getJCheckBox("Search Live", false, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                StructureDictionary dict = DictionariesManagerPanel.this.getSelectedDictionary();
                if (dict != null) {
                    dict.setLiveSearch(((JCheckBox)arg0.getSource()).isSelected());
                }
                menu.setVisible(false);
                dict.save();
                DictionariesManagerPanel.this.updateActions();
            }
        }));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return Integer.class;
        }
        if (columnIndex == 2) {
            return String.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Name";
        }
        if (columnIndex == 1) {
            return "Size";
        }
        if (columnIndex == 2) {
            return "Path";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.theDocument == null) {
            return 0;
        }
        return ((ProfilerPlugin)this.theDocument).getDictionaries().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StructureDictionary sd = new ArrayList<StructureDictionary>(((ProfilerPlugin)this.theDocument).getDictionaries()).get(rowIndex);
        if (columnIndex == 0) {
            return sd.getDictionaryName();
        }
        if (columnIndex == 1) {
            return sd.size();
        }
        if (columnIndex == 2) {
            return sd.isOnFileSystem() ? sd.getFileName() : "";
        }
        return null;
    }

    public StructureDictionary getSelectedDictionary() {
        if (this.theTable.getSelectedRow() >= 0) {
            return new ArrayList<StructureDictionary>(((ProfilerPlugin)this.theDocument).getDictionaries()).get(this.theTable.getSelectedRow());
        }
        return null;
    }

    public boolean createUserDatabase() {
        try {
            int retValue;
            File file;
            String name = JOptionPane.showInputDialog(this, (Object)"Specify a database name");
            if (name == null || name.length() == 0) {
                return false;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setSelectedFile(new File(name + ".gwd"));
            fileChooser.setDialogTitle("Specify a file to store the database");
            fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("gwd", "GlycoWorkbench dictionary file"));
            fileChooser.setCurrentDirectory(((ProfilerPlugin)this.theDocument).getWorkspace().getFileHistory().getRecentFolder());
            if (fileChooser.showSaveDialog(this) != 0) {
                return false;
            }
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            FileFilter ff = fileChooser.getFileFilter();
            if (ff != fileChooser.getAcceptAllFileFilter() && ff instanceof ExtensionFileFilter) {
                filename = FileUtils.enforceExtension((String)filename, (String)((ExtensionFileFilter)ff).getDefaultExtension());
            }
            if ((file = new File(filename)).exists() && (retValue = JOptionPane.showOptionDialog(this, "File exists. Overwrite file: " + filename + "?", "Salva documento", 1, 3, null, null, null)) != 0) {
                return false;
            }
            StructureDictionary toadd = new StructureDictionary(name);
            toadd.save(filename);
            ((ProfilerPlugin)this.theDocument).addUserDictionary(toadd);
            this.fireTableChanged();
            return true;
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            return false;
        }
    }

    public void loadUserDatabase() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Select a database file");
            fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("gwd", "GlycoWorkbench dictionary file"));
            fileChooser.setCurrentDirectory(((ProfilerPlugin)this.theDocument).getWorkspace().getFileHistory().getRecentFolder());
            if (fileChooser.showOpenDialog(this) != 0) {
                return;
            }
            String filename = fileChooser.getSelectedFile().getAbsolutePath();
            if (!FileUtils.exists((String)filename)) {
                return;
            }
            StructureDictionary toadd = new StructureDictionary(filename, true, null);
            if (((ProfilerPlugin)this.theDocument).containsDictionary(toadd)) {
                JOptionPane.showMessageDialog(this, "The database selected is already loaded.", "Duplicate database", 0);
                return;
            }
            ((ProfilerPlugin)this.theDocument).addUserDictionary(toadd);
            this.fireTableChanged();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void removeSelectedDatabase() {
        if (this.theTable.getSelectedRow() == -1) {
            return;
        }
        int retValue = JOptionPane.showOptionDialog(this, "Are you sure you want to permanently remove the user database?", "", 0, 3, null, null, null);
        if (retValue != 0) {
            return;
        }
        ((ProfilerPlugin)this.theDocument).removeDictionary(this.getSelectedDictionary());
        this.fireTableChanged();
    }

    public void editSelectedDatabase() {
        try {
            StructureDictionary selected = this.getSelectedDictionary();
            if (selected != null) {
                ((ProfilerPlugin)this.theDocument).getDictionariesEditPanel().showDictionary(selected.getDictionaryName());
                ((ProfilerPlugin)this.theDocument).show("Structures");
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("add")) {
            this.createUserDatabase();
        } else if (action.equals("open")) {
            this.loadUserDatabase();
        } else if (action.equals("delete")) {
            this.removeSelectedDatabase();
        } else if (action.equals("edit")) {
            this.editSelectedDatabase();
        } else if (action.equals("setwggdsurl")) {
            this.setWggdsUrl();
        } else if (action.equals("wggdssync")) {
            this.wggdsSync();
        } else if (action.equals("wggdsreset")) {
            this.wggdsReset();
        }
        this.updateActions();
    }

    public void wggdsReset() {
        StructureDictionary dict = this.getSelectedDictionary();
        if (dict != null) {
            try {
                dict.restore();
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
            }
        }
        dict.save();
        this.fireTableChanged();
    }

    public void setWggdsUrl() {
        StructureDictionary selected = this.getSelectedDictionary();
        boolean isGlycoWorkbenchResource = selected.isGlycoWorkbenchResource();
        String url = JOptionPane.showInputDialog(this, "Set WGGDS URI", selected.getUri());
        if (url == null || url.length() == 0) {
            return;
        }
        selected.setUri(url);
        selected.save();
        if (isGlycoWorkbenchResource) {
            ((ProfilerPlugin)this.theDocument).removeDictionary(selected);
            ((ProfilerPlugin)this.theDocument).addUserDictionary(selected);
        }
    }

    public void wggdsSync() {
        final StructureDictionary dict = this.getSelectedDictionary();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    dict.clear();
                    dict.setFireDocumentChanged(false);
                    AllStructuresQuery query = new AllStructuresQuery();
                    query.setCompleteInformation(CompleteInformation.Complete);
                    query.setFormat(OutputFormat.XML);
                    final GlycanParser glydeParser = GlycanParserFactory.getParser((String)CarbohydrateSequenceEncoding.glyde.getId());
                    QueryResultProcessor queryProc = new QueryResultProcessor(){

                        public void processStructureResult(StructureResult structureResult) {
                            if (structureResult.getBiologicalSource() == null || structureResult.getBiologicalSource().size() == 0) {
                                try {
                                    dict.add(new StructureType(glydeParser.readGlycan(structureResult.getSequence(), new MassOptions())));
                                }
                                catch (Exception e) {}
                            } else {
                                for (BiologicalContext context : structureResult.getBiologicalSource()) {
                                    try {
                                        StructureType type = new StructureType(glydeParser.readGlycan(structureResult.getSequence(), new MassOptions()));
                                        type.setSource(context.getTaxonomyName());
                                        dict.add(type);
                                    }
                                    catch (Exception ex) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                LogUtils.report((Exception)ex);
                                            }
                                        });
                                    }
                                }
                            }
                        }

                        public void processResultHeader(QueryResultHeader queryResultHeader) {
                        }

                        public void processError(final ServerSideError error) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LogUtils.report((Exception)new Exception("WGGDS upstream server error\nError code: " + error.getErrorId().getId() + "\n>Message\n" + error.getMessage()));
                                }
                            });
                        }
                    };
                    query.runQuery(dict.getUri(), queryProc);
                    dict.setHasBeenSynced(true);
                    dict.save();
                    dict.setFireDocumentChanged(true);
                }
                catch (Exception e) {
                    try {
                        LogUtils.report((Exception)e);
                        dict.setFireDocumentChanged(true);
                    }
                    catch (Throwable throwable) {
                        dict.setFireDocumentChanged(true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                dict.fireDocumentChanged();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        thread.start();
    }

    @Override
    public void dictionariesChanged(ProfilerPlugin.DictionariesChangeEvent e) {
        this.updateView();
        this.updateActions();
    }

    @Override
    public void updateData() {
    }
}

