/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.peakpicker;

import java.util.Comparator;

public class PeakShape {
    public double height;
    public double mz_position;
    public double left_width;
    public double right_width;
    public double area;
    public double r_value;
    public double signal_to_noise;
    public Type type;

    public PeakShape() {
        this.height = 0.0;
        this.mz_position = 0.0;
        this.left_width = 0.0;
        this.right_width = 0.0;
        this.area = 0.0;
        this.r_value = 0.0;
        this.signal_to_noise = 0.0;
        this.type = Type.UNDEFINED;
    }

    public PeakShape(double height_, double mz_position_, double left_width_, double right_width_, double area_, Type type_) {
        this.height = height_;
        this.mz_position = mz_position_;
        this.left_width = left_width_;
        this.right_width = right_width_;
        this.area = area_;
        this.r_value = 0.0;
        this.signal_to_noise = 0.0;
        this.type = type_;
    }

    public PeakShape clone() {
        PeakShape ret = new PeakShape();
        ret.copy(this);
        return ret;
    }

    public void copy(PeakShape peakshape) {
        this.mz_position = peakshape.mz_position;
        this.left_width = peakshape.left_width;
        this.right_width = peakshape.right_width;
        this.area = peakshape.area;
        this.r_value = peakshape.r_value;
        this.signal_to_noise = peakshape.signal_to_noise;
        this.type = peakshape.type;
    }

    public double get(double x) {
        double value = this.type == Type.LORENTZ_PEAK ? (x <= this.mz_position ? this.height / (1.0 + Math.pow(this.left_width * (x - this.mz_position), 2.0)) : this.height / (1.0 + Math.pow(this.right_width * (x - this.mz_position), 2.0))) : (this.type == Type.SECH_PEAK ? (x <= this.mz_position ? this.height / Math.pow(Math.cosh(this.left_width * (x - this.mz_position)), 2.0) : this.height / Math.pow(Math.cosh(this.right_width * (x - this.mz_position)), 2.0)) : -1.0);
        return value;
    }

    public double getSymmetricMeasure() {
        double value = this.left_width < this.right_width ? this.left_width / this.right_width : this.right_width / this.left_width;
        return value;
    }

    public double getFWHM() {
        double fwhm = 0.0;
        if (this.type == Type.LORENTZ_PEAK) {
            fwhm = 1.0 / this.right_width;
            fwhm += 1.0 / this.left_width;
        } else if (this.type == Type.SECH_PEAK) {
            double m = Math.log(Math.sqrt(2.0) + 1.0);
            fwhm = m / this.left_width;
            fwhm += m / this.right_width;
        } else {
            fwhm = -1.0;
        }
        return fwhm;
    }

    public void output() {
        System.out.println("PeakShape");
        System.out.println("\theight = " + this.height);
        System.out.println("\tmz = " + this.mz_position);
        System.out.println("\tleft_width = " + this.left_width);
        System.out.println("\tright_width = " + this.right_width);
        System.out.println("\tarea = " + this.area);
        System.out.println("\ttype = " + (Object)((Object)this.type));
    }

    public static enum Type {
        LORENTZ_PEAK,
        SECH_PEAK,
        UNDEFINED;

    }

    public class PositionLess
    implements Comparator<PeakShape> {
        private int dimension_;

        public PositionLess(int i) {
            this.dimension_ = i;
        }

        public PositionLess() {
            this.dimension_ = -1;
        }

        @Override
        public int compare(PeakShape a, PeakShape b) {
            if (a.mz_position == b.mz_position) {
                return 0;
            }
            if (a.mz_position < b.mz_position) {
                return -1;
            }
            return 1;
        }
    }
}

