/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.s3.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycoworkbench.plugin.s3.gui.AWSDevPayProductPanel;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.JHtmlLabel;

public class LoginCredentialsPanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 5819631423081597078L;
    private final Insets insetsDefault = new Insets(3, 5, 3, 5);
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private HyperlinkActivatedListener hyperlinkListener = null;
    private JTextField awsAccessKeyTextField = null;
    private JPasswordField awsSecretKeyPasswordField = null;
    private JCheckBox useDevPayCheckBox = null;
    private JTextField awsUserTokenTextField = null;
    private AWSDevPayProductPanel awsProductPanel = null;
    private JTextField friendlyNameTextField = null;
    private boolean askForFriendlyName = false;
    private Component[] awsDevPayComponents = null;

    public LoginCredentialsPanel(boolean askForFriendlyName, HyperlinkActivatedListener hyperlinkListener) {
        super(new GridBagLayout());
        this.hyperlinkListener = hyperlinkListener;
        this.askForFriendlyName = askForFriendlyName;
        this.initGui();
    }

    private void initGui() {
        String descriptionText = "<html><center>View your <a href=\"http://aws-portal.amazon.com/gp/aws/developer/account/index.html?ie=UTF8&action=access-key\" target=\"_blank\">AWS Access Identifiers</a> on Amazon's web site.<br></center></html>";
        String friendlyNameLabelText = "Nickname";
        String friendlyNameTooltipText = "A nickname for your stored account";
        String awsAccessKeyLabelText = "AWS Access Key";
        String awsAccessKeyTooltipText = "Your Amazon Web Services access key";
        String awsSecretKeyLabelText = "AWS Secret Key";
        String awsSecretKeyTooltipText = "Your Amazon Web Services secret key";
        String useDevPayButtonText = "Use DevPay";
        String awsUserTokenLabelText = "DevPay User Token";
        String awsUserTokenTooltipText = "Your DevPay user token";
        JHtmlLabel descriptionLabel = new JHtmlLabel(descriptionText, this.hyperlinkListener);
        descriptionLabel.setHorizontalAlignment(0);
        JHtmlLabel friendlyNameLabel = new JHtmlLabel(friendlyNameLabelText, this.hyperlinkListener);
        this.friendlyNameTextField = new JTextField();
        this.friendlyNameTextField.setToolTipText(friendlyNameTooltipText);
        JHtmlLabel awsAccessKeyLabel = new JHtmlLabel(awsAccessKeyLabelText, this.hyperlinkListener);
        this.awsAccessKeyTextField = new JTextField();
        this.awsAccessKeyTextField.setToolTipText(awsAccessKeyTooltipText);
        JHtmlLabel awsSecretKeyLabel = new JHtmlLabel(awsSecretKeyLabelText, this.hyperlinkListener);
        this.awsSecretKeyPasswordField = new JPasswordField();
        this.awsSecretKeyPasswordField.setToolTipText(awsSecretKeyTooltipText);
        this.useDevPayCheckBox = new JCheckBox(useDevPayButtonText);
        this.useDevPayCheckBox.setSelected(false);
        this.useDevPayCheckBox.addItemListener(this);
        JHtmlLabel awsUserTokenLabel = new JHtmlLabel(awsUserTokenLabelText, this.hyperlinkListener);
        this.awsUserTokenTextField = new JTextField();
        this.awsUserTokenTextField.setToolTipText(awsUserTokenTooltipText);
        this.awsProductPanel = new AWSDevPayProductPanel();
        int row = 0;
        this.add((Component)descriptionLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 1, this.insetsDefault, 0, 0));
        if (this.askForFriendlyName) {
            this.friendlyNameTextField.setText("My Credentials");
            this.add((Component)friendlyNameLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
            this.add((Component)this.friendlyNameTextField, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        }
        this.add((Component)awsAccessKeyLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.awsAccessKeyTextField, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)awsSecretKeyLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.awsSecretKeyPasswordField, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.useDevPayCheckBox, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)awsUserTokenLabel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.awsUserTokenTextField, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.add((Component)this.awsProductPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 10, 1, this.insetsDefault, 0, 0));
        this.awsDevPayComponents = new Component[]{awsUserTokenLabel, this.awsUserTokenTextField, this.awsProductPanel};
        for (int i = 0; i < this.awsDevPayComponents.length; ++i) {
            this.awsDevPayComponents[i].setVisible(this.useDevPayCheckBox.isSelected());
        }
        this.setPreferredSize(new Dimension(400, 350));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.useDevPayCheckBox) {
            for (int i = 0; i < this.awsDevPayComponents.length; ++i) {
                this.awsDevPayComponents[i].setVisible(this.useDevPayCheckBox.isSelected());
            }
        }
    }

    public String getAWSAccessKey() {
        return this.awsAccessKeyTextField.getText().trim();
    }

    public String getAWSSecretKey() {
        return new String(this.awsSecretKeyPasswordField.getPassword()).trim();
    }

    public boolean getUsingDevPay() {
        return this.useDevPayCheckBox.isSelected();
    }

    public String getAWSUserToken() {
        return this.awsUserTokenTextField.getText().trim();
    }

    public String getAWSProductToken() {
        return this.awsProductPanel.getAWSProductToken();
    }

    public String getFriendlyName() {
        return this.friendlyNameTextField.getText();
    }

    public String[] checkForInputErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getAWSAccessKey().length() != 20 && this.getAWSAccessKey().length() != 22) {
            errors.add("Access Key must have 20 or 22 characters");
        }
        if (this.getAWSSecretKey().length() != 40 && this.getAWSSecretKey().length() != 38) {
            errors.add("Secret Key must have 40 or 38 characters");
        }
        if (this.getUsingDevPay()) {
            if (this.getAWSUserToken().length() == 0) {
                errors.add("DevPay User Token must be provided");
            }
            if (this.getAWSProductToken().length() == 0) {
                errors.add("DevPay Product Token must be provided");
            }
        }
        return errors.toArray(new String[errors.size()]);
    }
}

