/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.datamodel;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;

public class GRITSTableDataObject {
    protected ArrayList<GRITSListDataRow> tableData = new ArrayList();
    protected ArrayList<ArrayList<GRITSColumnHeader>> headerData = new ArrayList();
    protected Hashtable<Integer, Hashtable<String, ArrayList<String>>> htHiddenRows = new Hashtable();
    protected Hashtable<Integer, ArrayList<String>> htInvisibleRows = new Hashtable();
    protected Hashtable<Integer, ArrayList<String>> htManuallyChanged = new Hashtable();
    protected Hashtable<Integer, ArrayList<String>> htLocked = new Hashtable();
    protected TableViewerPreference tablePreferences = null;
    protected String sAnalysisName = null;

    public List<GRITSColumnHeader> getLastHeader() {
        int iLastHeader = this.getTableHeader().size() - 1;
        if (iLastHeader < 0) {
            return null;
        }
        List lastHeader = this.getTableHeader().get(iLastHeader);
        return lastHeader;
    }

    public void setAnalysisName(String sAnalysisName) {
        this.sAnalysisName = sAnalysisName;
    }

    public String getAnalysisName() {
        return this.sAnalysisName;
    }

    public void initializePreferences() {
        this.setTablePreferences(TableViewerPreference.readPreference());
    }

    public void setTablePreferences(TableViewerPreference tablePreferences) {
        this.tablePreferences = tablePreferences;
    }

    public TableViewerPreference getTablePreferences() {
        return this.tablePreferences;
    }

    public Hashtable<Integer, ArrayList<String>> getInvisibleRows() {
        return this.htInvisibleRows;
    }

    public Hashtable<Integer, ArrayList<String>> getManuallyChangedPeaks() {
        return this.htManuallyChanged;
    }

    public ArrayList<GRITSListDataRow> getTableData() {
        return this.tableData;
    }

    public void setTableData(ArrayList<GRITSListDataRow> tableData) {
        this.tableData = tableData;
    }

    public ArrayList<ArrayList<GRITSColumnHeader>> getTableHeader() {
        return this.headerData;
    }

    public void setHeaderData(ArrayList<ArrayList<GRITSColumnHeader>> headerData) {
        this.headerData = headerData;
    }

    public void addInvisibleRow(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<Object> alInvisibleRows = null;
        if (!this.htInvisibleRows.containsKey(_iParentScanNum)) {
            alInvisibleRows = new ArrayList();
            this.htInvisibleRows.put(_iParentScanNum, alInvisibleRows);
        } else {
            alInvisibleRows = this.htInvisibleRows.get(_iParentScanNum);
        }
        alInvisibleRows.add(_iRowId);
    }

    public void addManuallyChangedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<Object> alManuallyChangedRows = null;
        if (!this.htManuallyChanged.containsKey(_iParentScanNum)) {
            alManuallyChangedRows = new ArrayList();
            this.htManuallyChanged.put(_iParentScanNum, alManuallyChangedRows);
        } else {
            alManuallyChangedRows = this.htManuallyChanged.get(_iParentScanNum);
        }
        alManuallyChangedRows.add(_iRowId);
    }

    public void addLockedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<Object> alLockedRows = null;
        if (!this.htLocked.containsKey(_iParentScanNum)) {
            alLockedRows = new ArrayList();
            this.htLocked.put(_iParentScanNum, alLockedRows);
        } else {
            alLockedRows = this.htLocked.get(_iParentScanNum);
        }
        alLockedRows.add(_iRowId);
    }

    public void removeInvisibleRow(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<String> alInvisibleRows = null;
        if (!this.htInvisibleRows.containsKey(_iParentScanNum)) {
            return;
        }
        alInvisibleRows = this.htInvisibleRows.get(_iParentScanNum);
        alInvisibleRows.remove(_iRowId);
    }

    public void removeManuallyChangedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<String> alManuallyChangedRows = null;
        if (!this.htManuallyChanged.containsKey(_iParentScanNum)) {
            return;
        }
        alManuallyChangedRows = this.htManuallyChanged.get(_iParentScanNum);
        alManuallyChangedRows.remove(_iRowId);
    }

    public void removeLockedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        ArrayList<String> alManuallyChangedRows = null;
        if (!this.htLocked.containsKey(_iParentScanNum)) {
            return;
        }
        alManuallyChangedRows = this.htLocked.get(_iParentScanNum);
        alManuallyChangedRows.remove(_iRowId);
    }

    public boolean isInvisibleRow(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return false;
        }
        ArrayList<String> alInvisibleRows = null;
        if (!this.htInvisibleRows.containsKey(_iParentScanNum)) {
            return false;
        }
        alInvisibleRows = this.htInvisibleRows.get(_iParentScanNum);
        return alInvisibleRows.contains(_iRowId);
    }

    public boolean isManuallyChangedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return false;
        }
        ArrayList<String> alManuallyChangedRows = null;
        if (!this.htManuallyChanged.containsKey(_iParentScanNum)) {
            return false;
        }
        alManuallyChangedRows = this.htManuallyChanged.get(_iParentScanNum);
        return alManuallyChangedRows.contains(_iRowId);
    }

    public boolean isLockedPeak(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return false;
        }
        ArrayList<String> alLockedPeaks = null;
        if (!this.htLocked.containsKey(_iParentScanNum)) {
            return false;
        }
        alLockedPeaks = this.htLocked.get(_iParentScanNum);
        return alLockedPeaks.contains(_iRowId);
    }

    public void setHiddenRow(Integer _iParentScanNum, String _iRowId, String _sFeatureId) {
        if (_iParentScanNum == null || _iRowId == null || _sFeatureId == null) {
            return;
        }
        Hashtable<Object, Object> htRowToHiddenFeatures = null;
        if (!this.htHiddenRows.containsKey(_iParentScanNum)) {
            htRowToHiddenFeatures = new Hashtable();
            this.htHiddenRows.put(_iParentScanNum, htRowToHiddenFeatures);
        } else {
            htRowToHiddenFeatures = this.htHiddenRows.get(_iParentScanNum);
        }
        ArrayList alHiddenAnnotations = null;
        if (htRowToHiddenFeatures.containsKey(_iRowId)) {
            alHiddenAnnotations = (ArrayList)htRowToHiddenFeatures.get(_iRowId);
        } else {
            alHiddenAnnotations = new ArrayList();
            htRowToHiddenFeatures.put(_iRowId, alHiddenAnnotations);
        }
        if (!alHiddenAnnotations.contains(_sFeatureId)) {
            alHiddenAnnotations.add(_sFeatureId);
        }
    }

    public void removeHiddenRow(Integer _iParentScanNum, String _iRowId, String _sFeatureId) {
        if (_iParentScanNum == null || _iRowId == null || _sFeatureId == null) {
            return;
        }
        Hashtable<String, ArrayList<String>> htRowToHiddenFeatures = null;
        if (!this.htHiddenRows.containsKey(_iParentScanNum)) {
            return;
        }
        htRowToHiddenFeatures = this.htHiddenRows.get(_iParentScanNum);
        ArrayList<String> alHiddenAnnotations = null;
        if (!htRowToHiddenFeatures.containsKey(_iRowId)) {
            return;
        }
        alHiddenAnnotations = htRowToHiddenFeatures.get(_iRowId);
        if (alHiddenAnnotations.contains(_sFeatureId)) {
            alHiddenAnnotations.remove(_sFeatureId);
        }
    }

    public void clearHiddenRows(Integer _iParentScanNum, String _iRowId) {
        if (_iParentScanNum == null || _iRowId == null) {
            return;
        }
        Hashtable<String, ArrayList<String>> htRowToHiddenFeatures = null;
        if (!this.htHiddenRows.containsKey(_iParentScanNum)) {
            return;
        }
        htRowToHiddenFeatures = this.htHiddenRows.get(_iParentScanNum);
        ArrayList<String> alHiddenAnnotations = null;
        if (!htRowToHiddenFeatures.containsKey(_iRowId)) {
            return;
        }
        alHiddenAnnotations = htRowToHiddenFeatures.get(_iRowId);
        alHiddenAnnotations.clear();
    }

    public boolean isHiddenRow(Integer _iParentScanNum, String _iRowId, String _sFeatureId) {
        Hashtable<String, ArrayList<String>> htRowToHiddenFeatures = null;
        if (!this.htHiddenRows.containsKey(_iParentScanNum)) {
            return false;
        }
        htRowToHiddenFeatures = this.htHiddenRows.get(_iParentScanNum);
        ArrayList<String> alHiddenAnnotations = null;
        if (!htRowToHiddenFeatures.containsKey(_iRowId)) {
            return false;
        }
        alHiddenAnnotations = htRowToHiddenFeatures.get(_iRowId);
        return alHiddenAnnotations.contains(_sFeatureId);
    }

    public Hashtable<Integer, Hashtable<String, ArrayList<String>>> getHtHiddenRows() {
        return this.htHiddenRows;
    }

    public Hashtable<Integer, ArrayList<String>> getHtLocked() {
        return this.htLocked;
    }
}

