/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.tablecore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.grits.toolbox.display.control.table.dialog.GRITSColumnEntry;
import org.grits.toolbox.display.control.table.tablecore.GRITSColumnHeaderDataProvider;

public class GRITSColumnChooserUtils {
    public static List<ColumnEntry> getHiddenColumnEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        Collection hiddenColumnIndexes = columnHideShowLayer.getHiddenColumnIndexes();
        ArrayList<ColumnEntry> hiddenColumnEntries = new ArrayList<ColumnEntry>();
        for (Integer hiddenColumnIndex : hiddenColumnIndexes) {
            String sKey = GRITSColumnChooserUtils.getColumnKey(columnHeaderLayer, columnHeaderDataLayer, hiddenColumnIndex);
            String sLabel = ColumnChooserUtils.getColumnLabel((ColumnHeaderLayer)columnHeaderLayer, (DataLayer)columnHeaderDataLayer, (Integer)hiddenColumnIndex);
            GRITSColumnEntry columnEntry = new GRITSColumnEntry(sKey, sLabel, hiddenColumnIndex, -1);
            hiddenColumnEntries.add(columnEntry);
        }
        return hiddenColumnEntries;
    }

    public static String getColumnKey(ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, Integer columnIndex) {
        int position = columnHeaderDataLayer.getColumnPositionByIndex(columnIndex.intValue());
        String sKey = ((GRITSColumnHeaderDataProvider)columnHeaderDataLayer.getDataProvider()).getDataKey(position, 0);
        return sKey;
    }

    public static List<ColumnEntry> getVisibleColumnsEntries(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer) {
        int visibleColumnCount = columnHideShowLayer.getColumnCount();
        ArrayList<ColumnEntry> visibleColumnEntries = new ArrayList<ColumnEntry>();
        int i = 0;
        while (i < visibleColumnCount) {
            int index = columnHideShowLayer.getColumnIndexByPosition(i);
            String sKey = GRITSColumnChooserUtils.getColumnKey(columnHeaderLayer, columnHeaderDataLayer, index);
            String sLabel = ColumnChooserUtils.getColumnLabel((ColumnHeaderLayer)columnHeaderLayer, (DataLayer)columnHeaderDataLayer, (Integer)index);
            GRITSColumnEntry columnEntry = new GRITSColumnEntry(sKey, sLabel, index, i);
            visibleColumnEntries.add(columnEntry);
            ++i;
        }
        return visibleColumnEntries;
    }
}

