/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon.MSGlycanAnnotationCartoonPreferences;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationEntityScroller;
import org.grits.toolbox.utils.data.CartoonOptions;
import org.grits.toolbox.utils.image.GlycanImageProvider;
import org.grits.toolbox.widgets.tools.IGRITSEventListener;

public class MSGlycanAnnotationFigureCanvas
extends FigureCanvas
implements IGRITSEventListener {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationFigureCanvas.class);
    ImageFigure iFig = null;
    protected String glycanKey = null;
    protected MSGlycanAnnotationCartoonPreferences preference = null;
    protected List<GlycanImageProvider.GlycanImageObject> imageList;
    protected GlycanImageProvider.GlycanImageObject image = null;

    public MSGlycanAnnotationFigureCanvas(Composite parent, int style, CartoonOptions cartoonOptions) {
        super(parent, style);
        this.initializeCanvas();
        MSGlycanAnnotationTableDataObject.glycanImageProvider.setCartoonOptions(cartoonOptions);
        this.imageList = new ArrayList<GlycanImageProvider.GlycanImageObject>();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MSGlycanAnnotationFigureCanvas.this.removeListener();
            }
        });
    }

    public void updateCartoonOptions(CartoonOptions cartoonOptions) {
        MSGlycanAnnotationTableDataObject.glycanImageProvider.setCartoonOptions(cartoonOptions);
    }

    private void initializeCanvas() {
        this.setViewport(new Viewport(true));
        this.setScrollBarVisibility(FigureCanvas.AUTOMATIC);
        this.setBackground(new Color((Device)this.getShell().getDisplay(), 255, 255, 255));
    }

    public void updateGlycan(String sequence) {
        this.glycanKey = sequence;
    }

    public void setGlycans(List<String> sequences, MSAnnotationEntityScroller scroller) {
        try {
            scroller.setMaxHeight(0);
            scroller.setMaxWidth(0);
            if (this.imageList == null) {
                this.imageList = new ArrayList<GlycanImageProvider.GlycanImageObject>();
            } else {
                this.imageList.clear();
            }
            Iterator<String> iterator = sequences.iterator();
            while (iterator.hasNext()) {
                GlycanImageProvider.GlycanImageObject gio;
                String sequence;
                this.glycanKey = sequence = iterator.next();
                double dMaxScale = MSGlycanAnnotationTableDataObject.glycanImageProvider.getCartoonOptions().getImageScaleFactor() > 1.0 ? 1.0 : MSGlycanAnnotationTableDataObject.glycanImageProvider.getCartoonOptions().getImageScaleFactor();
                MSGlycanAnnotationTableDataObject.glycanImageProvider.getCartoonOptions().setImageScaleFactor(Double.valueOf(dMaxScale));
                this.image = gio = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(sequence);
                if (this.image.getSwtImage().getBounds().width > scroller.getMaxWidth()) {
                    scroller.setMaxWidth(this.image.getSwtImage().getBounds().width);
                }
                if (this.image.getSwtImage().getBounds().height > scroller.getMaxHeight()) {
                    scroller.setMaxHeight(this.image.getSwtImage().getBounds().height);
                }
                this.imageList.add(gio);
            }
            MSGlycanAnnotationTableDataObject.glycanImageProvider.addEventListener((IGRITSEventListener)this);
        }
        catch (Exception e) {
            logger.info((Object)"Exception in MSGlycanAnnotationFigureCanvas.createGlycanFromSequence.", (Throwable)e);
        }
    }

    public void drawImage() {
        if (this.iFig == null) {
            this.iFig = new ImageFigure(this.image.getSwtImage());
            this.setContents((IFigure)this.iFig);
        } else {
            this.iFig.setImage(this.image.getSwtImage());
        }
        this.redraw();
    }

    public void updateImage() {
        boolean bAddListener = this.image == null;
        this.image = null;
        try {
            this.image = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(this.glycanKey);
            this.image.setIsOriginalSize(false);
        }
        catch (Exception e) {
            logger.error((Object)"Exception in MSGlycanAnnotationFigureCanvas.updateImage", (Throwable)e);
        }
        if (bAddListener && this.image != null) {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    MSGlycanAnnotationFigureCanvas.this.setContents((IFigure)new ImageFigure(MSGlycanAnnotationFigureCanvas.this.image.getSwtImage()));
                }
            });
        }
    }

    public void updateImage(int _iImageNum) {
        boolean bAddListener = this.image == null;
        this.image = null;
        try {
            this.image = this.imageList.get(_iImageNum);
        }
        catch (Exception e) {
            logger.error((Object)"Exception in MSGlycanAnnotationFigureCanvas.updateImage", (Throwable)e);
        }
        if (bAddListener && this.image != null) {
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    MSGlycanAnnotationFigureCanvas.this.setContents((IFigure)new ImageFigure(MSGlycanAnnotationFigureCanvas.this.image.getSwtImage()));
                }
            });
        }
    }

    public void handleEvent(int arg0) {
        this.drawImage();
    }

    protected void removeListener() {
        MSGlycanAnnotationTableDataObject.glycanImageProvider.removeEventListener((IGRITSEventListener)this);
    }
}

