/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

public enum Ringtype {
    PYRANOSE(6, "pyranose", "p", "p"),
    FURANOSE(5, "furanose", "f", "f"),
    OPEN(0, "open chain", "", "a"),
    UNKNOWN(-1, "unknown", "", "?");

    private int size;
    private String name;
    private String carbbankSymbol;
    private String bcsdbSymbol;

    private Ringtype(int rtSize, String rtName, String rtCarbbankSymbol, String rtBcsdbSymbol) {
        this.setSize(rtSize);
        this.setName(rtName);
        this.setCarbbankSymbol(rtCarbbankSymbol);
        this.setBcsdbSymbol(rtBcsdbSymbol);
    }

    public String getCarbbankSymbol() {
        return this.carbbankSymbol;
    }

    private void setCarbbankSymbol(String carbbankSymbol) {
        this.carbbankSymbol = carbbankSymbol;
    }

    public String getBcsdbSymbol() {
        return this.bcsdbSymbol;
    }

    public void setBcsdbSymbol(String bcsdbSymbol) {
        this.bcsdbSymbol = bcsdbSymbol;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public static Ringtype forSize(int size) {
        for (Ringtype r : Ringtype.values()) {
            if (r.getSize() != size) continue;
            return r;
        }
        return null;
    }

    public static Ringtype forCarbbankSymbol(String sym) {
        for (Ringtype r : Ringtype.values()) {
            if (!r.getCarbbankSymbol().equals(sym)) continue;
            return r;
        }
        return null;
    }

    public static Ringtype forBcsdbSymbol(String sym) {
        for (Ringtype r : Ringtype.values()) {
            if (!r.getBcsdbSymbol().equals(sym)) continue;
            return r;
        }
        return null;
    }
}

