/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.report.property;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.property.ReportsProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.ImageRegistry;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.datamodel.MSGlycanAnnotationReportMetaData;
import org.grits.toolbox.entry.ms.annotation.glycan.report.property.io.MSGlycanAnnotationReportPropertyWriter;

public class MSGlycanAnnotationReportProperty
extends Property {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationReportProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.report.ms_annotation_merge";
    protected static PropertyWriter writer = new MSGlycanAnnotationReportPropertyWriter();
    public static final String ARCHIVE_FOLDER = "merge";
    public static final String ARCHIVE_EXTENSION = ".xml";
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor((String)"org.grits.toolbox.entry.ms.annotation.glycan.report", (ImageRegistry.MSImage)ImageRegistry.MSImage.MSMERGE_ICON);
    private static final String META_DATA_FILE = "msGlycanAnnotReportMetaData.xml";
    private MSGlycanAnnotationReportMetaData msGlycanAnnotReportMetaData = null;

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    public MSGlycanAnnotationReportMetaData getMsGlycanAnnotReportMetaData() {
        return this.msGlycanAnnotReportMetaData;
    }

    public void setMsGlycanAnnotReportMetaData(MSGlycanAnnotationReportMetaData msGlycanAnnotReportMetaData) {
        this.msGlycanAnnotReportMetaData = msGlycanAnnotReportMetaData;
    }

    public static PropertyDataFile getNewSettingsFile(String msAnnotDetails, MSGlycanAnnotationReportMetaData metaData) {
        PropertyDataFile msMetaData = new PropertyDataFile(msAnnotDetails, metaData.getVersion(), "details");
        return msMetaData;
    }

    public void adjustPropertyFilePaths() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                file.setName(file.getName().replace("\\", File.separator));
                continue;
            }
            if (!file.getName().contains("/") || File.separator.equals("/")) continue;
            file.setName(file.getName().replace("/", File.separator));
        }
    }

    public PropertyDataFile getMetaDataFile() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (!file.getType().equals("details")) continue;
            return file;
        }
        return null;
    }

    public static MSGlycanAnnotationReportMetaData unmarshallSettingsFile(String sFileName) {
        MSGlycanAnnotationReportMetaData metaData = null;
        try {
            metaData = (MSGlycanAnnotationReportMetaData)XMLUtils.unmarshalObjectXML((String)sFileName, MSGlycanAnnotationReportMetaData.class);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return metaData;
    }

    public static void marshallSettingsFile(String sFileName, MSGlycanAnnotationReportMetaData metaData) {
        try {
            String xmlString = XMLUtils.marshalObjectXML((Object)metaData);
            FileWriter fileWriter = new FileWriter(sFileName);
            fileWriter.write(xmlString);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void delete(Entry entry) throws IOException {
        try {
            String reportFolder = this.getFullyQualifiedReportsFolder(entry);
            for (PropertyDataFile pdf : this.getDataFiles()) {
                String sFile = String.valueOf(reportFolder) + File.separator + pdf.getName();
                File f = new File(sFile);
                DeleteUtils.delete((File)f);
            }
            String entryFolder = this.getFullyQualifiedReportsFolderName(entry);
            DeleteUtils.delete((File)new File(entryFolder));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private String getFullyQualifiedReportsFolder(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String folder = String.valueOf(workspaceLocation) + projectName + File.separator + ReportsProperty.getFolder() + File.separator + this.getArchiveFolder();
        return folder;
    }

    public String getFullyQualifiedReportsFolderName(Entry entry) {
        String folder = this.getFullyQualifiedReportsFolder(entry);
        String file = String.valueOf(folder) + File.separator + this.getMsGlycanAnnotReportMetaData().getReportId();
        return file;
    }

    public String getFullyQualifiedMetaDataFileName(Entry entry) {
        String folder = this.getFullyQualifiedReportsFolder(entry);
        String file = String.valueOf(folder) + File.separator + this.getMsGlycanAnnotReportMetaData().getReportId() + File.separator + this.getMetaDataFileName();
        return file;
    }

    public String getFullyQualifiedXMLFileName(Entry entry) {
        String folder = this.getFullyQualifiedReportsFolder(entry);
        String file = String.valueOf(folder) + File.separator + this.getMsGlycanAnnotReportMetaData().getReportId() + File.separator + this.getArchiveFile();
        return file;
    }

    public String getArchiveFile() {
        return String.valueOf(this.getMsGlycanAnnotReportMetaData().getReportId()) + ARCHIVE_EXTENSION;
    }

    public String getArchiveExtension() {
        return ARCHIVE_EXTENSION;
    }

    public String getArchiveFolder() {
        return ARCHIVE_FOLDER;
    }

    public String getMetaDataFileName() {
        return String.valueOf(this.getMsGlycanAnnotReportMetaData().getReportId()) + "." + META_DATA_FILE;
    }

    public static String getRandomId() {
        Random random = new Random();
        return Integer.valueOf(random.nextInt(10000)).toString();
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }
}

