/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FragmentGroup {
    private Vector<Vector<FragmentEntry>> fragments = new Vector();

    public Vector<Vector<FragmentEntry>> getFragmentEntries() {
        return this.fragments;
    }

    public Vector<FragmentEntry> getFragmentEntries(int s_ind) {
        return this.fragments.elementAt(s_ind);
    }

    public Vector<Glycan> getFragments(int s_ind) {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (FragmentEntry fe : this.fragments.elementAt(s_ind)) {
            ret.add(fe.fragment);
        }
        return ret;
    }

    public boolean isEmpty() {
        for (Vector<FragmentEntry> vfe : this.fragments) {
            if (vfe.size() <= 0) continue;
            return false;
        }
        return true;
    }

    public void assertSize(int s_ind) {
        while (this.fragments.size() <= s_ind) {
            this.fragments.add(new Vector());
        }
    }

    public void addFragment(int s_ind, FragmentEntry fe) {
        this.assertSize(s_ind);
        this.fragments.elementAt(s_ind).add(fe);
    }

    public void removeFragments(int s_ind) {
        this.fragments.removeElementAt(s_ind);
    }

    public void removeFragment(int s_ind, FragmentEntry fe) {
        if (s_ind >= this.fragments.size()) {
            return;
        }
        Vector<FragmentEntry> vfe = this.fragments.elementAt(s_ind);
        for (int i = 0; i < vfe.size(); ++i) {
            if (!vfe.elementAt(i).equals(fe)) continue;
            vfe.removeElementAt(i);
            return;
        }
    }
}

