/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;

public class ShowPreviousValuesDialog
extends Dialog {
    protected static final Double NULLVALUE = 50.0;
    Point location;
    Map<Integer, List<CtHistory>> previousValuesMap;
    private Text runIdText;
    private TableViewer tableViewer;

    public ShowPreviousValuesDialog(Shell parentShell, Point curLoc, HashMap<Integer, List<CtHistory>> previousValuesMap2) {
        super(parentShell);
        this.location = curLoc;
        this.previousValuesMap = previousValuesMap2;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 0);
        container.getShell().setText("Previous Values");
        GridData containerData = new GridData(4, 4, false, false);
        containerData.widthHint = 200;
        container.setLayoutData((Object)containerData);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        for (Integer runId : this.previousValuesMap.keySet()) {
            Label label = new Label(container, 0);
            label.setText("Run Id");
            label.setLayoutData((Object)new GridData(32));
            this.runIdText = new Text(container, 2060);
            GridData searchFieldTextGridData = new GridData(256);
            searchFieldTextGridData.grabExcessHorizontalSpace = true;
            this.runIdText.setLayoutData((Object)searchFieldTextGridData);
            this.runIdText.setText("" + runId);
            Label label2 = new Label(container, 0);
            label2.setText("All Values");
            label2.setLayoutData((Object)new GridData(32));
            this.tableViewer = new TableViewer(container, 2816);
            GridData tableViewertGridData = new GridData(256);
            tableViewertGridData.grabExcessHorizontalSpace = true;
            tableViewertGridData.heightHint = 50;
            this.tableViewer.getTable().setLayoutData((Object)tableViewertGridData);
            this.tableViewer.getTable().setHeaderVisible(true);
            this.tableViewer.getTable().setLinesVisible(true);
            TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
            valueColumn.getColumn().setText("Value");
            valueColumn.getColumn().setWidth(50);
            valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof CtHistory) {
                        if (((CtHistory)element).getCt() == null) {
                            return "null";
                        }
                        return ((CtHistory)element).getCt().toString();
                    }
                    return "";
                }
            });
            TableViewerColumn reasonColumn = new TableViewerColumn(this.tableViewer, 0);
            reasonColumn.getColumn().setText("Reason");
            reasonColumn.getColumn().setWidth(100);
            reasonColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof CtHistory) {
                        return ((CtHistory)element).getReasonCode();
                    }
                    return "";
                }
            });
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof List && inputElement != null) {
                        Object[] contents = new CtHistory[((List)inputElement).size()];
                        int i = 0;
                        for (CtHistory value : (List)inputElement) {
                            contents[i++] = value;
                        }
                        return contents;
                    }
                    return super.getElements(inputElement);
                }
            });
            this.tableViewer.setInput(this.previousValuesMap.get(runId));
        }
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.location;
    }
}

