/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.xml.GeneDataMapAdapter;
import org.grits.toolbox.entry.qrtpcr.model.xml.IntegerDoubleMapAdapter;

@XmlRootElement(name="gene")
public class Gene
extends TableData
implements Comparable<Gene> {
    Integer runId = -1;
    List<Integer> geneIds;
    String geneIdentifier;
    String fullName;
    String geneSymbol;
    String forwardPrimer;
    String reversePrimer;
    List<String> refSeq;
    List<String> secondaryRefSeq;
    List<String> locations;
    List<String> aliases;
    String description;
    String group;
    String notes;
    Map<Integer, List<GeneData>> dataMap;
    Integer numOfReplicates;
    Boolean isControl = false;
    Boolean isCommon = false;
    Boolean shouldRerun = false;
    Boolean reRun = false;
    Map<Integer, Double> normValueMap;

    @XmlAttribute
    public Integer getRunId() {
        return this.runId;
    }

    public void setRunId(Integer runId) {
        this.runId = runId;
    }

    @XmlAttribute
    @XmlID
    public String getGeneIdentifier() {
        return this.geneIdentifier;
    }

    public void setGeneIdentifier(String geneIdentifier) {
        this.geneIdentifier = geneIdentifier;
    }

    @XmlAttribute
    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public void setGeneSymbol(String geneSymbol) {
        this.geneSymbol = geneSymbol;
    }

    @XmlElement
    public String getForwardPrimer() {
        return this.forwardPrimer;
    }

    public void setForwardPrimer(String forwardPrimer) {
        this.forwardPrimer = forwardPrimer;
    }

    @XmlElement
    public String getReversePrimer() {
        return this.reversePrimer;
    }

    public void setReversePrimer(String reversePrimer) {
        this.reversePrimer = reversePrimer;
    }

    @XmlElement
    public List<String> getRefSeq() {
        return this.refSeq;
    }

    public void setRefSeq(List<String> refSeq) {
        this.refSeq = refSeq;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @XmlJavaTypeAdapter(value=GeneDataMapAdapter.class)
    public Map<Integer, List<GeneData>> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<Integer, List<GeneData>> data) {
        this.dataMap = data;
    }

    @XmlAttribute
    public Boolean getShouldRerun() {
        return this.shouldRerun;
    }

    public void setShouldRerun(Boolean shouldRerun) {
        this.shouldRerun = shouldRerun;
    }

    @XmlAttribute
    public Boolean getReRun() {
        return this.reRun;
    }

    public void setReRun(Boolean isReRun) {
        this.reRun = isReRun;
    }

    public List<Integer> getGeneIds() {
        return this.geneIds;
    }

    public void setGeneIds(List<Integer> geneIds) {
        this.geneIds = geneIds;
    }

    public void addGeneId(Integer id) {
        if (this.geneIds == null) {
            this.geneIds = new ArrayList<Integer>();
        }
        this.geneIds.add(id);
    }

    @XmlJavaTypeAdapter(value=IntegerDoubleMapAdapter.class)
    public Map<Integer, Double> getNormValueMap() {
        return this.normValueMap;
    }

    public void setNormValueMap(Map<Integer, Double> normValueMap) {
        this.normValueMap = normValueMap;
    }

    public void addRefSeq(String refSeq) {
        if (this.refSeq == null) {
            this.refSeq = new ArrayList<String>();
        }
        this.refSeq.add(refSeq);
    }

    public void addGeneDataList(List<GeneData> geneData) {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<Integer, List<GeneData>>();
        }
        this.runId = this.runId + 1;
        this.dataMap.put(this.runId, geneData);
    }

    public Boolean getIsControl() {
        return this.isControl;
    }

    public void setIsControl(Boolean isControl) {
        this.isControl = isControl;
    }

    public Boolean getIsCommon() {
        return this.isCommon;
    }

    public void setIsCommon(Boolean isCommon) {
        this.isCommon = isCommon;
    }

    public Integer getNumOfReplicates() {
        return this.numOfReplicates;
    }

    public void setNumOfReplicates(Integer numOfReplicates) {
        this.numOfReplicates = numOfReplicates;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public double getStandardDeviation(int runId, double lowerThreshold) {
        return Gene.getStandardDeviation(this.dataMap.get(runId), lowerThreshold);
    }

    public double getStandardDeviation(int runId, double lowerThreshold, boolean original) {
        return Gene.getStandardDeviation(this.dataMap.get(runId), lowerThreshold, original);
    }

    public double getStandardDeviation(double lowerThreshold) {
        return Gene.getStandardDeviation(this.dataMap.get(this.runId), lowerThreshold);
    }

    public static double getStandardDeviation(List<GeneData> data, double lowerThreshold) {
        return Gene.getStandardDeviation(data, lowerThreshold, false);
    }

    public static double getStandardDeviation(List<GeneData> data, double lowerThreshold, boolean original) {
        double average = 0.0;
        int total = 0;
        for (GeneData geneData : data) {
            if (geneData.isEliminated().booleanValue()) continue;
            Double ct = null;
            ct = original ? geneData.getOriginalCt() : geneData.getCt();
            average = ct == null || ct >= lowerThreshold ? (average += lowerThreshold) : (average += ct.doubleValue());
            ++total;
        }
        average /= (double)total;
        double[] deviations = new double[total];
        int i = 0;
        for (GeneData geneData : data) {
            if (geneData.isEliminated().booleanValue()) continue;
            Double ct = null;
            ct = original ? geneData.getOriginalCt() : geneData.getCt();
            if (ct == null || ct >= lowerThreshold) {
                deviations[i++] = Math.pow(lowerThreshold - average, 2.0);
                continue;
            }
            if (ct == null) continue;
            deviations[i++] = Math.pow(ct - average, 2.0);
        }
        double variance = 0.0;
        int j = 0;
        while (j < deviations.length) {
            variance += deviations[j];
            ++j;
        }
        if (total > 1) {
            variance /= (double)(total - 1);
        }
        return Math.sqrt(variance);
    }

    public void checkAndMarkForRerun(Integer runId, double lowerThreshold, Double stDevCutoff) {
        if (this.getStandardDeviation(runId, lowerThreshold) >= stDevCutoff) {
            boolean[] valueAboveThreshold = new boolean[this.numOfReplicates.intValue()];
            int i = 0;
            while (i < this.numOfReplicates) {
                valueAboveThreshold[i] = true;
                ++i;
            }
            i = 0;
            for (GeneData geneData : this.dataMap.get(runId)) {
                if (geneData.isEliminated().booleanValue() || geneData.getCt() == null || !(geneData.getCt() < lowerThreshold)) continue;
                if (i >= this.numOfReplicates) {
                    throw new RuntimeException("'Number of Replicates' do not match with the actual replicates of data. Please check your plate layout!");
                }
                valueAboveThreshold[i++] = false;
            }
            int totalAbove = 0;
            i = 0;
            while (i < this.numOfReplicates) {
                if (valueAboveThreshold[i]) {
                    ++totalAbove;
                }
                ++i;
            }
            if (totalAbove == this.numOfReplicates - 1) {
                this.shouldRerun = true;
            }
        }
    }

    public Double getAdjustedAverage(int runId, Double lowerThreshold, Double normValue) {
        return this.getAdjustedAverage(runId, false, lowerThreshold, normValue);
    }

    public Double getAdjustedAverage(int runId, boolean original, Double lowerThreshold, Double normValue) {
        Double average = 0.0;
        int i = 0;
        for (GeneData geneData : this.dataMap.get(runId)) {
            Double adj;
            if (geneData.isEliminated().booleanValue() || (adj = geneData.getAdjustedValue(runId, original, lowerThreshold, normValue)) == null) continue;
            average = average + adj;
            ++i;
        }
        if ((average = Double.valueOf(average / (double)i)) == 0.0) {
            return null;
        }
        return average;
    }

    public Double getStDevForAdjusted(int runIda, Double lowerThreshold, Double normValue) {
        return this.getStDevForAdjusted(this.runId, false, lowerThreshold, normValue);
    }

    public Double getStDevForAdjusted(int runId, boolean original, Double lowerThreshold, Double normValue) {
        int total = 0;
        Double average = 0.0;
        for (GeneData geneData : this.dataMap.get(runId)) {
            Double adj;
            if (geneData.isEliminated().booleanValue() || (adj = geneData.getAdjustedValue(runId, original, lowerThreshold, normValue)) == null) continue;
            average = average + adj;
            ++total;
        }
        if ((average = Double.valueOf(average / (double)total)) == 0.0) {
            return null;
        }
        double[] deviations = new double[total];
        int i = 0;
        for (GeneData geneData : this.dataMap.get(runId)) {
            Double adj;
            if (geneData.isEliminated().booleanValue() || (adj = geneData.getAdjustedValue(runId, original, lowerThreshold, normValue)) == null) continue;
            deviations[i++] = Math.pow(adj - average, 2.0);
        }
        double variance = 0.0;
        int j = 0;
        while (j < deviations.length) {
            variance += deviations[j];
            ++j;
        }
        if (total > 1) {
            variance /= (double)(total - 1);
        }
        return Math.sqrt(variance);
    }

    public String toString() {
        if (this.geneIdentifier != null) {
            return this.geneIdentifier;
        }
        return super.toString();
    }

    public void setNormValue(Integer runId, Double normValue) {
        if (this.normValueMap == null) {
            this.normValueMap = new HashMap<Integer, Double>();
        }
        this.normValueMap.put(runId, normValue);
    }

    public Double getNormValue(Integer runId) {
        if (this.normValueMap != null) {
            return this.normValueMap.get(runId);
        }
        return null;
    }

    public double getScaler(Integer runId, Double lowerThreshold, Double normValue) {
        return Math.pow(2.0, -1.0 * lowerThreshold) / normValue - 1.0E-6;
    }

    public String getRefSeqString() {
        int lastComma;
        if (this.refSeq == null) {
            return "";
        }
        StringBuffer refSeqString = new StringBuffer();
        for (String refSeqNo : this.refSeq) {
            if (refSeqNo == null || refSeqNo.trim().length() == 0) continue;
            refSeqString.append(refSeqNo);
            refSeqString.append(",");
        }
        if (refSeqString.length() > 0 && (lastComma = refSeqString.lastIndexOf(",")) != -1) {
            refSeqString = new StringBuffer(refSeqString.substring(0, lastComma));
        }
        return refSeqString.toString();
    }

    public List<String> getSecondaryRefSeq() {
        return this.secondaryRefSeq;
    }

    public void setSecondaryRefSeq(List<String> secondaryRefSeq) {
        this.secondaryRefSeq = secondaryRefSeq;
    }

    public String getSecondaryRefSeqString() {
        int lastComma;
        if (this.secondaryRefSeq == null) {
            return "";
        }
        StringBuffer refSeqString = new StringBuffer();
        for (String refSeqNo : this.secondaryRefSeq) {
            if (refSeqNo == null || refSeqNo.trim().length() == 0) continue;
            refSeqString.append(refSeqNo);
            refSeqString.append(",");
        }
        if (refSeqString.length() > 0 && (lastComma = refSeqString.lastIndexOf(",")) != -1) {
            refSeqString = new StringBuffer(refSeqString.substring(0, lastComma));
        }
        return refSeqString.toString();
    }

    public void setRefSeq(String refSeqString) {
        String[] refSeqNumbers;
        this.refSeq = new ArrayList<String>();
        String splitChar = ",";
        if (refSeqString.contains("/")) {
            splitChar = "/";
        }
        String[] stringArray = refSeqNumbers = refSeqString.split(splitChar);
        int n = refSeqNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String refSeqNo = stringArray[n2];
            this.refSeq.add(refSeqNo);
            ++n2;
        }
    }

    public void setGeneIds(String geneIdString) {
        String[] geneIdNumbers;
        this.geneIds = new ArrayList<Integer>();
        String splitChar = ",";
        if (geneIdString.contains("/")) {
            splitChar = "/";
        }
        String[] stringArray = geneIdNumbers = geneIdString.split(splitChar);
        int n = geneIdNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String geneId = stringArray[n2];
            try {
                this.geneIds.add(Integer.parseInt(geneId.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                Logger.getLogger(this.getClass()).warn((Object)"Gene Id is not a valid integer");
            }
            ++n2;
        }
    }

    public String getGeneIdString() {
        int lastComma;
        if (this.geneIds == null) {
            return "";
        }
        StringBuffer geneIdString = new StringBuffer();
        for (Integer geneId : this.geneIds) {
            if (geneId == null) continue;
            geneIdString.append("" + geneId);
            geneIdString.append(",");
        }
        if (geneIdString.length() > 0 && (lastComma = geneIdString.lastIndexOf(",")) != -1) {
            geneIdString = new StringBuffer(geneIdString.substring(0, lastComma));
        }
        return geneIdString.toString();
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void addAlias(String value) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        if (!this.aliases.contains(value)) {
            this.aliases.add(value);
        }
    }

    public void setAliasString(String aliasString) {
        String[] aliasList;
        this.aliases = new ArrayList<String>();
        String splitChar = ",";
        if (aliasString.contains("/")) {
            splitChar = "/";
        }
        String[] stringArray = aliasList = aliasString.split(splitChar);
        int n = aliasList.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            this.aliases.add(alias);
            ++n2;
        }
    }

    @XmlTransient
    public String getAliasString() {
        int lastComma;
        if (this.aliases == null) {
            return "";
        }
        StringBuffer aliasString = new StringBuffer();
        for (String alias : this.aliases) {
            if (alias == null || alias.trim().length() == 0) continue;
            aliasString.append(alias);
            aliasString.append(",");
        }
        if (aliasString.length() > 0 && (lastComma = aliasString.lastIndexOf(",")) != -1) {
            aliasString = new StringBuffer(aliasString.substring(0, lastComma));
        }
        return aliasString.toString();
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    @XmlTransient
    public String getLocationString() {
        int lastComma;
        if (this.locations == null) {
            return "";
        }
        StringBuffer locationString = new StringBuffer();
        for (String location : this.locations) {
            if (location == null || location.trim().length() == 0) continue;
            locationString.append(location);
            locationString.append(",");
        }
        if (locationString.length() > 0 && (lastComma = locationString.lastIndexOf(",")) != -1) {
            locationString = new StringBuffer(locationString.substring(0, lastComma));
        }
        return locationString.toString();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setLocationString(String text) {
        String[] locationList;
        this.locations = new ArrayList<String>();
        String splitChar = ",";
        if (text.contains("/")) {
            splitChar = "/";
        }
        String[] stringArray = locationList = text.split(splitChar);
        int n = locationList.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            this.locations.add(location);
            ++n2;
        }
    }

    public void setSecondaryRefSeq(String refSeqString) {
        String[] refSeqNumbers;
        this.secondaryRefSeq = new ArrayList<String>();
        String splitChar = ",";
        if (refSeqString.contains("/")) {
            splitChar = "/";
        }
        String[] stringArray = refSeqNumbers = refSeqString.split(splitChar);
        int n = refSeqNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String refSeqNo = stringArray[n2];
            this.secondaryRefSeq.add(refSeqNo);
            ++n2;
        }
    }

    @Override
    public int compareTo(Gene o) {
        int c = 0;
        if (this.dataMap != null && this.dataMap.size() > 0 && o.dataMap != null && o.dataMap.size() > 0) {
            c = this.dataMap.get(0).get(0).compareTo(o.getDataMap().get(0).get(0));
        }
        return c;
    }
}

