/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.property;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.ImageRegistry;
import org.grits.toolbox.entry.qrtpcr.commands.CreateQrtPCRDataTable;
import org.grits.toolbox.entry.qrtpcr.property.QrtPCRPropertyWriter;

public class QrtPCRProperty
extends Property {
    private static final Logger logger = Logger.getLogger(QrtPCRProperty.class);
    public static final String TYPE = "org.grits.toolbox.property.qrtpcr";
    protected static PropertyWriter writer = new QrtPCRPropertyWriter();
    protected static ImageDescriptor imageDescriptor = ImageRegistry.getImageDescriptor(ImageRegistry.QrtPCRImage.PLUGIN_ICON);

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return imageDescriptor;
    }

    private static String getQrtPCRLocation(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String experimentGroupFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
        return experimentGroupFolderLocation;
    }

    public void delete(Entry entry) throws IOException {
        String fileLocation = String.valueOf(QrtPCRProperty.getQrtPCRLocation(entry)) + File.separator + this.getFilename();
        try {
            DeleteUtils.delete((File)new File(fileLocation));
        }
        catch (IOException e) {
            ErrorUtils.createErrorMessageBox((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot delete qrtPCR data", (Exception)e);
            logger.error((Object)"org.grits.toolbox.entry.qrtpcr Cannot delete qrtPCR data", (Throwable)e);
        }
    }

    public Object clone() {
        return null;
    }

    public Property getParentProperty() {
        return null;
    }

    public String getFilename() {
        return this.getFile().getName();
    }

    public void setFilename(String filename) {
        this.dataFiles = new ArrayList();
        this.dataFiles.add(new PropertyDataFile(filename));
    }

    public PropertyDataFile getFile() {
        PropertyDataFile qrtpcrFile = null;
        for (PropertyDataFile dataFile : this.dataFiles) {
            if (!"default".equals(dataFile.getType())) continue;
            qrtpcrFile = dataFile;
            break;
        }
        return qrtpcrFile;
    }

    public void makeACopy(Entry currentEntry, Entry destinationEntry) throws IOException {
        try {
            File destinationFolder;
            File currentQrtPCRFile = new File(QrtPCRProperty.getQrtPCRLocation(currentEntry), this.getFilename());
            if (currentQrtPCRFile.exists()) {
                destinationFolder = new File(QrtPCRProperty.getQrtPCRLocation(destinationEntry.getParent()));
                if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
                    destinationFolder.mkdir();
                }
            } else {
                throw new FileNotFoundException("Could not find qrtPCR file for selected entry \"" + currentEntry.getDisplayName() + "\" in project \"" + DataModelSearch.findParentByType((Entry)currentEntry, (String)"org.grits.toolbox.property.project").getDisplayName() + "\"");
            }
            String qrtPCRFileName = CreateQrtPCRDataTable.generateFileName(destinationFolder.list());
            File destinationFile = new File(destinationFolder, qrtPCRFileName);
            Files.copy(currentQrtPCRFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
            ArrayList<PropertyDataFile> dataFiles = new ArrayList<PropertyDataFile>();
            PropertyDataFile currentDataFile = this.getFile();
            dataFiles.add(new PropertyDataFile(destinationFile.getName(), currentDataFile.getVersion(), currentDataFile.getType()));
            QrtPCRProperty property = new QrtPCRProperty();
            property.setDataFiles(dataFiles);
            property.setRemoved(!this.exists());
            property.setVersion(this.getVersion());
            property.setViewerRank(this.getViewerRank());
            destinationEntry.setProperty((Property)property);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOException("Error copying  qrtPCR information.\n" + ex.getMessage(), ex);
        }
    }
}

