/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TreeList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.RowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.ColumnGroupBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSTableDataObject;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.GRITSColumnHeaderDataProvider;
import org.grits.toolbox.display.control.table.tablecore.GRITSHeaderMenuConfiguration;
import org.grits.toolbox.display.control.table.tablecore.GRITSNatTableStyleConfiguration;
import org.grits.toolbox.display.control.table.tablecore.GRITSSingleClickConfiguration;
import org.grits.toolbox.display.control.table.tablecore.IGritsTable;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeTableData;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRColumnChooserHandler;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRMasterTablePreferenceLoader;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferenceLoader;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;
import org.grits.toolbox.entry.qrtpcr.table.DoubleValidator;
import org.grits.toolbox.entry.qrtpcr.table.GeneMenuConfiguration;
import org.grits.toolbox.entry.qrtpcr.table.PlateTableColumnPropertyAccessor;
import org.grits.toolbox.entry.qrtpcr.table.PlateTableConfigLabelAccumulator;
import org.grits.toolbox.entry.qrtpcr.table.PlateTableSortModel;
import org.grits.toolbox.entry.qrtpcr.table.PlateTreeFormat;
import org.grits.toolbox.entry.qrtpcr.table.ValueMenuConfiguration;

public class QrtPCRNatTable
extends NatTable
implements IGritsTable {
    public static final Logger logger = Logger.getLogger(QrtPCRNatTable.class);
    public static final String EDITABLE = "editable";
    public static final String GREENBACKGROUND = "greenBackground";
    public static final String INTEGEREDITABLE = "integerEditable";
    public static final String COMBOEDITABLE = "comboEditable";
    public static final String REDBACKGROUND = "redBackground";
    public static final String REDFOREGROUND = "redForeground";
    public static final String DARDREDFOREGROUND = "darkRedForeground";
    public static final String MAGENTABACKGROUND = "magentaBackground";
    public static final String YELLOWBACKGROUND = "yellowBackground";
    public static final String LISTBACKGROUND = "listBackground";
    public static final String BOLDFONT = "boldFont";
    public static final String STRIKE = "strikeThrough";
    protected SelectionLayer selectionLayer;
    protected ColumnHeaderLayer columnHeaderLayer;
    protected ColumnGroupHeaderLayer columnGroupHeaderLayer;
    protected ColumnHideShowLayer columnHideShowLayer;
    protected DataLayer columnHeaderDataLayer;
    protected ColumnGroupModel columnGroupModel;
    protected TreeLayer treeLayer;
    protected GRITSColumnHeaderDataProvider columnHeaderDataProvider;
    protected IColumnPropertyAccessor<TableData> columnPropertyAccessor;
    TableViewerPreference preferences;
    protected IQrtPCRPart editor;
    protected List<TableData> tableData;
    protected List<List<GRITSColumnHeader>> columnList;
    QrtPCRData qrtPCRData;
    Double lowerThreshold = QrtPCRPreferencePage.THRESHOLD_PREFERENCE;
    Double stDevCutOff = QrtPCRPreferencePage.STDEVCUTOFF_PREFERENCE;
    Boolean rawData = false;
    Integer runId = 0;
    Boolean masterTable = false;
    protected DataLayer bodyDataLayer;
    protected ListDataProvider<TableData> bodyDataProvider;
    protected EventList<TableData> eventList;
    protected SortedList<TableData> sortedList;
    protected TreeList<TableData> treeList;
    protected GridLayer gridLayer;
    protected ViewportLayer viewportLayer;

    public QrtPCRNatTable(Composite parent) {
        super(parent, false);
    }

    public QrtPCRNatTable(Composite parent, IQrtPCRPart editor, List<List<GRITSColumnHeader>> columnList) {
        super(parent, false);
        this.columnList = columnList;
        this.editor = editor;
    }

    public boolean hasColumnGroupHeader() {
        return this.columnList.size() > 1;
    }

    public void performAutoResize() {
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    public void setRawData(Boolean rawData) {
        this.rawData = rawData;
    }

    public void setRunId(Integer runId) {
        this.runId = runId;
    }

    public void setQrtPCRData(QrtPCRData qrtPCRData) {
        this.qrtPCRData = qrtPCRData;
    }

    public void setTableData(List<TableData> data) {
        this.tableData = data;
    }

    public void setColumnList(List<List<GRITSColumnHeader>> columnList) {
        this.columnList = columnList;
    }

    public void setMasterTable(Boolean masterTable) {
        this.masterTable = masterTable;
    }

    public void initializeComponents() {
        ConfigRegistry configRegistry = new ConfigRegistry();
        this.addStyles(configRegistry);
        this.initColumnPropertyAccessor();
        this.initializeConfigRegistry(configRegistry);
        if (this.tableData == null) {
            this.tableData = new ArrayList<TableData>();
        }
        this.eventList = GlazedLists.eventList(this.tableData);
        this.sortedList = new SortedList(this.eventList, null);
        this.columnHeaderDataProvider = new GRITSColumnHeaderDataProvider(this.columnList.get(this.columnList.size() - 1));
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.columnHeaderDataProvider);
        PlateTableSortModel<TableData> sortModel = new PlateTableSortModel<TableData>(this.sortedList, this.columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)this.columnHeaderDataLayer);
        this.initializeTreeList((ISortModel)sortModel);
        GlazedListTreeData treeData = new GlazedListTreeData(this.treeList);
        this.bodyDataProvider = new ListDataProvider(this.treeList, this.columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, this.treeList);
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
        this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        RowHideShowLayer rowHideShowLayer = new RowHideShowLayer((IUniqueIndexLayer)this.columnHideShowLayer);
        this.treeLayer = new TreeLayer((IUniqueIndexLayer)rowHideShowLayer, (ITreeRowModel)new GlazedListTreeRowModel(treeData), false);
        this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.treeLayer);
        this.selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(this.selectionLayer, this.bodyDataProvider, (IRowIdAccessor)new IRowIdAccessor<TableData>(){

            public Serializable getRowId(TableData rowObject) {
                if (rowObject instanceof Gene) {
                    return ((Gene)rowObject).getGeneIdentifier();
                }
                if (rowObject instanceof MergeTableData) {
                    return ((MergeTableData)rowObject).getGene().getGeneIdentifier();
                }
                return null;
            }
        }));
        this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)this.columnHeaderDataLayer);
        this.columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        this.columnGroupModel = new ColumnGroupModel();
        ColumnGroupBodyLayerStack bodyLayer = new ColumnGroupBodyLayerStack((IUniqueIndexLayer)this.bodyDataLayer, new ColumnGroupModel[]{this.columnGroupModel});
        this.columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)this.columnHeaderLayer, bodyLayer.getSelectionLayer(), this.columnGroupModel);
        this.setColumnGroupIndices();
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)this.columnGroupHeaderLayer, sortModel, false);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)this.viewportLayer, this.selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        this.gridLayer = new GridLayer((ILayer)this.viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.setLayer((ILayer)this.gridLayer);
        this.initColumnChooserLayer();
        this.setConfigRegistry((IConfigRegistry)configRegistry);
        this.initializePreferences();
        this.setPreferences();
        this.setConfigLabelAccumulator();
        this.finishNatTable();
    }

    protected void initializeTreeList(ISortModel sortModel) {
        PlateTreeFormat treeFormat = new PlateTreeFormat(sortModel);
        this.treeList = new TreeList(this.sortedList, (TreeList.Format)treeFormat, (TreeList.ExpansionModel)new MyExpansionModel());
    }

    protected void setPreferences() {
        try {
            this.updateViewFromPreferenceSettings();
        }
        catch (Exception e) {
            logger.error((Object)"no preference settings! Initializing preferences from the current view");
            logger.trace((Object)"Exception: ", (Throwable)e);
            this.loadViewerSettings(true);
        }
    }

    protected void finishNatTable() {
        this.bodyDataLayer.setColumnPercentageSizing(true);
        int i = 0;
        while (i < this.columnList.get(0).size()) {
            this.bodyDataLayer.setColumnWidthPercentageByPosition(i, 100 / this.columnList.get(0).size());
            ++i;
        }
        this.addConfiguration((IConfiguration)new GRITSNatTableStyleConfiguration());
        if (this.qrtPCRData != null && this.editor instanceof QrtPCRTableEditor) {
            this.addConfiguration((IConfiguration)new ValueMenuConfiguration((QrtPCRTableEditor)this.editor, this.qrtPCRData, this, this.bodyDataLayer, this.rawData));
            this.addConfiguration((IConfiguration)new GeneMenuConfiguration((QrtPCRTableEditor)this.editor, this.qrtPCRData, this, this.bodyDataLayer, this.rawData));
        }
        this.addConfiguration((IConfiguration)new GRITSHeaderMenuConfiguration((NatTable)this));
        this.addConfiguration((IConfiguration)new DefaultTreeLayerConfiguration(this.treeLayer));
        this.addConfiguration((IConfiguration)new GRITSSingleClickConfiguration(this.columnList.size() > 1));
        this.configure();
        this.refresh();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
    }

    protected void initializeConfigRegistry(ConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", EDITABLE);
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), EDITABLE);
        TextCellEditor textCellEditor = new TextCellEditor();
        textCellEditor.setErrorDecorationEnabled(true);
        textCellEditor.setErrorDecorationText("Enter a floating point number");
        textCellEditor.setDecorationPositionOverride(16512);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)textCellEditor, "EDIT", EDITABLE);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new DoubleValidator(this.columnPropertyAccessor), "EDIT", EDITABLE);
    }

    protected void setConfigLabelAccumulator() {
        this.bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new PlateTableConfigLabelAccumulator(this.bodyDataProvider, this.columnPropertyAccessor, this.rawData, this.masterTable, this.lowerThreshold, this.stDevCutOff));
    }

    protected void initColumnPropertyAccessor() {
        if (this.editor == null) {
            this.columnPropertyAccessor = new PlateTableColumnPropertyAccessor<TableData>(null, null, this.columnList.get(this.columnList.size() - 1), this.runId, this.rawData, this.masterTable, this.lowerThreshold);
        }
        if (this.editor instanceof QrtPCRTableEditor) {
            this.columnPropertyAccessor = new PlateTableColumnPropertyAccessor<TableData>((QrtPCRTableEditor)this.editor, this.qrtPCRData, this.columnList.get(this.columnList.size() - 1), this.runId, this.rawData, this.masterTable, this.lowerThreshold);
        }
    }

    protected void setColumnGroupIndices() {
        if (this.columnList.size() <= 1) {
            return;
        }
        String sLastExp = null;
        ArrayList<Integer> alGroupIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.columnList.get(0).size()) {
            GRITSColumnHeader oVal = this.columnList.get(0).get(i);
            if (oVal != null || sLastExp != null) {
                boolean bChanged;
                boolean bl = bChanged = oVal != null && (sLastExp == null || !oVal.toString().equals(sLastExp));
                if (bChanged) {
                    sLastExp = oVal.toString();
                    alGroupIndices.add(i);
                }
                this.columnGroupHeaderLayer.addColumnsIndexesToGroup(sLastExp, new int[]{i});
            }
            ++i;
        }
        i = 0;
        while (i < alGroupIndices.size()) {
            this.columnGroupHeaderLayer.setGroupUnbreakable(((Integer)alGroupIndices.get(i)).intValue());
            ++i;
        }
    }

    public void loadViewerSettings(boolean _bForceRebuild) {
        if (this.getTablePreference().settingsNeedInitialization() || _bForceRebuild) {
            this.getTablePreference().setPreferenceSettings(this.getPreferenceSettingsFromCurrentView());
            this.getTablePreference().writePreference();
        }
    }

    public TableViewerColumnSettings getPreferenceSettingsFromCurrentView() {
        TableViewerColumnSettings newEntity = new TableViewerColumnSettings();
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return null;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iPos = 0;
        int i = 0;
        while (i < iNumCols) {
            String headerLabel = (String)this.columnHeaderDataLayer.getDataValueByPosition(i, 0);
            GRITSColumnHeader header = new GRITSColumnHeader(headerLabel, this.columnHeaderDataProvider.getDataKey(i, 0));
            newEntity.setVisColInx(header, Integer.valueOf(iPos++));
            ++i;
        }
        return newEntity;
    }

    protected void initColumnChooserLayer() {
        QrtPCRColumnChooserHandler columnChooserCommandHandler = new QrtPCRColumnChooserHandler(this);
        this.columnGroupHeaderLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
    }

    public void initializePreferences() {
        if (this.masterTable.booleanValue()) {
            this.setTablePreference(QrtPCRMasterTablePreferenceLoader.getTableViewerPreference());
        } else {
            this.setTablePreference(QrtPCRPreferenceLoader.getTableViewerPreference());
        }
    }

    public void setTablePreference(TableViewerPreference pref) {
        this.preferences = pref;
    }

    public TableViewerPreference getTablePreference() {
        return this.preferences;
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public void setSelectionLayer(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    public ColumnHeaderLayer getColumnHeaderLayer() {
        return this.columnHeaderLayer;
    }

    public void setColumnHeaderLayer(ColumnHeaderLayer columnHeaderLayer) {
        this.columnHeaderLayer = columnHeaderLayer;
    }

    public ColumnGroupHeaderLayer getColumnGroupHeaderLayer() {
        return this.columnGroupHeaderLayer;
    }

    public void setColumnGroupHeaderLayer(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    public ColumnHideShowLayer getColumnHideShowLayer() {
        return this.columnHideShowLayer;
    }

    public void setColumnHideShowLayer(ColumnHideShowLayer columnHideShowLayer) {
        this.columnHideShowLayer = columnHideShowLayer;
    }

    public DataLayer getColumnHeaderDataLayer() {
        return this.columnHeaderDataLayer;
    }

    public void setColumnHeaderDataLayer(DataLayer columnHeaderDataLayer) {
        this.columnHeaderDataLayer = columnHeaderDataLayer;
    }

    public ColumnGroupModel getColumnGroupModel() {
        return this.columnGroupModel;
    }

    public void setColumnGroupModel(ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
    }

    public void setColumnHeaderDataProvider(GRITSColumnHeaderDataProvider columnHeaderDataProvider2) {
        this.columnHeaderDataProvider = columnHeaderDataProvider2;
    }

    public void setTreeLayer(TreeLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    public TreeList<TableData> getTreeList() {
        return this.treeList;
    }

    public IColumnPropertyAccessor<TableData> getColumnPropertyAccessor() {
        return this.columnPropertyAccessor;
    }

    public void updatePreferenceSettingsFromCurrentView() {
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iNewNumCols = 0;
        int iColInx = 0;
        while (iColInx < iNumCols) {
            boolean bHidden = this.columnHideShowLayer.isColumnIndexHidden(iColInx);
            if (!bHidden) {
                ++iNewNumCols;
            }
            ++iColInx;
        }
        int iToPos = 0;
        int iVisPos = 0;
        while (iVisPos < iNewNumCols) {
            int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)iVisPos, (IUniqueIndexLayer)this.columnHeaderDataLayer);
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
            if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                GRITSColumnHeader header = this.getTablePreference().getPreferenceSettings().getColumnHeader(sHeaderKey);
                this.getTablePreference().getPreferenceSettings().setVisColInx(header, Integer.valueOf(iToPos++));
            }
            ++iVisPos;
        }
        int iColInx2 = 0;
        while (iColInx2 < iNumCols) {
            boolean bHidden = this.columnHideShowLayer.isColumnIndexHidden(iColInx2);
            if (bHidden) {
                int iColPos = this.columnHeaderDataLayer.getColumnPositionByIndex(iColInx2);
                String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                    GRITSColumnHeader header = this.getTablePreference().getPreferenceSettings().getColumnHeader(sHeaderKey);
                    this.getTablePreference().getPreferenceSettings().setVisColInx(header, Integer.valueOf(-1));
                }
            }
            ++iColInx2;
        }
    }

    public boolean updateViewFromPreferenceSettings() {
        if (this.columnHeaderDataLayer == null || this.columnHeaderDataLayer.getColumnCount() == 0) {
            return false;
        }
        int iNumCols = this.columnHeaderDataLayer.getColumnCount();
        int iNumNonHidden = 0;
        if (iNumCols == 0) {
            return false;
        }
        boolean bAddSelect = false;
        if (this.columnList.get(0) != null) {
            GRITSColumnHeader header = this.columnList.get(0).get(0);
            bAddSelect = header.getKeyValue().equals("Select");
        }
        this.columnHideShowLayer.showAllColumns();
        ArrayList<Integer> alHiddenCols = new ArrayList<Integer>();
        int iColLayerPos = 0;
        while (iColLayerPos < iNumCols) {
            String sHeaderKey = this.columnHeaderDataProvider.getDataKey(iColLayerPos, 0);
            int iColShowLayerPos = LayerUtil.convertColumnPosition((ILayer)this.columnHeaderDataLayer, (int)iColLayerPos, (IUniqueIndexLayer)this.columnHideShowLayer);
            if (this.getTablePreference().getPreferenceSettings().hasColumn(sHeaderKey)) {
                int iPrefColPos = this.getTablePreference().getPreferenceSettings().getVisColInx(sHeaderKey);
                if (iPrefColPos == -1) {
                    alHiddenCols.add(iColShowLayerPos);
                } else {
                    ++iNumNonHidden;
                }
            }
            ++iColLayerPos;
        }
        this.columnHideShowLayer.hideColumnPositions(alHiddenCols);
        int iPrefColPos = 0;
        while (iPrefColPos < iNumNonHidden) {
            GRITSColumnHeader prefHeader = this.getTablePreference().getPreferenceSettings().getColumnAtVisColInx(Integer.valueOf(iPrefColPos));
            if (prefHeader != null) {
                int iFromPos = 0;
                while (iFromPos < this.columnHideShowLayer.getColumnCount()) {
                    int iColPos = LayerUtil.convertColumnPosition((ILayer)this.columnHideShowLayer, (int)iFromPos, (IUniqueIndexLayer)this.columnHeaderDataLayer);
                    String sThisHeaderKey = this.columnHeaderDataProvider.getDataKey(iColPos, 0);
                    if (prefHeader.getKeyValue().equals(sThisHeaderKey)) {
                        int iToPos = iPrefColPos;
                        if (bAddSelect) {
                            ++iToPos;
                        }
                        if (iFromPos == iToPos) break;
                        ColumnReorderCommand command = new ColumnReorderCommand((ILayer)this.columnHideShowLayer, iFromPos, iToPos);
                        this.columnHideShowLayer.doCommand((ILayerCommand)command);
                        break;
                    }
                    ++iFromPos;
                }
            }
            ++iPrefColPos;
        }
        return true;
    }

    public void toggleExpandCollapse(boolean collapse) {
        GlazedListTreeRowModel treeModel = (GlazedListTreeRowModel)this.treeLayer.getModel();
        int i = 0;
        while (i < this.treeLayer.getRowCount()) {
            if (collapse) {
                if (treeModel.isCollapsible(i)) {
                    treeModel.collapse(i);
                }
            } else if (treeModel.isCollapsed(i)) {
                treeModel.expand(i);
            }
            ++i;
        }
    }

    protected void addStyles(ConfigRegistry configRegistry) {
        Style redBackgroundStyle = new Style();
        redBackgroundStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(3));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)redBackgroundStyle, "NORMAL", REDBACKGROUND);
        Style redForegroundStyle = new Style();
        redForegroundStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)Display.getDefault().getSystemColor(3));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)redForegroundStyle, "NORMAL", REDFOREGROUND);
        Style darkRedForegroundStyle = new Style();
        darkRedForegroundStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)Display.getDefault().getSystemColor(4));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)darkRedForegroundStyle, "NORMAL", DARDREDFOREGROUND);
        Style magentaBackgroundStyle = new Style();
        magentaBackgroundStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(11));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)magentaBackgroundStyle, "NORMAL", MAGENTABACKGROUND);
        Style yellowBackgroundStyle = new Style();
        yellowBackgroundStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(7));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)yellowBackgroundStyle, "NORMAL", YELLOWBACKGROUND);
        Style greenBackgroundStyle = new Style();
        greenBackgroundStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(5));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)greenBackgroundStyle, "NORMAL", GREENBACKGROUND);
        Style listBackgroundStyle = new Style();
        listBackgroundStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getDefault().getSystemColor(26));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)listBackgroundStyle, "NORMAL", LISTBACKGROUND);
        Style boldFontStyle = new Style();
        FontData[] fD = Display.getDefault().getSystemFont().getFontData();
        fD[0].setStyle(1);
        Font boldFont = new Font((Device)Display.getDefault(), fD);
        boldFontStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)boldFont);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)boldFontStyle, "NORMAL", BOLDFONT);
        TextPainter painter = new TextPainter();
        painter.setStrikethrough(true);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)painter, "NORMAL", STRIKE);
    }

    public void selectAll() {
        int i = 0;
        while (i < this.treeList.size()) {
            this.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)this.selectionLayer, 0, i, true, true));
            ++i;
        }
    }

    public void deSelectAll() {
        this.doCommand((ILayerCommand)new ClearAllSelectionsCommand());
    }

    public boolean isSelected(TableData row) {
        int i = 0;
        while (i < this.treeList.size()) {
            TableData tableData = (TableData)this.treeList.get(i);
            if (tableData.equals(row)) {
                int rowPosition = LayerUtil.convertRowPosition((ILayer)this.bodyDataLayer, (int)i, (IUniqueIndexLayer)this.selectionLayer);
                return this.selectionLayer.isRowPositionSelected(rowPosition);
            }
            ++i;
        }
        return false;
    }

    public void updateTable() {
        this.eventList.clear();
        for (TableData row : this.tableData) {
            this.eventList.add((Object)row);
        }
        this.refresh();
    }

    public List<List<GRITSColumnHeader>> getColumnList() {
        return this.columnList;
    }

    public TableDataProcessor getTableDataProcessor() {
        return null;
    }

    public GRITSTableDataObject getGRITSTableDataObject() {
        return null;
    }

    public static class MyExpansionModel
    implements TreeList.ExpansionModel<TableData> {
        public boolean isExpanded(TableData element, List<TableData> path) {
            return true;
        }

        public void setExpanded(TableData element, List<TableData> path, boolean expanded) {
        }
    }
}

