/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table.manager;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ComboBoxPainter;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.entry.qrtpcr.editor.IQrtPCRPart;
import org.grits.toolbox.entry.qrtpcr.manager.GeneListManagerEditor;
import org.grits.toolbox.entry.qrtpcr.manager.pages.GeneSelectionListContentProvider;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRGeneListTablePreferenceLoader;
import org.grits.toolbox.entry.qrtpcr.table.PlateTreeFormat;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;
import org.grits.toolbox.entry.qrtpcr.table.manager.ChangeMenuConfiguration;
import org.grits.toolbox.entry.qrtpcr.table.manager.DeleteRowCommand;
import org.grits.toolbox.entry.qrtpcr.table.manager.DeleteRowCommandHandler;
import org.grits.toolbox.entry.qrtpcr.table.manager.GeneListTableColumnPropertyAccessor;
import org.grits.toolbox.entry.qrtpcr.table.manager.GeneListTableConfigLabelAccumulator;
import org.grits.toolbox.entry.qrtpcr.table.manager.IntegerValidator;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class ManagerNatTable
extends QrtPCRNatTable
implements MouseListener {
    public static final String SELECTEDEDITABLE = "Selected";
    TableViewer selectedTableViewer;
    GeneList geneList;
    private FilterList<TableData> filterList;
    TextMatcherEditor<TableData> matcher;

    public ManagerNatTable(Composite parent) {
        super(parent);
    }

    public ManagerNatTable(Composite parent, IQrtPCRPart editor, List<List<GRITSColumnHeader>> columnList) {
        super(parent, editor, columnList);
    }

    public void setSelectedTableViewer(TableViewer selectedTableViewer) {
        this.selectedTableViewer = selectedTableViewer;
    }

    public void setGeneList(GeneList geneList) {
        this.geneList = geneList;
    }

    @Override
    protected void initializeConfigRegistry(ConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "editable");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "integerEditable");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "comboEditable");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", SELECTEDEDITABLE);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new TextCellEditor(), "EDIT", "editable");
        TextCellEditor textCellEditor2 = new TextCellEditor();
        textCellEditor2.setErrorDecorationEnabled(true);
        textCellEditor2.setErrorDecorationText("Enter an integer or integers separated by a comma or / only");
        textCellEditor2.setDecorationPositionOverride(16512);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)textCellEditor2, "EDIT", "integerEditable");
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)new IntegerValidator((IColumnPropertyAccessor<TableData>)this.columnPropertyAccessor), "EDIT", "integerEditable");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList("Control", "[No]")), "EDIT", "comboEditable");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new ComboBoxPainter(), "EDIT", "comboEditable");
    }

    @Override
    protected void initializeTreeList(ISortModel sortModel) {
        PlateTreeFormat treeFormat = new PlateTreeFormat(sortModel);
        this.filterList = new FilterList((EventList)this.sortedList);
        TextFilterator<TableData> textFilterator = new TextFilterator<TableData>(){

            public void getFilterStrings(List<String> arg0, TableData arg1) {
                if (arg1 instanceof Gene) {
                    Gene p = (Gene)arg1;
                    arg0.add(p.getGeneIdentifier().toLowerCase());
                    if (p.getGeneSymbol() != null) {
                        arg0.add(p.getGeneSymbol().toLowerCase());
                    }
                    if (p.getRefSeqString() != null) {
                        arg0.add(p.getRefSeqString().toLowerCase());
                    }
                    if (p.getGeneIdString() != null) {
                        arg0.add(p.getGeneIdString().toLowerCase());
                    }
                }
            }
        };
        this.matcher = new TextMatcherEditor((TextFilterator)textFilterator);
        this.matcher.setMode(0);
        this.filterList.setMatcherEditor(this.matcher);
        this.treeList = new TreeList(this.filterList, (TreeList.Format)treeFormat, (TreeList.ExpansionModel)new QrtPCRNatTable.MyExpansionModel());
    }

    @Override
    protected void finishNatTable() {
        super.finishNatTable();
        this.getConfigRegistry().registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", SELECTEDEDITABLE);
        this.getConfigRegistry().registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", SELECTEDEDITABLE);
        this.getConfigRegistry().registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "EDIT", SELECTEDEDITABLE);
        if (this.geneList != null && this.editor instanceof GeneListManagerEditor) {
            this.addConfiguration((IConfiguration)new ChangeMenuConfiguration((GeneListManagerEditor)this.editor, this.geneList, this, this.bodyDataLayer));
        }
        this.configure();
        this.addMouseListener(this);
    }

    @Override
    protected void setConfigLabelAccumulator() {
        this.bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new GeneListTableConfigLabelAccumulator((ListDataProvider<TableData>)this.bodyDataProvider, (IColumnPropertyAccessor<TableData>)this.columnPropertyAccessor));
        this.bodyDataLayer.registerCommandHandler(new DeleteRowCommandHandler(this.bodyDataProvider.getList()));
    }

    @Override
    protected void initColumnPropertyAccessor() {
        if (this.editor == null) {
            this.columnPropertyAccessor = new GeneListTableColumnPropertyAccessor(null, (List)this.columnList.get(this.columnList.size() - 1));
        } else if (this.editor instanceof GeneListManagerEditor) {
            this.columnPropertyAccessor = new GeneListTableColumnPropertyAccessor((GeneListManagerEditor)this.editor, (List)this.columnList.get(this.columnList.size() - 1));
        }
    }

    @Override
    public void initializePreferences() {
        this.setTablePreference(QrtPCRGeneListTablePreferenceLoader.getTableViewerPreference());
    }

    public void filter(String searchString) {
        this.matcher.setFilterText(new String[]{searchString.toLowerCase()});
        if (this.gridLayer.getBodyLayer().getRowCount() > 0) {
            this.doCommand((ILayerCommand)new ShowRowInViewportCommand(this.gridLayer.getBodyLayer(), 1));
        }
    }

    @Override
    public void selectAll() {
        ((GeneListTableColumnPropertyAccessor)this.columnPropertyAccessor).selectAll(this.bodyDataProvider.getList());
        this.repaintColumn(0);
        this.update();
    }

    @Override
    public void deSelectAll() {
        ((GeneListTableColumnPropertyAccessor)this.columnPropertyAccessor).clearAllSelections(this.bodyDataProvider.getList());
        this.repaintColumn(0);
        this.update();
    }

    public List<TableData> getSelected() {
        return ((GeneListTableColumnPropertyAccessor)this.columnPropertyAccessor).getSelected();
    }

    public void removeRow(TableData row) {
        int i = 0;
        int rowIndex = -1;
        for (TableData tableData : this.treeList) {
            if (tableData.equals(row)) {
                rowIndex = i;
            }
            ++i;
        }
        this.doCommand((ILayerCommand)new DeleteRowCommand((ILayer)this.bodyDataLayer, rowIndex));
    }

    public void selectRow(TableData row) {
        ((GeneListTableColumnPropertyAccessor)this.columnPropertyAccessor).selectRow(row);
        this.repaintColumn(0);
        this.update();
    }

    public void mouseDoubleClick(MouseEvent e) {
        GeneSelectionListContentProvider cp = (GeneSelectionListContentProvider)this.selectedTableViewer.getContentProvider();
        int rowPos = this.getRowPositionByY(e.y);
        int bodyRowPos = LayerUtil.convertRowPosition((ILayer)this, (int)rowPos, (IUniqueIndexLayer)this.bodyDataLayer);
        TableData item = (TableData)this.bodyDataProvider.getRowObject(bodyRowPos);
        Gene selection = (Gene)item;
        boolean found = false;
        List<Gene> existing = cp.getGenes();
        for (Gene gene : existing) {
            if (!gene.getGeneIdentifier().equals(selection.getGeneIdentifier())) continue;
            found = true;
            break;
        }
        if (found) {
            boolean addDuplicate = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Duplicate", (String)"This gene is already in the list, do you want to add it again anyway?");
            if (addDuplicate) {
                Gene newGene = GeneUtils.makeACopy(selection);
                existing.add(newGene);
                this.selectRow(item);
            }
        } else {
            existing.add(selection);
            this.selectRow(item);
        }
        this.selectedTableViewer.refresh();
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

