/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions;

import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.dialog.uploadfile.UploadDialog;
import org.grits.toolbox.entry.archive.editor.ArchiveEntryEditor;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.utility.UtilityFileName;
import org.grits.toolbox.entry.archive.utility.UtilityZip;

public class UploadArchivedFile
extends Action {
    private static Logger logger = Logger.getLogger(UploadArchivedFile.class);
    private FileArchivePage page = null;

    public UploadArchivedFile(FileArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Upload a File");
        this.setToolTipText("Upload a File");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.UPLOAD_FOLDER_ICON));
    }

    public void run() {
        block14: {
            logger.debug((Object)"Start - Uploading  Archive File");
            ArchiveEntryEditor archiveEntryEditor = this.page.getEditor();
            TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
            List inputArchivedFiles = (List)treeViewer.getInput();
            File archiveFolder = archiveEntryEditor.getArchiveFolder();
            try {
                UploadDialog uploadDialog = new UploadDialog(Display.getCurrent().getActiveShell(), UtilityFileName.getExistingNames(inputArchivedFiles, archiveFolder));
                if (uploadDialog.open() != 0) break block14;
                ArchivedFile newArchivedFile = uploadDialog.getArchivedFile();
                File fileToArchive = uploadDialog.getSourceFile();
                if (archiveFolder.exists() && fileToArchive.exists()) {
                    try {
                        File archiveFile;
                        String archiveFileName;
                        block15: {
                            archiveFileName = newArchivedFile.getTypicalArchivedFile().getFileName();
                            if (!UtilityFileName.checkUnique(archiveFolder, archiveFileName)) {
                                archiveFileName = UtilityFileName.generateUniqueFileName(archiveFolder, archiveFileName);
                            }
                            archiveFile = null;
                            if (fileToArchive.isDirectory()) {
                                try {
                                    if (fileToArchive.getAbsolutePath().contains(archiveFolder.getAbsolutePath())) {
                                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"You cannot upload the archive folder or its content.\n");
                                        break block15;
                                    }
                                    archiveFile = UtilityZip.createZippedFolder(fileToArchive, archiveFolder, archiveFileName);
                                }
                                catch (Exception ex) {
                                    logger.error((Object)("Folder upload not supported yet.\n" + ex.getMessage()), (Throwable)ex);
                                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)("Error uploading folder.\n" + ex.getMessage()));
                                }
                            } else {
                                archiveFile = new File(archiveFolder, archiveFileName);
                                UtilityZip.copyFile(fileToArchive, archiveFile);
                            }
                        }
                        if (archiveFile != null) {
                            newArchivedFile.getTypicalArchivedFile().setFileName(archiveFileName);
                            inputArchivedFiles.add(newArchivedFile);
                            treeViewer.setInput((Object)inputArchivedFiles);
                            archiveEntryEditor.saveModel();
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error uploading file to archive.\n" + ex.getMessage()), (Throwable)ex);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"The file could not be uploaded to GRITS. Please report this error to the development team");
                    }
                }
                this.page.refreshPage();
                int i = 0;
                int selectionIndex = 0;
                for (ArchivedFile archivedFile : inputArchivedFiles) {
                    if (archivedFile.getTypicalArchivedFile().getFileName().equals(newArchivedFile.getTypicalArchivedFile().getFileName())) {
                        selectionIndex = i;
                    }
                    ++i;
                }
                TreeItem selectionItem = treeViewer.getTree().getItem(selectionIndex);
                treeViewer.getTree().select(selectionItem);
                treeViewer.setSelection(treeViewer.getSelection());
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Upload Error", (String)"The file could not be uploaded to GRITS. Please report this error to the development team");
            }
        }
        logger.debug((Object)"End - Uploading  Archive File");
    }
}

