/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="documentType")
@XmlType(propOrder={"label", "makeDefault", "selectedSubType", "subTypes"})
public class DocumentType {
    private String label = null;
    private boolean makeDefault = false;
    private String selectedSubType = null;
    private Set<String> subTypes = new HashSet<String>();
    private boolean initialized = false;

    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @XmlAttribute(name="makeDefault", required=true)
    public boolean isMakeDefault() {
        return this.makeDefault;
    }

    public void setMakeDefault(boolean defaultSelection) {
        this.makeDefault = defaultSelection;
    }

    @XmlAttribute(name="selectedSubType", required=false)
    public String getSelectedSubType() {
        return this.selectedSubType;
    }

    public void setSelectedSubType(String selectedSubType) {
        for (String subType : this.subTypes) {
            if (!subType.equals(selectedSubType)) continue;
            this.selectedSubType = subType;
            break;
        }
        if (!Objects.equals(this.selectedSubType, selectedSubType)) {
            this.selectedSubType = selectedSubType;
        }
    }

    @XmlElement(name="subTypes", required=false)
    public Set<String> getSubTypes() {
        if (!this.initialized && !this.subTypes.isEmpty()) {
            this.createNewStringObjects();
            this.initialized = true;
        }
        return this.subTypes;
    }

    private void createNewStringObjects() {
        HashSet<String> localSubTypes = new HashSet<String>();
        String newString = null;
        for (String ele : this.subTypes) {
            newString = new String(ele);
            localSubTypes.add(newString);
            if (this.selectedSubType == null || !this.selectedSubType.equals(ele)) continue;
            this.selectedSubType = newString;
        }
        this.subTypes = localSubTypes;
    }

    public void setSubTypes(Set<String> subTypes) {
        this.subTypes = subTypes;
        this.createNewStringObjects();
    }

    public boolean addSubType(String subtype) {
        return this.subTypes.add(new String(subtype));
    }

    public DocumentType clone() {
        DocumentType docType = new DocumentType();
        docType.setLabel(this.label);
        docType.setMakeDefault(this.makeDefault);
        docType.setSubTypes(new HashSet<String>());
        String newSubType = null;
        for (String subType : this.subTypes) {
            newSubType = new String(subType);
            docType.getSubTypes().add(newSubType);
            if (this.selectedSubType == null || !this.selectedSubType.equals(subType)) continue;
            docType.setSelectedSubType(newSubType);
        }
        return docType;
    }
}

