/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.glycomedb.residuetranslator.ResidueTranslator;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.io.ms.annotation.glycan.process.export.MSGlycanAnnotationWriterExcel;
import org.grits.toolbox.io.ms.annotation.listener.ExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExcelListener;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationExportProcess;
import org.grits.toolbox.io.ms.annotation.process.export.MSAnnotationWriterExcel;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.util.structure.glycan.filter.GlycanFilterOperator;
import org.grits.toolbox.util.structure.glycan.filter.om.Filter;
import org.grits.toolbox.util.structure.glycan.filter.om.FilterSetting;
import org.grits.toolbox.utils.process.GlycoWorkbenchUtil;
import org.grits.toolbox.widgets.processDialog.ProgressDialog;
import org.grits.toolbox.widgets.progress.IProgressThreadHandler;

public class MSGlycanAnnotationExportProcess
extends MSAnnotationExportProcess {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationExportProcess.class);
    protected FilterSetting filterSetting;
    protected GlycoWorkbenchUtil m_gwbUtil;
    protected String filterKey;
    protected double thresholdValue;
    protected int numTopHits = -1;

    protected MSAnnotationWriterExcel getNewMSAnnotationWriterExcel() {
        return new MSGlycanAnnotationWriterExcel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean threadStart(IProgressThreadHandler a_progressThreadHandler) throws Exception {
        try {
            String iRowId;
            Integer iScanNum;
            Integer iParentScanNum;
            MSAnnotationWriterExcel t_writerExcel = this.getNewMSAnnotationWriterExcel();
            t_writerExcel.createNewFile(this.getOutputFile(), this.getTableDataObject(), this.getLastVisibleColInx(), (ExcelListener)new MSAnnotationExcelListener((ProgressDialog)a_progressThreadHandler));
            Config t_objConf = new Config();
            MonosaccharideConverter t_msdb = new MonosaccharideConverter(t_objConf);
            try {
                this.m_gwbUtil = new GlycoWorkbenchUtil((MonosaccharideConversion)new ResidueTranslator(), (MonosaccharideConversion)t_msdb);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(this.tableDataObject.getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Processing data and filters");
            Map<Integer, Double> rowIntensityMap = new HashMap<Integer, Double>();
            HashMap<Integer, Boolean> invisibleRowMap = new HashMap<Integer, Boolean>();
            Hashtable<Integer, ArrayList> htAtLeastOne = new Hashtable<Integer, ArrayList>();
            int iParentScanIdCol = -1;
            if (this.getTableDataObject().getParentNoCol() != null && !this.getTableDataObject().getParentNoCol().isEmpty()) {
                iParentScanIdCol = (Integer)this.getTableDataObject().getParentNoCol().get(0);
            }
            int iPeakIdCol = (Integer)this.getTableDataObject().getPeakIdCols().get(0);
            int iFeatureIdCol = (Integer)this.getTableDataObject().getFeatureIdCols().get(0);
            int iScanIdCol = -1;
            if (this.getTableDataObject().getScanNoCols() != null && !this.getTableDataObject().getScanNoCols().isEmpty()) {
                iScanIdCol = (Integer)this.getTableDataObject().getScanNoCols().get(0);
            }
            int i = 0;
            while (i < this.getTableDataObject().getTableData().size()) {
                block27: {
                    String sFeatureId;
                    block30: {
                        block29: {
                            boolean passFilter;
                            block28: {
                                if (this.isCanceled()) {
                                    t_writerExcel.close();
                                    return false;
                                }
                                iParentScanNum = null;
                                if (this.getMasterParentScan() != -1) {
                                    iParentScanNum = this.getMasterParentScan();
                                } else if (iParentScanIdCol != -1 && ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol) != null) {
                                    iParentScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol);
                                }
                                Integer iPeakId = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iPeakIdCol);
                                sFeatureId = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iFeatureIdCol);
                                if (sFeatureId == null && this.hideUnAnnotatedRows()) break block27;
                                iScanNum = null;
                                if (iScanIdCol != -1) {
                                    iScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iScanIdCol);
                                }
                                iRowId = Feature.getRowId((Integer)iPeakId, iScanNum);
                                if (iPeakId != null && sFeatureId != null && iParentScanNum != null && this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) break block27;
                                boolean bInvisible = false;
                                if (iPeakId != null && iParentScanNum != null && this.getTableDataObject().isInvisibleRow(iParentScanNum, iRowId)) {
                                    bInvisible = true;
                                }
                                invisibleRowMap.put(i, bInvisible);
                                passFilter = true;
                                passFilter = this.applyGlycanFilters(((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow());
                                if (passFilter) break block28;
                                logger.debug((Object)(String.valueOf(sFeatureId) + " failed to pass the filter. Skipping!"));
                                break block27;
                            }
                            if (this.filterKey == null) break block29;
                            passFilter = this.applyIntensityFilter(i, ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow(), rowIntensityMap);
                            if (passFilter) break block30;
                            logger.debug((Object)(String.valueOf(sFeatureId) + " failed to pass the threshold filter. Skipping!"));
                            break block27;
                        }
                        rowIntensityMap.put(i, 0.0);
                    }
                    if (sFeatureId != null && iScanNum != null) {
                        ArrayList alAtLeastOne = null;
                        if (!htAtLeastOne.containsKey(iScanNum)) {
                            alAtLeastOne = new ArrayList();
                            htAtLeastOne.put(iScanNum, alAtLeastOne);
                        } else {
                            alAtLeastOne = (ArrayList)htAtLeastOne.get(iScanNum);
                        }
                        alAtLeastOne.add(iRowId);
                    }
                    ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                }
                ++i;
            }
            if (this.numTopHits > 0 && this.filterKey != null) {
                rowIntensityMap = this.applyTopHits(rowIntensityMap);
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(this.getTableDataObject().getTableData().size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Processing filter results");
            i = 0;
            while (i < this.getTableDataObject().getTableData().size()) {
                block32: {
                    block33: {
                        ArrayList atLeastOne;
                        Integer iPeakId;
                        String sFeatureId;
                        block31: {
                            if (this.isCanceled()) {
                                t_writerExcel.close();
                                return false;
                            }
                            iParentScanNum = null;
                            if (this.getMasterParentScan() != -1) {
                                iParentScanNum = this.getMasterParentScan();
                            } else if (iParentScanIdCol != -1 && ((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol) != null) {
                                iParentScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iParentScanIdCol);
                            }
                            sFeatureId = (String)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iFeatureIdCol);
                            iPeakId = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iPeakIdCol);
                            iScanNum = null;
                            if (iScanIdCol != -1) {
                                iScanNum = (Integer)((GRITSListDataRow)this.getTableDataObject().getTableData().get(i)).getDataRow().get(iScanIdCol);
                            }
                            iRowId = Feature.getRowId((Integer)iPeakId, (Integer)iScanNum);
                            if (iScanNum == null || htAtLeastOne.containsKey(iScanNum)) break block31;
                            if (sFeatureId == null && this.hideUnAnnotatedRows() || iPeakId != null && sFeatureId != null && iParentScanNum != null && this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) break block32;
                            invisibleRowMap.put(i, true);
                            rowIntensityMap.put(i, 0.0);
                            break block33;
                        }
                        if (iScanNum == null || (atLeastOne = (ArrayList)htAtLeastOne.get(iScanNum)) != null && atLeastOne.size() != 0) break block33;
                        if (sFeatureId == null && this.hideUnAnnotatedRows() || iPeakId != null && sFeatureId != null && iParentScanNum != null && this.getTableDataObject().isHiddenRow(iParentScanNum, iRowId, sFeatureId)) break block32;
                        invisibleRowMap.put(i, true);
                        rowIntensityMap.put(i, 0.0);
                    }
                    ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                }
                ++i;
            }
            ((ProgressDialog)a_progressThreadHandler).setMax(rowIntensityMap.size());
            ((ProgressDialog)a_progressThreadHandler).setProcessMessageLabel("Exporting data");
            i = 0;
            for (Integer rowId : rowIntensityMap.keySet()) {
                t_writerExcel.writeRow(rowId.intValue(), ((Boolean)invisibleRowMap.get(rowId)).booleanValue());
                ((ProgressDialog)a_progressThreadHandler).updateProgresBar("Scan: " + (i + 1));
                ++i;
            }
            t_writerExcel.close();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected Map<Integer, Double> applyTopHits(Map<Integer, Double> rowIntensityMap) {
        Map<Integer, Double> sortedMap = MSGlycanAnnotationExportProcess.sortByValue(rowIntensityMap);
        LinkedHashMap<Integer, Double> topSelectedRows = new LinkedHashMap<Integer, Double>();
        int i = 0;
        for (Integer rowId : sortedMap.keySet()) {
            if (i >= this.numTopHits) break;
            topSelectedRows.put(rowId, sortedMap.get(rowId));
            ++i;
        }
        return topSelectedRows;
    }

    protected boolean applyIntensityFilter(int rowId, ArrayList<Object> dataRow, Map<Integer, Double> rowIntensityMap) {
        if (this.filterKey.equals(DMPeak.peak_intensity.getLabel())) {
            Double peakIntensity = (Double)dataRow.get((Integer)this.getTableDataObject().getPeakIntensityCols().get(0));
            if (this.thresholdValue > 0.0 && peakIntensity < this.thresholdValue) {
                return false;
            }
            rowIntensityMap.put(rowId, peakIntensity);
        } else if (this.filterKey.equals(DMPrecursorPeak.precursor_peak_intensity.getLabel())) {
            Double intensity = (Double)dataRow.get((Integer)this.getTableDataObject().getPrecursorIntensityCols().get(0));
            if (this.thresholdValue > 0.0 && intensity < this.thresholdValue) {
                return false;
            }
            rowIntensityMap.put(rowId, intensity);
        }
        return true;
    }

    protected boolean applyGlycanFilters(ArrayList<Object> dataRow) throws Exception {
        int sequenceCol = (Integer)this.getTableDataObject().getSequenceCols().get(0);
        String sequence = (String)dataRow.get(sequenceCol);
        return this.passesFilters(sequence);
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(Collections.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    protected boolean passesFilters(String sequence) throws Exception {
        if (sequence != null && !sequence.isEmpty() && this.filterSetting != null) {
            int iInx1 = sequence.indexOf("~|~");
            if (iInx1 < 0) {
                this.m_gwbUtil.parseGWSSequence(sequence);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                return GlycanFilterOperator.evaluate((Sugar)glycan.toSugar(), (Filter)this.filterSetting.getFilter());
            }
            String sRemaining = sequence;
            do {
                String sSeq = iInx1 > 0 ? sRemaining.substring(0, iInx1) : sRemaining;
                this.m_gwbUtil.parseGWSSequence(sSeq);
                Glycan glycan = this.m_gwbUtil.getGlycoWorkbenchGlycan();
                if (GlycanFilterOperator.evaluate((Sugar)glycan.toSugar(), (Filter)this.filterSetting.getFilter())) {
                    return true;
                }
                sRemaining = iInx1 > 0 ? sRemaining.substring(iInx1 + "~|~".length()) : null;
                int n = iInx1 = sRemaining != null ? sRemaining.indexOf("~|~") : -1;
            } while (sRemaining != null);
        }
        return true;
    }

    public void setFilterSetting(FilterSetting filterSetting) {
        this.filterSetting = filterSetting;
    }

    public void setFilterKey(String filterKey) {
        this.filterKey = filterKey;
    }

    public void setNumTopHits(int numTopHits) {
        this.numTopHits = numTopHits;
    }

    public void setThresholdValue(double thresholdValue) {
        this.thresholdValue = thresholdValue;
    }
}

