/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.io.ms.annotation.glycan.process.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.MSGlycanAnnotationTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.io.ms.annotation.glycan.process.export.MSGlycanAnnotationWriterExcel;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class MSGlycanAnnotationSummaryWriterExcel
extends MSGlycanAnnotationWriterExcel {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSummaryWriterExcel.class);
    private int iSizeRepeatingGrps = 0;

    /*
     * WARNING - void declaration
     */
    protected void determineCollapsedColumnPositions() {
        void var13_20;
        ArrayList headerRow1 = (ArrayList)this.getAnnotationDataObject().getTableHeader().get(0);
        ArrayList headerRow2 = (ArrayList)this.getAnnotationDataObject().getTableHeader().get(1);
        int iFirstGrpInx = -1;
        int iLastGrpInx = -1;
        GRITSColumnHeader prevGrpHeader = null;
        int iCellCnt = headerRow1.size() - 1;
        int i = headerRow1.size() - 1;
        while (i >= 0) {
            GRITSColumnHeader header1 = (GRITSColumnHeader)headerRow1.get(i);
            GRITSColumnHeader header2 = (GRITSColumnHeader)headerRow2.get(i);
            int iColNum = this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(header2);
            if (iColNum != -1) {
                if (prevGrpHeader == null) {
                    iFirstGrpInx = iCellCnt;
                    iLastGrpInx = iCellCnt;
                    prevGrpHeader = header1;
                } else if (!prevGrpHeader.equals((Object)header1)) {
                    i = -1;
                } else {
                    iLastGrpInx = iCellCnt;
                }
                --iCellCnt;
            }
            --i;
        }
        this.iSizeRepeatingGrps = iFirstGrpInx - iLastGrpInx + 1;
        ArrayList alPrefColNums = new ArrayList();
        ArrayList<Integer> alCurListOfCols = null;
        int iAdder = 0;
        int iPrevAdder = -1;
        HashMap<GRITSColumnHeader, Integer> htGroupToAdder = new HashMap<GRITSColumnHeader, Integer>();
        int i2 = 0;
        while (i2 < headerRow2.size()) {
            GRITSColumnHeader gRITSColumnHeader = (GRITSColumnHeader)headerRow2.get(i2);
            int iColNum = this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(gRITSColumnHeader);
            if (iColNum != -1) {
                iAdder = htGroupToAdder.containsKey(gRITSColumnHeader) ? (Integer)htGroupToAdder.get(gRITSColumnHeader) + this.iSizeRepeatingGrps : 0;
                if (iAdder != iPrevAdder) {
                    alCurListOfCols = new ArrayList<Integer>();
                    alPrefColNums.add(alCurListOfCols);
                    iPrevAdder = iAdder;
                }
                htGroupToAdder.put(gRITSColumnHeader, iAdder);
                alCurListOfCols.add(iColNum + iAdder);
            }
            ++i2;
        }
        ArrayList alFinalPrefColNums = new ArrayList();
        for (List list : alPrefColNums) {
            Collections.sort(list);
            alFinalPrefColNums.addAll(list);
        }
        htGroupToAdder.clear();
        this.dataToPrefColumn = new HashMap();
        boolean bl = false;
        while (var13_20 < headerRow2.size()) {
            GRITSColumnHeader header = (GRITSColumnHeader)headerRow2.get((int)var13_20);
            int iColNum = this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(header);
            if (iColNum != -1) {
                iAdder = htGroupToAdder.containsKey(header) ? (Integer)htGroupToAdder.get(header) + this.iSizeRepeatingGrps : 0;
                htGroupToAdder.put(header, iAdder);
                int iCollapsedColNum = alFinalPrefColNums.indexOf(iColNum + iAdder);
                this.dataToPrefColumn.put((int)var13_20, iCollapsedColNum);
            }
            ++var13_20;
        }
    }

    public void writeHeadline() {
        this.determineCollapsedColumnPositions();
        Row t_row = this.m_objSheet.createRow(this.m_iRowCounter);
        ArrayList headerRow1 = (ArrayList)this.getAnnotationDataObject().getTableHeader().get(0);
        ArrayList headerRow2 = (ArrayList)this.getAnnotationDataObject().getTableHeader().get(1);
        int iFirstGrpInx = -1;
        int iLastGrpInx = -1;
        GRITSColumnHeader prevGrpHeader = null;
        int iCellCnt = 0;
        int i = 0;
        while (i < headerRow1.size()) {
            GRITSColumnHeader header1 = (GRITSColumnHeader)headerRow1.get(i);
            GRITSColumnHeader header2 = (GRITSColumnHeader)headerRow2.get(i);
            int iColNum = -1;
            iColNum = this.getMyTableDataObject().getAnnotationIdCols().contains(i) ? iCellCnt : this.getAnnotationDataObject().getTablePreferences().getPreferenceSettings().getColumnPosition(header2);
            if (iColNum != -1) {
                Cell cell = t_row.createCell(iCellCnt);
                cell.setCellValue(header1.getLabel());
                cell.setCellType(1);
                if (prevGrpHeader == null || !prevGrpHeader.equals((Object)header1)) {
                    if (prevGrpHeader != null) {
                        if (iLastGrpInx == -1 || iLastGrpInx < iFirstGrpInx) {
                            iLastGrpInx = iFirstGrpInx;
                        }
                        if (iLastGrpInx - iFirstGrpInx > 0) {
                            this.m_objSheet.addMergedRegion(new CellRangeAddress(this.m_iRowCounter, this.m_iRowCounter, iFirstGrpInx, iLastGrpInx));
                        }
                    }
                    iFirstGrpInx = iCellCnt;
                    prevGrpHeader = header1;
                } else {
                    iLastGrpInx = iCellCnt;
                }
                ++iCellCnt;
            }
            ++i;
        }
        if (prevGrpHeader != null) {
            if (iLastGrpInx == -1 || iLastGrpInx < iFirstGrpInx) {
                iLastGrpInx = iFirstGrpInx;
            }
            if (iLastGrpInx - iFirstGrpInx > 0) {
                this.m_objSheet.addMergedRegion(new CellRangeAddress(this.m_iRowCounter, this.m_iRowCounter, iFirstGrpInx, iLastGrpInx));
            }
        }
        this.writeEmptyLine();
        t_row = this.m_objSheet.createRow(this.m_iRowCounter);
        ArrayList headerRow = (ArrayList)this.getAnnotationDataObject().getLastHeader();
        int columnNo = 0;
        int i2 = 0;
        while (i2 < headerRow.size()) {
            GRITSColumnHeader header = (GRITSColumnHeader)headerRow.get(i2);
            if (this.getMyTableDataObject().getCartoonCols().contains(i2)) {
                Object cartoon = headerRow.get(i2);
                if (cartoon != null) {
                    this.writeCellImage(t_row, null, columnNo, ((GRITSColumnHeader)cartoon).getKeyValue());
                    this.dataToPrefColumn.put(i2, columnNo);
                    ++columnNo;
                }
            } else {
                int iColNum = this.getPreferredCellNumber(i2);
                if (iColNum != -1) {
                    Cell t_cell = t_row.createCell(iColNum);
                    t_cell.setCellValue(header.getLabel());
                    t_cell.setCellType(1);
                    this.m_objSheet.setColumnWidth(iColNum, 3500);
                    ++columnNo;
                }
            }
            ++i2;
        }
        this.writeEmptyLine();
    }

    @Override
    protected void writeCell(Row _excelRow, ArrayList<Object> _tableRow, int _iDataColNum, int _iPrefColNum, boolean _bIsHidden) {
        if (_bIsHidden) {
            return;
        }
        if (this.getMyTableDataObject().getCartoonCols().contains(_iDataColNum)) {
            Object oCartoon = _tableRow.get(_iDataColNum);
            if (oCartoon == null) {
                super.writeCell(_excelRow, _tableRow, _iDataColNum, _iPrefColNum, _bIsHidden);
                return;
            }
            int iInx = this.getMyTableDataObject().getCartoonCols().indexOf(_iDataColNum);
            int iSeqColNum = (Integer)this.getMyTableDataObject().getSequenceCols().get(iInx);
            String sSequence = (String)_tableRow.get(iSeqColNum);
            this.writeCellImage(_excelRow, _tableRow, _iPrefColNum, sSequence);
        } else {
            if (_iPrefColNum < 0) {
                return;
            }
            if (_iDataColNum > this.m_lastVisibleColInx) {
                return;
            }
            super.writeCell(_excelRow, _tableRow, _iDataColNum, _iPrefColNum, _bIsHidden);
        }
    }

    @Override
    protected void writeCellImage(Row _excelRow, ArrayList<Object> _tableRow, int _iPrefColNum, String _sSequence) {
        if (_sSequence == null) {
            return;
        }
        try {
            GlycanImageProvider.GlycanImageObject gio = MSGlycanAnnotationTableDataObject.glycanImageProvider.getImage(_sSequence);
            this.helper.writeCellImage(this.m_objWorkbook, this.m_objSheet, this.m_iRowCounter, _iPrefColNum, gio.getAwtBufferedImage(), this.m_images);
        }
        catch (Exception e) {
            this.errorMessage("Image generation failed");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

