/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class ProjectInWorkingSetDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (operation != 2) {
            return Status.CANCEL_STATUS;
        }
        IWorkingSet targetWorkingSet = null;
        if (target instanceof IAdaptable) {
            targetWorkingSet = (IWorkingSet)((IAdaptable)target).getAdapter(IWorkingSet.class);
        }
        if (targetWorkingSet == null) {
            return Status.CANCEL_STATUS;
        }
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            return Status.CANCEL_STATUS;
        }
        ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
        if (!sel.isEmpty() && sel instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                Object item = objectArray[n2];
                if (item instanceof IAdaptable && (project = (IProject)((IAdaptable)item).getAdapter(IProject.class)) != null && !this.workingSetContains(targetWorkingSet, project)) {
                    return Status.OK_STATUS;
                }
                ++n2;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        block7: {
            ISelection sel;
            IWorkingSet targetWorkingSet;
            IWorkingSetManager workingSetManager;
            block6: {
                workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                targetWorkingSet = (IWorkingSet)((IAdaptable)target).getAdapter(IWorkingSet.class);
                sel = LocalSelectionTransfer.getTransfer().getSelection();
                if (!(sel instanceof ITreeSelection)) break block6;
                TreePath[] treePathArray = ((ITreeSelection)sel).getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    IProject project = (IProject)((IAdaptable)path.getLastSegment()).getAdapter(IProject.class);
                    if (project != null) {
                        IWorkingSet sourceWorkingSet;
                        if (!this.workingSetContains(targetWorkingSet, project)) {
                            workingSetManager.addToWorkingSets((IAdaptable)project, new IWorkingSet[]{targetWorkingSet});
                        }
                        if (path.getFirstSegment() instanceof IAdaptable && (sourceWorkingSet = (IWorkingSet)((IAdaptable)path.getFirstSegment()).getAdapter(IWorkingSet.class)) != null) {
                            this.removeFromWorkingSet(project, sourceWorkingSet);
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            if (!(sel instanceof IStructuredSelection)) break block7;
            Object[] objectArray = ((IStructuredSelection)sel).toArray();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object item = objectArray[n3];
                IProject project = (IProject)((IAdaptable)item).getAdapter(IProject.class);
                if (project != null && !this.workingSetContains(targetWorkingSet, project)) {
                    workingSetManager.addToWorkingSets((IAdaptable)project, new IWorkingSet[]{targetWorkingSet});
                }
                ++n3;
            }
        }
        return Status.OK_STATUS;
    }

    private void removeFromWorkingSet(IProject project, IWorkingSet workingSet) {
        IAdaptable[] srcElements = workingSet.getElements();
        ArrayList<IAdaptable> newSrcElements = new ArrayList<IAdaptable>();
        IAdaptable[] iAdaptableArray = srcElements;
        int n = srcElements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable srcElement = iAdaptableArray[n2];
            if (!project.equals(srcElement.getAdapter(IProject.class))) {
                newSrcElements.add(srcElement);
            }
            ++n2;
        }
        IAdaptable[] adaptedNewSrcElements = workingSet.adaptElements(newSrcElements.toArray(new IAdaptable[newSrcElements.size()]));
        workingSet.setElements(adaptedNewSrcElements);
    }

    private boolean workingSetContains(IWorkingSet workingSet, IProject project) {
        IAdaptable[] iAdaptableArray = workingSet.getElements();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            if (project.equals(element.getAdapter(IProject.class))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

