/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.io;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbResidueParser;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.MonosaccharideImporter;
import org.eurocarbdb.resourcesdb.io.NameParsingException;
import org.eurocarbdb.resourcesdb.io.StandardImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.BasetypeConversion;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideDataBuilder;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideValidation;
import org.eurocarbdb.resourcesdb.monosaccharide.Substitution;
import org.eurocarbdb.resourcesdb.template.SubstituentTemplate;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

public class GlycoCTImporter
extends StandardImporter
implements MonosaccharideImporter {
    private String substitutionStr;
    private char substitutionToken = (char)32;
    private int substitutionParsingPosition = -1;
    private int substitutionStartPosition = -1;
    public static final String BASETYPE_SUBST_SEPARATOR = "||";

    public GlycoCTImporter(GlycanNamescheme scheme, Config confObj, TemplateContainer container) {
        super(scheme, confObj, container);
        this.init();
    }

    public GlycoCTImporter(GlycanNamescheme scheme, Config confObj) {
        this(scheme, confObj, null);
    }

    public GlycoCTImporter(GlycanNamescheme scheme) {
        this(scheme, null);
    }

    @Override
    public Monosaccharide parseMsString(String name) throws ResourcesDbException {
        Monosaccharide ms = new Monosaccharide(this.getConfig(), this.getTemplateContainer());
        this.parseMsString(name, ms);
        return ms;
    }

    public void parseMsString(String name, Monosaccharide ms) throws ResourcesDbException {
        this.setInputName(name);
        this.setFoundMs(false);
        if (GlycanNamescheme.MONOSACCHARIDEDB.equals((Object)this.getNamescheme())) {
            String basetypeStr = null;
            String substitutionsStr = null;
            int separatorPos = name.indexOf(BASETYPE_SUBST_SEPARATOR);
            if (separatorPos >= 0) {
                basetypeStr = name.substring(0, separatorPos);
                this.substitutionStartPosition = separatorPos + 2;
                substitutionsStr = name.substring(this.substitutionStartPosition);
            } else {
                basetypeStr = name;
            }
            this.parseBasetypeString(basetypeStr, ms);
            ms.setCheckPositionsOnTheFly(false);
            ArrayList<Substitution> substList = this.parseSubstitutionsString(substitutionsStr);
            for (Substitution subst : substList) {
                ms.addSubstitution(subst);
            }
        } else if (GlycanNamescheme.GLYCOCT.equals((Object)this.getNamescheme())) {
            this.parseBasetypeString(name, ms);
        } else {
            throw new MonosaccharideException("Namescheme " + (Object)((Object)this.getNamescheme()) + " not supported in GlycoCTImporter.");
        }
        if (this.getConfig().isBuildMsDerivedData()) {
            MonosaccharideDataBuilder.buildDerivativeData(ms, this.getTemplateContainer());
        }
        MonosaccharideValidation.checkMonosaccharideConsistency(ms, this.getTemplateContainer(), this.getConfig());
        this.setFoundMs(true);
    }

    private void parseBasetypeString(String basetypeName, Monosaccharide ms) throws ResourcesDbException {
        EcdbResidueParser parser = new EcdbResidueParser(this.getNamescheme());
        EcdbMonosaccharide ecdbMs = parser.createEcdbResidue(basetypeName);
        BasetypeConversion.eurocarbdbToMsdb(ecdbMs, ms);
    }

    private ArrayList<Substitution> parseSubstitutionsString(String nameStr) throws ResourcesDbException {
        if (nameStr != null && nameStr.length() > 0 && !nameStr.endsWith("|")) {
            nameStr = nameStr + "|";
        }
        ArrayList<Substitution> substList = new ArrayList<Substitution>();
        if (nameStr != null && nameStr.length() > 0) {
            int separatorPos = nameStr.indexOf("|");
            while (separatorPos >= 0) {
                String substStr = nameStr.substring(0, separatorPos);
                Substitution subst = this.parseSingleSubstitutionString(substStr);
                if (subst != null) {
                    substList.add(subst);
                }
                nameStr = nameStr.substring(separatorPos + 1);
                this.substitutionStartPosition += separatorPos + 1;
                separatorPos = nameStr.indexOf("|");
            }
        }
        return substList;
    }

    private Substitution parseSingleSubstitutionString(String name) throws ResourcesDbException {
        Substitution subst = null;
        if (name != null && name.length() > 0) {
            this.substitutionStr = name;
            this.substitutionParsingPosition = -1;
            subst = new Substitution();
            this.nextSubstitutionToken();
            if (this.substitutionToken != '(') {
                throw new NameParsingException("Unexpected token: '" + this.substitutionToken + "'", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
            }
            this.nextSubstitutionToken();
            ArrayList<Integer> msPositionList = this.parsePositionsString();
            subst.setPosition1(msPositionList);
            subst.setLinkagetype1(this.parseLinkageType());
            this.nextSubstitutionToken();
            if (this.substitutionToken != ':') {
                throw new NameParsingException("Unexpected token: '" + this.substitutionToken + "'", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
            }
            this.nextSubstitutionToken();
            ArrayList<Integer> substPositionList = this.parsePositionsString();
            subst.setSubstituentPosition1(substPositionList);
            if (this.substitutionToken == ',') {
                ArrayList<Integer> msPositionList2 = this.parsePositionsString();
                subst.setPosition2(msPositionList2);
                subst.setLinkagetype2(this.parseLinkageType());
                if (this.getNextSubstitutionToken() != ':') {
                    throw new NameParsingException("Unexpected token: '" + this.substitutionToken + "'", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
                }
                ArrayList<Integer> substPositionList2 = this.parsePositionsString();
                subst.setSubstituentPosition2(substPositionList2);
            }
            if (this.substitutionToken != ')') {
                throw new NameParsingException("Unexpected token: '" + this.substitutionToken + "'", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
            }
            this.nextSubstitutionToken();
            int substNameStart = this.substitutionParsingPosition;
            String substName = this.parseSubstituentName();
            SubstituentTemplate substTmpl = this.getTemplateContainer().getSubstituentTemplateContainer().forName(GlycanNamescheme.GLYCOCT, substName);
            if (substTmpl == null) {
                throw new NameParsingException("unknown substituent", this.getInputName(), this.substitutionStartPosition + substNameStart);
            }
            subst.setTemplate(substTmpl);
        }
        return subst;
    }

    private ArrayList<Integer> parsePositionsString() throws NameParsingException {
        ArrayList<Integer> posList = new ArrayList<Integer>();
        int pos = this.parseNumber();
        posList.add(new Integer(pos));
        while (this.substitutionToken == '/') {
            this.nextSubstitutionToken();
            pos = this.parseNumber();
            posList.add(new Integer(pos));
        }
        return posList;
    }

    private LinkageType parseLinkageType() throws NameParsingException {
        LinkageType linktype = null;
        try {
            linktype = LinkageType.forName(this.substitutionToken);
        }
        catch (GlycoconjugateException ge) {
            throw new NameParsingException("Cannot get linkage type from substitution string", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
        }
        return linktype;
    }

    private String parseSubstituentName() {
        String outStr = "";
        while (this.substitutionToken != '|') {
            outStr = outStr + this.substitutionToken;
            try {
                this.nextSubstitutionToken();
            }
            catch (NameParsingException npe) {
                break;
            }
        }
        return outStr;
    }

    private int parseNumber() throws NameParsingException {
        int result = 0;
        char digit = '\u0000';
        if (this.substitutionToken == '0') {
            this.nextSubstitutionToken();
            return 0;
        }
        digit = this.substitutionToken;
        if (digit < '1' || digit > '9') {
            throw new NameParsingException("number expected ", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
        }
        result = digit - 48;
        this.nextSubstitutionToken();
        digit = this.substitutionToken;
        while (digit > '/' && digit < ':') {
            result = result * 10 + (digit - 48);
            this.nextSubstitutionToken();
            digit = this.substitutionToken;
        }
        return result;
    }

    private boolean hasNextSubstitutionToken() {
        return this.substitutionStr != null && this.substitutionStr.length() > this.substitutionParsingPosition + 1;
    }

    private void nextSubstitutionToken() throws NameParsingException {
        if (this.hasNextSubstitutionToken()) {
            ++this.substitutionParsingPosition;
        } else {
            throw new NameParsingException("unexpected end of string", this.getInputName(), this.substitutionStartPosition + this.substitutionParsingPosition);
        }
        this.substitutionToken = this.substitutionStr.charAt(this.substitutionParsingPosition);
    }

    private char getNextSubstitutionToken() throws NameParsingException {
        this.nextSubstitutionToken();
        return this.substitutionToken;
    }

    @Override
    public void init() {
        this.setInputName("");
        this.setFoundMs(false);
    }
}

