/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.util;

import java.util.ArrayList;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;

public class Utils {
    public static String formatPositionsString(ArrayList<Integer> positions, String delimiter, String unknownPositionLabel) {
        String outStr = "";
        if (positions != null && positions.size() > 0) {
            Integer pos0 = positions.get(0);
            outStr = pos0 == 0 ? outStr + unknownPositionLabel : outStr + pos0;
            for (int i = 1; i < positions.size(); ++i) {
                outStr = outStr + delimiter + positions.get(i);
            }
        } else {
            outStr = unknownPositionLabel;
        }
        return outStr;
    }

    public static ArrayList<Integer> cloneIntegerList(ArrayList<Integer> sourceList) {
        ArrayList<Integer> outputList = new ArrayList<Integer>();
        for (Integer position : sourceList) {
            outputList.add(new Integer(position));
        }
        return outputList;
    }

    public static Boolean parseTrueFalseString(String str, Boolean defaultValue) {
        if (str != null) {
            if (str.equalsIgnoreCase("true")) {
                return new Boolean(true);
            }
            if (str.equalsIgnoreCase("false")) {
                return new Boolean(false);
            }
            if (str.equalsIgnoreCase("yes")) {
                return new Boolean(true);
            }
            if (str.equalsIgnoreCase("no")) {
                return new Boolean(false);
            }
        }
        return defaultValue;
    }

    public static void setTemplateDataIfNotSet(Config conf) throws ResourcesDbException {
    }

    public static void setTemplateDataIfNotSet() throws ResourcesDbException {
        Utils.setTemplateDataIfNotSet(Config.getGlobalConfig());
    }
}

